/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.predefined.wasi.FlagUtils;
import org.graalvm.wasm.predefined.wasi.fd.DirectoryFd;
import org.graalvm.wasm.predefined.wasi.fd.FdManager;
import org.graalvm.wasm.predefined.wasi.fd.PreopenedDirectory;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Preopentype;
import org.graalvm.wasm.predefined.wasi.types.Prestat;
import org.graalvm.wasm.predefined.wasi.types.PrestatDir;
import org.graalvm.wasm.predefined.wasi.types.Rights;

final class PreopenedDirectoryFd
extends DirectoryFd {
    private static final long FS_RIGHTS_BASE;
    private static final long FS_RIGHTS_INHERITING;
    private static final short FS_FLAGS = 0;
    private final String virtualPath;

    PreopenedDirectoryFd(FdManager fdManager, TruffleFile hostFile, TruffleFile virtualFile, String virtualPath) {
        super(fdManager, virtualFile, new PreopenedDirectory(hostFile, virtualFile), FS_RIGHTS_BASE, FS_RIGHTS_INHERITING, (short)0);
        this.virtualPath = virtualPath;
    }

    @Override
    public Errno prestatGet(Node node, WasmMemory memory, int prestatAddress) {
        WasmMemoryLibrary memoryLib = WasmMemoryLibrary.getUncached();
        Prestat.writeTag(node, memoryLib, memory, prestatAddress, Preopentype.Dir);
        int prestatDirAddress = prestatAddress + 4;
        PrestatDir.writePrNameLen(node, memoryLib, memory, prestatDirAddress, WasmMemory.encodedStringLength(this.virtualPath));
        return Errno.Success;
    }

    @Override
    public Errno prestatDirName(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        memory.writeString(node, this.virtualPath, pathAddress, pathLength);
        return Errno.Success;
    }

    static {
        FS_RIGHTS_INHERITING = FS_RIGHTS_BASE = FlagUtils.allFlagsSet(Rights.class);
    }
}

