/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.fd.FdManager;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiPathLinkNode
extends WasmBuiltinRootNode {
    public WasiPathLinkNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.pathLink(instance.store(), this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1), (Integer)WasmArguments.getArgument(args, 2), (Integer)WasmArguments.getArgument(args, 3), (Integer)WasmArguments.getArgument(args, 4), (Integer)WasmArguments.getArgument(args, 5), (Integer)WasmArguments.getArgument(args, 6));
    }

    @CompilerDirectives.TruffleBoundary
    private int pathLink(WasmStore store, WasmMemory memory, int oldFd, int oldFlags, int oldPathAddress, int oldPathLength, int newFd, int newPathAddress, int newPathLength) {
        FdManager fdManager = store.fdManager();
        Fd oldHandle = fdManager.get(oldFd);
        Fd newHandle = fdManager.get(newFd);
        if (oldHandle == null || newHandle == null) {
            return Errno.Badf.ordinal();
        }
        return oldHandle.pathLink((Node)this, memory, oldFlags, oldPathAddress, oldPathLength, newHandle, newPathAddress, newPathLength).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_path_link";
    }
}

