/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.validation;

import org.graalvm.wasm.WasmType;
import org.graalvm.wasm.parser.bytecode.RuntimeBytecodeGen;
import org.graalvm.wasm.parser.validation.ParserState;

public abstract class ControlFrame {
    private final byte[] paramTypes;
    private final byte[] resultTypes;
    private final int initialStackSize;
    private boolean unreachable;
    private final int commonResultType;

    ControlFrame(byte[] paramTypes, byte[] resultTypes, int initialStackSize, boolean unreachable) {
        this.paramTypes = paramTypes;
        this.resultTypes = resultTypes;
        this.initialStackSize = initialStackSize;
        this.unreachable = unreachable;
        this.commonResultType = WasmType.getCommonValueType(resultTypes);
    }

    protected byte[] paramTypes() {
        return this.paramTypes;
    }

    public byte[] resultTypes() {
        return this.resultTypes;
    }

    protected int resultTypeLength() {
        return this.resultTypes.length;
    }

    protected int commonResultType() {
        return this.commonResultType;
    }

    abstract byte[] labelTypes();

    protected int labelTypeLength() {
        return this.labelTypes().length;
    }

    int initialStackSize() {
        return this.initialStackSize;
    }

    void setUnreachable() {
        this.unreachable = true;
    }

    boolean isUnreachable() {
        return this.unreachable;
    }

    protected void resetUnreachable() {
        this.unreachable = false;
    }

    abstract void enterElse(ParserState var1, RuntimeBytecodeGen var2);

    abstract void exit(RuntimeBytecodeGen var1);

    abstract void addBranch(RuntimeBytecodeGen var1);

    abstract void addBranchIf(RuntimeBytecodeGen var1);

    abstract void addBranchTableItem(RuntimeBytecodeGen var1);
}

