/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import org.graalvm.wasm.nodes.WasmCallNode;
import org.graalvm.wasm.nodes.WasmIndirectCallNodeGen;

@GenerateInline(value=false)
public abstract class WasmIndirectCallNode
extends WasmCallNode {
    static final int INLINE_CACHE_LIMIT = 5;

    protected WasmIndirectCallNode(int bytecodeOffset) {
        super(bytecodeOffset);
    }

    public abstract Object execute(CallTarget var1, Object[] var2);

    @Specialization(guards={"target == cachedTarget"}, limit="INLINE_CACHE_LIMIT")
    final Object doCached(CallTarget target, Object[] args, @Cached(value="target") CallTarget cachedTarget) {
        return cachedTarget.call((Node)this, args);
    }

    @Specialization(replaces={"doCached"})
    final Object doIndirect(CallTarget target, Object[] args) {
        return target.call((Node)this, args);
    }

    @NeverDefault
    public static WasmIndirectCallNode create(int bytecodeOffset) {
        return WasmIndirectCallNodeGen.create(bytecodeOffset);
    }

    @NeverDefault
    public static WasmIndirectCallNode create() {
        return WasmIndirectCallNode.create(-1);
    }

    @NeverDefault
    public static WasmIndirectCallNode getUncached() {
        return Uncached.UNCACHED;
    }

    @DenyReplace
    @GenerateCached(value=false)
    private static final class Uncached
    extends WasmIndirectCallNode
    implements UnadoptableNode {
        static final Uncached UNCACHED = new Uncached();

        private Uncached() {
            super(-1);
        }

        @Override
        public Object execute(CallTarget arg0Value, Object[] arg1Value) {
            return this.doIndirect(arg0Value, arg1Value);
        }
    }
}

