/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.representation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.ArrayList;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.representation.DebugDisplayValue;
import org.graalvm.wasm.debugging.representation.WasmVariableNamesObject;

@ExportLibrary(value=InteropLibrary.class)
public final class DebugObjectDisplayValue
extends DebugDisplayValue
implements TruffleObject {
    private final DebugContext context;
    private final DebugLocation location;
    private final String name;
    private final EconomicMap<String, DebugObject> members;

    private DebugObjectDisplayValue(DebugContext context, DebugLocation location, String name, EconomicMap<String, DebugObject> members) {
        assert (context != null) : "the context provided to a debug object display value must not be null";
        assert (location != null) : "the location provided to a debug object display value must not be null";
        assert (members != null) : "the list of members provided to a debug object display value must not be null";
        this.context = context;
        this.location = location;
        this.name = name;
        this.members = members;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object fromDebugObject(DebugObject object, DebugContext context, DebugLocation location) {
        EconomicMap members = EconomicMap.create();
        int count = object.memberCount();
        for (int i = 0; i < count; ++i) {
            DebugObject member = object.readMember(context, location, i);
            if (!member.isVisible(context.sourceCodeLocation())) continue;
            members.put((Object)member.toDisplayString(), (Object)member);
        }
        return new DebugObjectDisplayValue(context, location, object.toString(), (EconomicMap<String, DebugObject>)members);
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return WasmLanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.name != null ? this.name : "";
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        if (!this.isMemberReadable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        DebugObject memberObject = (DebugObject)this.members.get((Object)member);
        return this.resolveDebugObject(memberObject, this.context, this.location);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        ArrayList<String> names = new ArrayList<String>(this.members.size());
        for (String member : this.members.getKeys()) {
            names.add(member);
        }
        return new WasmVariableNamesObject(names);
    }

    @ExportMessage.Repeat(value={@ExportMessage, @ExportMessage(name="isMemberModifiable")})
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        return this.members.containsKey((Object)member);
    }

    @ExportMessage(limit="5")
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value, @CachedLibrary(value="value") InteropLibrary lib) throws UnknownIdentifierException {
        if (!this.isMemberReadable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        DebugObject memberObject = (DebugObject)this.members.get((Object)member);
        this.writeDebugObject(memberObject, this.context, this.location, value, lib);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInsertable(String member) {
        return false;
    }
}

