/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugConstantObject;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;

public class DebugPointerToMemberType
extends DebugType {
    private final DebugType baseType;
    private final DebugType containingType;

    public DebugPointerToMemberType(DebugType baseType, DebugType containingType) {
        this.baseType = baseType;
        this.containingType = containingType;
    }

    @Override
    public String asTypeName() {
        StringBuilder builder = new StringBuilder();
        builder.append("&");
        if (this.containingType != null) {
            builder.append(this.containingType.asTypeName());
            builder.append("::");
        }
        if (this.baseType != null) {
            builder.append(this.baseType.asTypeName());
        }
        return builder.toString();
    }

    @Override
    public int valueLength() {
        return 4;
    }

    @Override
    public boolean hasMembers() {
        return true;
    }

    @Override
    public int memberCount() {
        return 1;
    }

    @Override
    public DebugObject readMember(DebugContext context, DebugLocation location, int index) {
        String name = "*" + context.elementNameOrEmpty();
        return new DebugConstantObject(name, new DebugConstantDisplayValue(this.asTypeName()));
    }
}

