/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;

public class DebugEnumType
extends DebugType {
    private final String typeName;
    private final DebugType baseType;
    private final EconomicMap<Long, String> values;

    public DebugEnumType(String typeName, DebugType baseType, EconomicMap<Long, String> values) {
        assert (baseType != null) : "the base type (underlying representation) of an enum type must not be null";
        assert (values != null) : "the possible values of an enum type must not be null";
        this.typeName = typeName;
        this.baseType = baseType;
        this.values = values;
    }

    @Override
    public String asTypeName() {
        return this.typeName;
    }

    @Override
    public int valueLength() {
        return this.baseType.valueLength();
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        if (!this.baseType.fitsIntoLong()) {
            return DebugConstantDisplayValue.UNSUPPORTED;
        }
        long index = this.baseType.asLong(context, location);
        if (this.values.containsKey((Object)index)) {
            return new DebugConstantDisplayValue((String)this.values.get((Object)index));
        }
        return new DebugConstantDisplayValue("undefined(" + index + ")");
    }
}

