/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.api.Vector128OpsFallback;
import org.graalvm.wasm.api.Vector128OpsVectorAPI;

public interface Vector128Ops<V128> {
    public static final Vector128Ops<?> SINGLETON_IMPLEMENTATION = Vector128Ops.lookupImplementation();

    private static Vector128Ops<?> lookupImplementation() {
        if (ModuleLayer.boot().findModule("jdk.incubator.vector").isPresent()) {
            try {
                return Vector128OpsVectorAPI.create();
            }
            catch (NoClassDefFoundError | UnsupportedOperationException throwable) {
                // empty catch block
            }
        }
        return Vector128OpsFallback.create();
    }

    public V128 unary(V128 var1, int var2);

    public V128 binary(V128 var1, V128 var2, int var3);

    public V128 ternary(V128 var1, V128 var2, V128 var3, int var4);

    public int vectorToInt(V128 var1, int var2);

    public V128 shift(V128 var1, int var2, int var3);

    public V128 v128_load8x8(long var1, int var3);

    public V128 v128_load16x4(long var1, int var3);

    public V128 v128_load32x2(long var1, int var3);

    public V128 v128_load32_zero(int var1);

    public V128 v128_load64_zero(long var1);

    public V128 i8x16_splat(byte var1);

    public V128 i16x8_splat(short var1);

    public V128 i32x4_splat(int var1);

    public V128 i64x2_splat(long var1);

    public V128 f32x4_splat(float var1);

    public V128 f64x2_splat(double var1);

    public V128 i8x16_shuffle(V128 var1, V128 var2, V128 var3);

    public byte i8x16_extract_lane_s(V128 var1, int var2);

    public int i8x16_extract_lane(V128 var1, int var2, int var3);

    public V128 i8x16_replace_lane(V128 var1, int var2, byte var3);

    public short i16x8_extract_lane_s(V128 var1, int var2);

    public int i16x8_extract_lane(V128 var1, int var2, int var3);

    public V128 i16x8_replace_lane(V128 var1, int var2, short var3);

    public int i32x4_extract_lane(V128 var1, int var2);

    public V128 i32x4_replace_lane(V128 var1, int var2, int var3);

    public long i64x2_extract_lane(V128 var1, int var2);

    public V128 i64x2_replace_lane(V128 var1, int var2, long var3);

    public float f32x4_extract_lane(V128 var1, int var2);

    public V128 f32x4_replace_lane(V128 var1, int var2, float var3);

    public double f64x2_extract_lane(V128 var1, int var2);

    public V128 f64x2_replace_lane(V128 var1, int var2, double var3);

    default public V128 fromArray(byte[] bytes) {
        return this.fromArray(bytes, 0);
    }

    public V128 fromArray(byte[] var1, int var2);

    public byte[] toArray(V128 var1);

    public void intoArray(V128 var1, byte[] var2, int var3);

    public Vector128 toVector128(V128 var1);

    public V128 fromVector128(Vector128 var1);

    public static <T> T cast(Object vec) {
        return (T)vec;
    }
}

