/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import java.util.Objects;
import org.graalvm.wasm.EmbedderDataHolder;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmStore;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmFunctionInstance
extends EmbedderDataHolder
implements TruffleObject {
    private final WasmContext context;
    private final WasmInstance moduleInstance;
    private final WasmFunction function;
    private final CallTarget target;
    private Object importedFunction;

    public WasmFunctionInstance(WasmInstance moduleInstance, WasmFunction function, CallTarget target) {
        this(moduleInstance.context(), moduleInstance, function, target);
    }

    public WasmFunctionInstance(WasmContext context, WasmInstance moduleInstance, WasmFunction function, CallTarget target) {
        this.context = Objects.requireNonNull(context, "context must be non-null");
        this.moduleInstance = Objects.requireNonNull(moduleInstance, "module instance must be non-null");
        this.function = Objects.requireNonNull(function, "function must be non-null");
        this.target = Objects.requireNonNull(target, "Call target must be non-null");
        assert (((RootCallTarget)target).getRootNode().getLanguage(WasmLanguage.class) == context.language());
    }

    public String toString() {
        return this.name();
    }

    public WasmStore store() {
        return this.moduleInstance.store();
    }

    public WasmContext context() {
        return this.context;
    }

    public TruffleContext getTruffleContext() {
        return this.context.environment().getContext();
    }

    public WasmInstance moduleInstance() {
        return this.moduleInstance;
    }

    @CompilerDirectives.TruffleBoundary
    public String name() {
        if (this.function == null) {
            return this.target.toString();
        }
        return this.function.name();
    }

    public WasmFunction function() {
        return this.function;
    }

    public CallTarget target() {
        return this.target;
    }

    public void setImportedFunction(Object importedFunction) {
        this.importedFunction = importedFunction;
    }

    public Object getImportedFunction() {
        return this.importedFunction;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        private static Object execute(WasmFunctionInstance functionInstance, Object[] arguments, CallTarget callAdapter, Node callNode) {
            return callAdapter.call(callNode, WasmArguments.create(functionInstance, arguments));
        }

        @Specialization(guards={"actualFunction == cachedFunction"}, limit="2")
        static Object direct(WasmFunctionInstance functionInstance, Object[] arguments, @Bind(value="functionInstance.function()") WasmFunction actualFunction, @Cached(value="actualFunction") WasmFunction cachedFunction, @Cached(value="getOrCreateInteropCallAdapter(functionInstance)") CallTarget cachedCallAdapter, @Bind Node node) {
            return Execute.execute(functionInstance, arguments, cachedCallAdapter, node);
        }

        @Specialization(guards={"actualCallAdapter == cachedCallAdapter"}, limit="3", replaces={"direct"})
        static Object directAdapter(WasmFunctionInstance functionInstance, Object[] arguments, @Bind(value="getOrCreateInteropCallAdapter(functionInstance)") CallTarget actualCallAdapter, @Cached(value="actualCallAdapter") CallTarget cachedCallAdapter, @Bind Node node) {
            return Execute.execute(functionInstance, arguments, cachedCallAdapter, node);
        }

        @Specialization(replaces={"directAdapter"})
        static Object indirect(WasmFunctionInstance functionInstance, Object[] arguments, @Bind Node node) {
            CallTarget callAdapter = Execute.getOrCreateInteropCallAdapter(functionInstance);
            Node callNode = node.isAdoptable() ? node : EncapsulatingNodeReference.getCurrent().get();
            return Execute.execute(functionInstance, arguments, callAdapter, callNode);
        }

        static CallTarget getOrCreateInteropCallAdapter(WasmFunctionInstance functionInstance) {
            WasmFunction function = functionInstance.function();
            CallTarget callAdapter = function.getInteropCallAdapter();
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (callAdapter == null ? 1 : 0) != 0)) {
                return function.getOrCreateInteropCallAdapter(functionInstance.context().language());
            }
            return callAdapter;
        }
    }
}

