/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import org.graalvm.wasm.WasmInstance;

public final class WasmArguments {
    public static final int RUNTIME_ARGUMENT_COUNT = 1;
    private static final int MODULE_INSTANCE_ARGUMENT_INDEX = 0;

    private WasmArguments() {
    }

    public static Object[] createEmpty(int formalArgumentCount) {
        return new Object[1 + formalArgumentCount];
    }

    public static Object[] create(Object instance, Object ... formalArguments) {
        Object[] arguments = new Object[1 + formalArguments.length];
        arguments[0] = instance;
        WasmArguments.setArguments(arguments, 0, formalArguments);
        return arguments;
    }

    public static int getArgumentCount(Object[] arguments) {
        return arguments.length - 1;
    }

    public static Object getArgument(Object[] arguments, int index) {
        return arguments[index + 1];
    }

    public static void setArgument(Object[] arguments, int index, Object value) {
        arguments[index + 1] = value;
    }

    public static Object[] getArguments(Object[] arguments) {
        Object[] userArguments = new Object[arguments.length - 1];
        System.arraycopy(arguments, 1, userArguments, 0, userArguments.length);
        return userArguments;
    }

    public static void setArguments(Object[] arguments, int index, Object[] formalArguments) {
        System.arraycopy(formalArguments, 0, arguments, 1 + index, formalArguments.length);
    }

    public static WasmInstance getModuleInstance(Object[] arguments) {
        return (WasmInstance)arguments[0];
    }

    public static void setModuleInstance(Object[] arguments, WasmInstance instance) {
        arguments[0] = instance;
    }

    public static boolean isValid(Object[] arguments) {
        return arguments.length >= 1 && arguments[0] instanceof WasmInstance;
    }
}

