/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.wasm.WasmTable;

public class TableRegistry {
    private static final int INITIAL_TABLES_SIZE = 8;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private WasmTable[] tables = new WasmTable[8];
    private int numTables = 0;

    private void ensureCapacity() {
        if (this.numTables == this.tables.length) {
            WasmTable[] updatedTables = new WasmTable[this.tables.length * 2];
            System.arraycopy(this.tables, 0, updatedTables, 0, this.tables.length);
            this.tables = updatedTables;
        }
    }

    public int tableCount() {
        return this.numTables;
    }

    public int register(WasmTable table) {
        this.ensureCapacity();
        int index = this.numTables++;
        this.tables[index] = table;
        return index;
    }

    public int registerExternal(WasmTable table) {
        return this.register(table);
    }

    public WasmTable table(int index) {
        assert (index < this.numTables);
        return this.tables[index];
    }
}

