/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.wasm.Assert;
import org.graalvm.wasm.ImportDescriptor;
import org.graalvm.wasm.WasmCustomSection;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmMath;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmTable;
import org.graalvm.wasm.WasmType;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryFactory;

public abstract class SymbolTable {
    private static final int INITIAL_GLOBALS_SIZE = 64;
    private static final int INITIAL_GLOBALS_BYTECODE_SIZE = 16;
    private static final int INITIAL_TABLE_SIZE = 1;
    private static final int INITIAL_MEMORY_SIZE = 1;
    private static final int INITIAL_DATA_SIZE = 512;
    private static final int INITIAL_TYPE_SIZE = 128;
    private static final int INITIAL_FUNCTION_TYPES_SIZE = 128;
    private static final byte GLOBAL_MUTABLE_BIT = 1;
    private static final byte GLOBAL_EXPORTED_BIT = 2;
    private static final byte GLOBAL_INITIALIZED_BIT = 4;
    private static final byte GLOBAL_IMPORTED_BIT = 16;
    private static final byte GLOBAL_FUNCTION_INITIALIZER_BIT = 32;
    public static final int UNINITIALIZED_ADDRESS = Integer.MIN_VALUE;
    private static final int NO_EQUIVALENCE_CLASS = 0;
    static final int FIRST_EQUIVALENCE_CLASS = 1;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] typeData;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] typeOffsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] typeEquivalenceClasses;
    @CompilerDirectives.CompilationFinal
    private int typeDataSize;
    @CompilerDirectives.CompilationFinal
    private int typeCount;
    private final List<ImportDescriptor> importedSymbols;
    private final List<String> exportedSymbols;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private WasmFunction[] functions;
    @CompilerDirectives.CompilationFinal
    private int numFunctions;
    private final List<WasmFunction> importedFunctions;
    @CompilerDirectives.CompilationFinal
    private int numImportedFunctions;
    private final EconomicMap<String, WasmFunction> exportedFunctions;
    private final EconomicMap<Integer, String> exportedFunctionsByIndex;
    @CompilerDirectives.CompilationFinal
    private int startFunctionIndex;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] globalTypes;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Object[] globalInitializers;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private byte[][] globalInitializersBytecode;
    @CompilerDirectives.CompilationFinal
    private final EconomicMap<Integer, ImportDescriptor> importedGlobals;
    @CompilerDirectives.CompilationFinal
    private final EconomicMap<String, Integer> exportedGlobals;
    @CompilerDirectives.CompilationFinal
    private int numGlobals;
    @CompilerDirectives.CompilationFinal
    private int numExternalGlobals;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] globalAddresses;
    @CompilerDirectives.CompilationFinal
    private int numGlobalInitializersBytecode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private TableInfo[] tables;
    @CompilerDirectives.CompilationFinal
    private int tableCount;
    @CompilerDirectives.CompilationFinal
    private final EconomicMap<Integer, ImportDescriptor> importedTables;
    @CompilerDirectives.CompilationFinal
    private final EconomicMap<String, Integer> exportedTables;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private MemoryInfo[] memories;
    @CompilerDirectives.CompilationFinal
    private int memoryCount;
    @CompilerDirectives.CompilationFinal
    private final EconomicMap<Integer, ImportDescriptor> importedMemories;
    @CompilerDirectives.CompilationFinal
    private final EconomicMap<String, Integer> exportedMemories;
    private final List<WasmCustomSection> customSections;
    @CompilerDirectives.CompilationFinal
    private int elemSegmentCount;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] dataInstances;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private long[] elemInstances;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] codeEntries;
    @CompilerDirectives.CompilationFinal
    private boolean dataCountExists;
    @CompilerDirectives.CompilationFinal
    private int dataSegmentCount;
    @CompilerDirectives.CompilationFinal
    private int droppedDataInstanceOffset;
    @CompilerDirectives.CompilationFinal
    private int codeEntryCount;
    @CompilerDirectives.CompilationFinal
    private EconomicSet<Integer> functionReferences;

    SymbolTable() {
        CompilerAsserts.neverPartOfCompilation();
        this.typeData = new int[512];
        this.typeOffsets = new int[128];
        this.typeEquivalenceClasses = new int[128];
        this.typeDataSize = 0;
        this.typeCount = 0;
        this.importedSymbols = new ArrayList<ImportDescriptor>();
        this.exportedSymbols = new ArrayList<String>();
        this.functions = new WasmFunction[128];
        this.numFunctions = 0;
        this.importedFunctions = new ArrayList<WasmFunction>();
        this.numImportedFunctions = 0;
        this.exportedFunctions = EconomicMap.create();
        this.exportedFunctionsByIndex = EconomicMap.create();
        this.startFunctionIndex = -1;
        this.globalTypes = new byte[128];
        this.globalInitializers = new Object[64];
        this.globalInitializersBytecode = new byte[16][];
        this.importedGlobals = EconomicMap.create();
        this.exportedGlobals = EconomicMap.create();
        this.numGlobals = 0;
        this.tables = new TableInfo[1];
        this.tableCount = 0;
        this.importedTables = EconomicMap.create();
        this.exportedTables = EconomicMap.create();
        this.memories = new MemoryInfo[1];
        this.memoryCount = 0;
        this.importedMemories = EconomicMap.create();
        this.exportedMemories = EconomicMap.create();
        this.customSections = new ArrayList<WasmCustomSection>();
        this.elemSegmentCount = 0;
        this.dataCountExists = false;
        this.dataSegmentCount = 0;
        this.functionReferences = EconomicSet.create();
        this.dataInstances = null;
    }

    private void checkNotParsed() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.module().isParsed()) {
            throw CompilerDirectives.shouldNotReachHere((String)"The engine tried to modify the symbol table after parsing.");
        }
    }

    private void checkUniqueExport(String name) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.exportedFunctions.containsKey((Object)name) || this.exportedGlobals.containsKey((Object)name) || this.exportedMemories.containsKey((Object)name) || this.exportedTables.containsKey((Object)name)) {
            throw WasmException.create(Failure.DUPLICATE_EXPORT, "All export names must be different, but '" + name + "' is exported twice.");
        }
    }

    public void checkFunctionIndex(int funcIndex) {
        Assert.assertUnsignedIntLess(funcIndex, this.numFunctions, Failure.UNKNOWN_FUNCTION);
    }

    private static int[] reallocate(int[] array, int currentSize, int newLength) {
        int[] newArray = new int[newLength];
        System.arraycopy(array, 0, newArray, 0, currentSize);
        return newArray;
    }

    private static WasmFunction[] reallocate(WasmFunction[] array, int currentSize, int newLength) {
        WasmFunction[] newArray = new WasmFunction[newLength];
        System.arraycopy(array, 0, newArray, 0, currentSize);
        return newArray;
    }

    private void ensureTypeDataCapacity(int index) {
        if (this.typeData.length <= index) {
            int newLength = Math.max(Integer.highestOneBit(index) << 1, 2 * this.typeData.length);
            this.typeData = SymbolTable.reallocate(this.typeData, this.typeDataSize, newLength);
        }
    }

    private void ensureTypeCapacity(int index) {
        if (this.typeOffsets.length <= index) {
            int newLength = Math.max(Integer.highestOneBit(index) << 1, 2 * this.typeOffsets.length);
            this.typeOffsets = SymbolTable.reallocate(this.typeOffsets, this.typeCount, newLength);
            this.typeEquivalenceClasses = SymbolTable.reallocate(this.typeEquivalenceClasses, this.typeCount, newLength);
        }
    }

    int allocateFunctionType(int paramCount, int resultCount, boolean isMultiValue) {
        this.checkNotParsed();
        this.ensureTypeCapacity(this.typeCount);
        int typeIdx = this.typeCount++;
        this.typeOffsets[typeIdx] = this.typeDataSize;
        if (!isMultiValue && resultCount != 0 && resultCount != 1) {
            throw WasmException.create(Failure.INVALID_RESULT_ARITY, "A function can return at most one result.");
        }
        int size = 2 + paramCount + resultCount;
        this.ensureTypeDataCapacity(this.typeDataSize + size);
        this.typeData[this.typeDataSize + 0] = paramCount;
        this.typeData[this.typeDataSize + 1] = resultCount;
        this.typeDataSize += size;
        return typeIdx;
    }

    public int allocateFunctionType(byte[] paramTypes, byte[] resultTypes, boolean isMultiValue) {
        int i;
        this.checkNotParsed();
        int typeIdx = this.allocateFunctionType(paramTypes.length, resultTypes.length, isMultiValue);
        for (i = 0; i < paramTypes.length; ++i) {
            this.registerFunctionTypeParameterType(typeIdx, i, paramTypes[i]);
        }
        for (i = 0; i < resultTypes.length; ++i) {
            this.registerFunctionTypeResultType(typeIdx, i, resultTypes[i]);
        }
        return typeIdx;
    }

    void registerFunctionTypeParameterType(int funcTypeIdx, int paramIdx, byte type) {
        this.checkNotParsed();
        int idx = 2 + this.typeOffsets[funcTypeIdx] + paramIdx;
        this.typeData[idx] = type;
    }

    void registerFunctionTypeResultType(int funcTypeIdx, int resultIdx, byte type) {
        this.checkNotParsed();
        int idx = 2 + this.typeOffsets[funcTypeIdx] + this.typeData[this.typeOffsets[funcTypeIdx]] + resultIdx;
        this.typeData[idx] = type;
    }

    public int equivalenceClass(int typeIndex) {
        return this.typeEquivalenceClasses[typeIndex];
    }

    void setEquivalenceClass(int index, int eqClass) {
        this.checkNotParsed();
        if (this.typeEquivalenceClasses[index] != 0) {
            throw WasmException.create(Failure.UNSPECIFIED_INVALID, "Type at index " + index + " already has an equivalence class.");
        }
        this.typeEquivalenceClasses[index] = eqClass;
    }

    private void ensureFunctionsCapacity(int index) {
        if (this.functions.length <= index) {
            int newLength = Math.max(Integer.highestOneBit(index) << 1, 2 * this.functions.length);
            this.functions = SymbolTable.reallocate(this.functions, this.numFunctions, newLength);
        }
    }

    private WasmFunction allocateFunction(int typeIndex, ImportDescriptor importDescriptor) {
        WasmFunction function;
        this.checkNotParsed();
        this.ensureFunctionsCapacity(this.numFunctions);
        Assert.assertUnsignedIntLess(typeIndex, this.typeCount(), Failure.UNKNOWN_TYPE);
        this.functions[this.numFunctions] = function = new WasmFunction(this, this.numFunctions, typeIndex, importDescriptor);
        ++this.numFunctions;
        return function;
    }

    public WasmFunction declareFunction(int typeIndex) {
        this.checkNotParsed();
        return this.allocateFunction(typeIndex, null);
    }

    public WasmFunction declareExportedFunction(int typeIndex, String exportedName) {
        this.checkNotParsed();
        WasmFunction function = this.declareFunction(typeIndex);
        this.exportFunction(function.index(), exportedName);
        return function;
    }

    String exportedFunctionName(int index) {
        return (String)this.exportedFunctionsByIndex.get((Object)index);
    }

    void setStartFunction(int functionIndex) {
        this.checkNotParsed();
        WasmFunction start = this.function(functionIndex);
        if (start.paramCount() != 0) {
            throw WasmException.create(Failure.START_FUNCTION_PARAMS, "Start function cannot take parameters.");
        }
        if (start.resultCount() != 0) {
            throw WasmException.create(Failure.START_FUNCTION_RESULT_VALUE, "Start function cannot return a value.");
        }
        this.startFunctionIndex = functionIndex;
    }

    public int numFunctions() {
        return this.numFunctions;
    }

    public WasmFunction function(int funcIndex) {
        assert (0 <= funcIndex && funcIndex <= this.numFunctions() - 1);
        return this.functions[funcIndex];
    }

    public WasmFunction function(String exportName) {
        return (WasmFunction)this.exportedFunctions.get((Object)exportName);
    }

    public int functionTypeParamCount(int typeIndex) {
        int typeOffset = this.typeOffsets[typeIndex];
        return this.typeData[typeOffset + 0];
    }

    public int functionTypeResultCount(int typeIndex) {
        int typeOffset = this.typeOffsets[typeIndex];
        return this.typeData[typeOffset + 1];
    }

    public WasmFunction startFunction() {
        if (this.startFunctionIndex == -1) {
            return null;
        }
        return this.function(this.startFunctionIndex);
    }

    protected abstract WasmModule module();

    public byte functionTypeParamTypeAt(int typeIndex, int i) {
        int typeOffset = this.typeOffsets[typeIndex];
        return (byte)this.typeData[typeOffset + 2 + i];
    }

    public byte functionTypeResultTypeAt(int typeIndex, int resultIndex) {
        int typeOffset = this.typeOffsets[typeIndex];
        int paramCount = this.typeData[typeOffset];
        return (byte)this.typeData[typeOffset + 2 + paramCount + resultIndex];
    }

    private byte[] functionTypeParamTypesAsArray(int typeIndex) {
        int paramCount = this.functionTypeParamCount(typeIndex);
        byte[] paramTypes = new byte[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            paramTypes[i] = this.functionTypeParamTypeAt(typeIndex, i);
        }
        return paramTypes;
    }

    private byte[] functionTypeResultTypesAsArray(int typeIndex) {
        int resultTypeCount = this.functionTypeResultCount(typeIndex);
        byte[] resultTypes = new byte[resultTypeCount];
        for (int i = 0; i < resultTypeCount; ++i) {
            resultTypes[i] = this.functionTypeResultTypeAt(typeIndex, i);
        }
        return resultTypes;
    }

    int typeCount() {
        return this.typeCount;
    }

    public FunctionType typeAt(int index) {
        return new FunctionType(this.functionTypeParamTypesAsArray(index), this.functionTypeResultTypesAsArray(index));
    }

    public void importSymbol(ImportDescriptor descriptor) {
        this.checkNotParsed();
        assert (this.importedSymbols.size() == descriptor.importedSymbolIndex());
        this.importedSymbols.add(descriptor);
    }

    public List<ImportDescriptor> importedSymbols() {
        return this.importedSymbols;
    }

    public int numImportedSymbols() {
        return this.importedSymbols.size();
    }

    protected void exportSymbol(String name) {
        this.checkNotParsed();
        this.checkUniqueExport(name);
        this.exportedSymbols.add(name);
    }

    public List<String> exportedSymbols() {
        return this.exportedSymbols;
    }

    public void exportFunction(int functionIndex, String exportName) {
        this.checkNotParsed();
        this.exportSymbol(exportName);
        this.exportedFunctions.put((Object)exportName, (Object)this.functions[functionIndex]);
        this.exportedFunctionsByIndex.put((Object)functionIndex, (Object)exportName);
        this.module().addLinkAction((context, store, instance, imports) -> store.linker().resolveFunctionExport(this.module(), functionIndex, exportName));
    }

    public EconomicMap<String, WasmFunction> exportedFunctions() {
        return this.exportedFunctions;
    }

    public WasmFunction importFunction(String moduleName, String functionName, int typeIndex) {
        this.checkNotParsed();
        ImportDescriptor descriptor = new ImportDescriptor(moduleName, functionName, 0, this.numFunctions, this.numImportedSymbols());
        this.importSymbol(descriptor);
        WasmFunction function = this.allocateFunction(typeIndex, descriptor);
        assert (function.index() == descriptor.targetIndex());
        this.importedFunctions.add(function);
        ++this.numImportedFunctions;
        this.module().addLinkAction((context, store, instance, imports) -> store.linker().resolveFunctionImport(store, instance, function, imports));
        return function;
    }

    public List<WasmFunction> importedFunctions() {
        return this.importedFunctions;
    }

    public int numImportedFunctions() {
        return this.numImportedFunctions;
    }

    public WasmFunction importedFunction(ImportDescriptor descriptor) {
        return this.functions[descriptor.targetIndex()];
    }

    private void ensureGlobalsCapacity(int index) {
        while (index >= this.globalInitializers.length) {
            byte[] nGlobalTypes = new byte[this.globalTypes.length * 2];
            Object[] nGlobalInitializers = new Object[this.globalInitializers.length * 2];
            System.arraycopy(this.globalTypes, 0, nGlobalTypes, 0, this.globalTypes.length);
            System.arraycopy(this.globalInitializers, 0, nGlobalInitializers, 0, this.globalInitializers.length);
            this.globalTypes = nGlobalTypes;
            this.globalInitializers = nGlobalInitializers;
        }
    }

    private void ensureGlobalInitializersBytecodeCapacity(int index) {
        while (index >= this.globalInitializersBytecode.length) {
            byte[][] nGlobalInitializersBytecode = new byte[this.globalInitializersBytecode.length * 2][];
            System.arraycopy(this.globalInitializersBytecode, 0, nGlobalInitializersBytecode, 0, this.globalInitializersBytecode.length);
            this.globalInitializersBytecode = nGlobalInitializersBytecode;
        }
    }

    void allocateGlobal(int index, byte valueType, byte mutability, boolean initialized, boolean imported, byte[] initBytecode, Object initialValue) {
        int flags;
        assert ((valueType & 0xFF) == valueType);
        this.checkNotParsed();
        this.ensureGlobalsCapacity(index);
        this.numGlobals = WasmMath.maxUnsigned(index + 1, this.numGlobals);
        if (mutability == 0) {
            flags = 0;
        } else if (mutability == 1) {
            flags = 1;
        } else {
            throw WasmException.create(Failure.UNSPECIFIED_INVALID, "Invalid mutability: " + mutability);
        }
        if (initialized) {
            flags = (byte)(flags | 4);
        }
        if (imported) {
            flags = (byte)(flags | 0x10);
            ++this.numExternalGlobals;
        }
        if (initBytecode == null) {
            flags = (byte)(flags | 0x20);
            this.globalInitializers[index] = initialValue;
        } else {
            int initBytecodeIndex = this.numGlobalInitializersBytecode++;
            this.ensureGlobalInitializersBytecodeCapacity(initBytecodeIndex);
            this.globalInitializersBytecode[initBytecodeIndex] = initBytecode;
            this.globalInitializers[index] = initBytecodeIndex;
        }
        this.globalTypes[2 * index] = valueType;
        this.globalTypes[2 * index + 1] = flags;
    }

    void declareGlobal(int index, byte valueType, byte mutability, boolean initialized, byte[] initBytecode, Object initialValue) {
        assert (initialized == (initBytecode == null)) : index;
        this.allocateGlobal(index, valueType, mutability, initialized, false, initBytecode, initialValue);
        this.module().addLinkAction((context, store, instance, imports) -> store.linker().resolveGlobalInitialization(instance, index, initBytecode, initialValue));
    }

    void importGlobal(String moduleName, String globalName, int index, byte valueType, byte mutability) {
        ImportDescriptor descriptor = new ImportDescriptor(moduleName, globalName, 3, index, this.numImportedSymbols());
        this.importedGlobals.put((Object)index, (Object)descriptor);
        this.importSymbol(descriptor);
        this.allocateGlobal(index, valueType, mutability, false, true, null, null);
        this.module().addLinkAction((context, store, instance, imports) -> store.linker().resolveGlobalImport(store, instance, descriptor, index, valueType, mutability, imports));
    }

    public EconomicMap<Integer, ImportDescriptor> importedGlobals() {
        return this.importedGlobals;
    }

    public EconomicMap<ImportDescriptor, Integer> importedGlobalDescriptors() {
        EconomicMap reverseMap = EconomicMap.create();
        MapCursor cursor = this.importedGlobals.getEntries();
        while (cursor.advance()) {
            reverseMap.put((Object)((ImportDescriptor)cursor.getValue()), (Object)((Integer)cursor.getKey()));
        }
        return reverseMap;
    }

    public int numGlobals() {
        return this.numGlobals;
    }

    public int numInternalGlobals() {
        return this.numGlobals - this.numExternalGlobals;
    }

    public int numExternalGlobals() {
        return this.numExternalGlobals;
    }

    public final int globalAddress(int index) {
        return this.globalAddresses[index];
    }

    public byte globalMutability(int index) {
        if ((this.globalFlags(index) & 1) != 0) {
            return 1;
        }
        return 0;
    }

    public boolean isGlobalMutable(int index) {
        return this.globalMutability(index) == 1;
    }

    public byte globalValueType(int index) {
        return this.globalTypes[2 * index];
    }

    private byte globalFlags(int index) {
        return this.globalTypes[2 * index + 1];
    }

    public boolean globalInitialized(int index) {
        return (this.globalFlags(index) & 4) != 0;
    }

    public byte[] globalInitializerBytecode(int index) {
        if ((this.globalFlags(index) & 0x20) != 0) {
            return null;
        }
        return this.globalInitializersBytecode[(Integer)this.globalInitializers[index]];
    }

    public Object globalInitialValue(int index) {
        if ((this.globalFlags(index) & 0x20) != 0) {
            return this.globalInitializers[index];
        }
        return 0;
    }

    public boolean globalImported(int index) {
        return (this.globalFlags(index) & 0x10) != 0;
    }

    public boolean globalExported(int index) {
        return (this.globalFlags(index) & 2) != 0;
    }

    public boolean globalExternal(int index) {
        return (this.globalFlags(index) & 0x12) != 0;
    }

    public EconomicMap<String, Integer> exportedGlobals() {
        return this.exportedGlobals;
    }

    void exportGlobal(String name, int index) {
        this.checkNotParsed();
        this.exportSymbol(name);
        if (!this.globalExternal(index)) {
            ++this.numExternalGlobals;
        }
        int n = 2 * index + 1;
        this.globalTypes[n] = (byte)(this.globalTypes[n] | 2);
        this.exportedGlobals.put((Object)name, (Object)index);
        this.module().addLinkAction((context, store, instance, imports) -> store.linker().resolveGlobalExport(instance.module(), name, index));
    }

    public void declareExportedGlobalWithValue(String name, int index, byte valueType, byte mutability, Object value) {
        this.checkNotParsed();
        this.declareGlobal(index, valueType, mutability, true, null, value);
        this.exportGlobal(name, index);
    }

    private void ensureTableCapacity(int index) {
        if (index >= this.tables.length) {
            TableInfo[] nTables = new TableInfo[Math.max(Integer.highestOneBit(index) << 1, 2 * this.tables.length)];
            System.arraycopy(this.tables, 0, nTables, 0, this.tables.length);
            this.tables = nTables;
        }
    }

    public void allocateTable(int index, int declaredMinSize, int declaredMaxSize, byte elemType, boolean referenceTypes) {
        this.checkNotParsed();
        this.addTable(index, declaredMinSize, declaredMaxSize, elemType, referenceTypes);
        this.module().addLinkAction((context, store, instance, imports) -> {
            int maxAllowedSize = WasmMath.minUnsigned(declaredMaxSize, this.module().limits().tableInstanceSizeLimit());
            this.module().limits().checkTableInstanceSize(declaredMinSize);
            WasmTable wasmTable = context.getContextOptions().memoryOverheadMode() ? new WasmTable(0, 0, 0, elemType) : new WasmTable(declaredMinSize, declaredMaxSize, maxAllowedSize, elemType);
            int address = store.tables().register(wasmTable);
            instance.setTableAddress(index, address);
        });
    }

    void importTable(String moduleName, String tableName, int index, int initSize, int maxSize, byte elemType, boolean referenceTypes) {
        this.checkNotParsed();
        this.addTable(index, initSize, maxSize, elemType, referenceTypes);
        ImportDescriptor importedTable = new ImportDescriptor(moduleName, tableName, 1, index, this.numImportedSymbols());
        this.importedTables.put((Object)index, (Object)importedTable);
        this.importSymbol(importedTable);
        this.module().addLinkAction((context, store, instance, imports) -> {
            instance.setTableAddress(index, Integer.MIN_VALUE);
            store.linker().resolveTableImport(store, instance, importedTable, index, initSize, maxSize, elemType, imports);
        });
    }

    void addTable(int index, int minSize, int maxSize, byte elemType, boolean referenceTypes) {
        TableInfo table;
        if (!referenceTypes) {
            Assert.assertTrue(this.importedTables.size() == 0, "A table has already been imported in the module.", Failure.MULTIPLE_TABLES);
            Assert.assertTrue(this.tableCount == 0, "A table has already been declared in the module.", Failure.MULTIPLE_TABLES);
        }
        this.ensureTableCapacity(index);
        this.tables[index] = table = new TableInfo(minSize, maxSize, elemType);
        ++this.tableCount;
    }

    boolean checkTableIndex(int tableIndex) {
        return Integer.compareUnsigned(tableIndex, this.tableCount) < 0;
    }

    public void exportTable(int tableIndex, String name) {
        this.checkNotParsed();
        this.exportSymbol(name);
        if (!this.checkTableIndex(tableIndex)) {
            throw WasmException.create(Failure.UNSPECIFIED_INVALID, "No table has been declared or imported, so a table cannot be exported.");
        }
        this.exportedTables.put((Object)name, (Object)tableIndex);
        this.module().addLinkAction((context, store, instance, imports) -> store.linker().resolveTableExport(this.module(), tableIndex, name));
    }

    public int tableCount() {
        return this.tableCount;
    }

    public ImportDescriptor importedTable(int index) {
        return (ImportDescriptor)this.importedTables.get((Object)index);
    }

    public EconomicMap<ImportDescriptor, Integer> importedTableDescriptors() {
        EconomicMap reverseMap = EconomicMap.create();
        MapCursor cursor = this.importedTables.getEntries();
        while (cursor.advance()) {
            reverseMap.put((Object)((ImportDescriptor)cursor.getValue()), (Object)((Integer)cursor.getKey()));
        }
        return reverseMap;
    }

    public EconomicMap<String, Integer> exportedTables() {
        return this.exportedTables;
    }

    public int tableInitialSize(int index) {
        TableInfo table = this.tables[index];
        assert (table != null);
        return table.initialSize;
    }

    public int tableMaximumSize(int index) {
        TableInfo table = this.tables[index];
        assert (table != null);
        return table.maximumSize;
    }

    public byte tableElementType(int index) {
        TableInfo table = this.tables[index];
        assert (table != null);
        return table.elemType;
    }

    private void ensureMemoryCapacity(int index) {
        if (index >= this.memories.length) {
            MemoryInfo[] nMemories = new MemoryInfo[Math.max(Integer.highestOneBit(index) << 1, 2 * this.memories.length)];
            System.arraycopy(this.memories, 0, nMemories, 0, this.memories.length);
            this.memories = nMemories;
        }
    }

    public void allocateMemory(int index, long declaredMinSize, long declaredMaxSize, boolean indexType64, boolean shared, boolean multiMemory, boolean useUnsafeMemory, boolean directByteBufferMemoryAccess) {
        this.checkNotParsed();
        this.addMemory(index, declaredMinSize, declaredMaxSize, indexType64, shared, multiMemory);
        this.module().addLinkAction((context, store, instance, imports) -> {
            this.module().limits().checkMemoryInstanceSize(declaredMinSize, indexType64);
            WasmMemory wasmMemory = context.getContextOptions().memoryOverheadMode() ? WasmMemoryFactory.createMemory(0L, 0L, false, false, useUnsafeMemory, directByteBufferMemoryAccess, context) : WasmMemoryFactory.createMemory(declaredMinSize, declaredMaxSize, indexType64, shared, useUnsafeMemory, directByteBufferMemoryAccess, context);
            int memoryAddress = store.memories().register(wasmMemory);
            WasmMemory allocatedMemory = store.memories().memory(memoryAddress);
            instance.setMemory(index, allocatedMemory);
        });
    }

    public void importMemory(String moduleName, String memoryName, int index, long initSize, long maxSize, boolean typeIndex64, boolean shared, boolean multiMemory) {
        this.checkNotParsed();
        this.addMemory(index, initSize, maxSize, typeIndex64, shared, multiMemory);
        ImportDescriptor importedMemory = new ImportDescriptor(moduleName, memoryName, 2, index, this.numImportedSymbols());
        this.importedMemories.put((Object)index, (Object)importedMemory);
        this.importSymbol(importedMemory);
        this.module().addLinkAction((context, store, instance, imports) -> store.linker().resolveMemoryImport(store, instance, importedMemory, index, initSize, maxSize, typeIndex64, shared, imports));
    }

    void addMemory(int index, long minSize, long maxSize, boolean indexType64, boolean shared, boolean multiMemory) {
        MemoryInfo memory;
        if (!multiMemory) {
            Assert.assertTrue(this.importedMemories.size() == 0, "A memory has already been imported in the module.", Failure.MULTIPLE_MEMORIES);
            Assert.assertTrue(this.memoryCount == 0, "A memory has already been declared in the module.", Failure.MULTIPLE_MEMORIES);
        }
        this.ensureMemoryCapacity(index);
        this.memories[index] = memory = new MemoryInfo(minSize, maxSize, indexType64, shared);
        ++this.memoryCount;
    }

    boolean checkMemoryIndex(int memoryIndex) {
        return Integer.compareUnsigned(memoryIndex, this.memoryCount) < 0;
    }

    public void exportMemory(int memoryIndex, String name) {
        this.checkNotParsed();
        this.exportSymbol(name);
        if (!this.checkMemoryIndex(memoryIndex)) {
            throw WasmException.create(Failure.UNSPECIFIED_INVALID, "No memory with the specified index has been declared or imported, so it cannot be exported.");
        }
        this.exportedMemories.put((Object)name, (Object)memoryIndex);
        this.module().addLinkAction((context, store, instance, imports) -> store.linker().resolveMemoryExport(instance, memoryIndex, name));
    }

    public int memoryCount() {
        return this.memoryCount;
    }

    public ImportDescriptor importedMemory(int index) {
        return (ImportDescriptor)this.importedMemories.get((Object)index);
    }

    public EconomicMap<ImportDescriptor, Integer> importedMemoryDescriptors() {
        EconomicMap reverseMap = EconomicMap.create();
        MapCursor cursor = this.importedMemories.getEntries();
        while (cursor.advance()) {
            reverseMap.put((Object)((ImportDescriptor)cursor.getValue()), (Object)((Integer)cursor.getKey()));
        }
        return reverseMap;
    }

    public EconomicMap<String, Integer> exportedMemories() {
        return this.exportedMemories;
    }

    public long memoryInitialSize(int index) {
        MemoryInfo memory = this.memories[index];
        return memory.initialSize;
    }

    public long memoryMaximumSize(int index) {
        MemoryInfo memory = this.memories[index];
        return memory.maximumSize;
    }

    public boolean memoryHasIndexType64(int index) {
        MemoryInfo memory = this.memories[index];
        return memory.indexType64;
    }

    public boolean memoryIsShared(int index) {
        MemoryInfo memory = this.memories[index];
        return memory.shared;
    }

    void allocateCustomSection(String name, int offset, int length) {
        this.customSections.add(new WasmCustomSection(name, offset, length));
    }

    public List<WasmCustomSection> customSections() {
        return this.customSections;
    }

    public void checkDataSegmentIndex(int dataIndex) {
        Assert.assertTrue(this.dataCountExists, Failure.DATA_COUNT_SECTION_REQUIRED);
        Assert.assertUnsignedIntLess(dataIndex, this.dataSegmentCount, Failure.UNKNOWN_DATA_SEGMENT);
    }

    public void setDataSegmentCount(int count) {
        this.dataSegmentCount = count;
        this.dataCountExists = true;
    }

    public void checkDataSegmentCount(int numberOfDataSegments) {
        if (this.dataCountExists) {
            Assert.assertIntEqual(numberOfDataSegments, this.dataSegmentCount, Failure.DATA_COUNT_MISMATCH);
        }
    }

    public void addFunctionReference(int functionIndex) {
        this.functionReferences.add((Object)functionIndex);
    }

    public void checkFunctionReference(int functionIndex) {
        Assert.assertTrue(this.functionReferences.contains((Object)functionIndex), Failure.UNDECLARED_FUNCTION_REFERENCE);
    }

    private void ensureDataInstanceCapacity(int index) {
        if (this.dataInstances == null) {
            this.dataInstances = new int[Math.max(Integer.highestOneBit(index) << 1, 2)];
        } else if (index >= this.dataInstances.length) {
            int[] nDataInstances = new int[Math.max(Integer.highestOneBit(index) << 1, 2 * this.dataInstances.length)];
            System.arraycopy(this.dataInstances, 0, nDataInstances, 0, this.dataInstances.length);
            this.dataInstances = nDataInstances;
        }
    }

    void setDataInstance(int index, int offset) {
        this.ensureDataInstanceCapacity(index);
        this.dataInstances[index] = offset;
        if (!this.dataCountExists) {
            ++this.dataSegmentCount;
        }
    }

    public int dataInstanceOffset(int index) {
        return this.dataInstances[index];
    }

    public int dataInstanceCount() {
        return this.dataSegmentCount;
    }

    void setDroppedDataInstanceOffset(int address) {
        this.droppedDataInstanceOffset = address;
    }

    public int droppedDataInstanceOffset() {
        return this.droppedDataInstanceOffset;
    }

    public void checkElemIndex(int elemIndex) {
        Assert.assertUnsignedIntLess(elemIndex, this.elemSegmentCount, Failure.UNKNOWN_ELEM_SEGMENT);
    }

    public void checkElemType(int elemIndex, byte expectedType) {
        Assert.assertByteEqual(expectedType, (byte)this.elemInstances[elemIndex], Failure.TYPE_MISMATCH);
    }

    private void ensureElemInstanceCapacity(int index) {
        if (this.elemInstances == null) {
            this.elemInstances = new long[Math.max(Integer.highestOneBit(index) << 1, 2)];
        } else if (index >= this.elemInstances.length) {
            long[] nElementInstances = new long[Math.max(Integer.highestOneBit(index) << 1, 2 * this.elemInstances.length)];
            System.arraycopy(this.elemInstances, 0, nElementInstances, 0, this.elemInstances.length);
            this.elemInstances = nElementInstances;
        }
    }

    void setElemInstance(int index, int offset, byte elemType) {
        this.ensureElemInstanceCapacity(index);
        this.elemInstances[index] = (long)offset << 32 | (long)(elemType & 0xFF);
        ++this.elemSegmentCount;
    }

    public int elemInstanceOffset(int index) {
        return (int)(this.elemInstances[index] >>> 32);
    }

    public int elemInstanceCount() {
        return this.elemSegmentCount;
    }

    private void ensureCodeEntriesCapacity(int index) {
        if (this.codeEntries == null) {
            this.codeEntries = new int[Math.max(Integer.highestOneBit(index) << 1, 2)];
        } else if (index >= this.codeEntries.length) {
            int[] nCodeEntries = new int[Math.max(Integer.highestOneBit(index) << 1, 2 * this.codeEntries.length)];
            System.arraycopy(this.codeEntries, 0, nCodeEntries, 0, this.codeEntries.length);
            this.codeEntries = nCodeEntries;
        }
    }

    void setCodeEntryOffset(int index, int offset) {
        this.ensureCodeEntriesCapacity(index);
        this.codeEntries[index] = offset;
        ++this.codeEntryCount;
    }

    public int codeEntryOffset(int index) {
        return this.codeEntries[index];
    }

    public int codeEntryCount() {
        return this.codeEntryCount;
    }

    public void finishSymbolTable() {
        CompilerAsserts.neverPartOfCompilation();
        this.assignGlobalAddresses();
        this.removeFunctionReferences();
    }

    private void assignGlobalAddresses() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.numGlobals() == this.numInternalGlobals() + this.numExternalGlobals());
        this.globalAddresses = new int[this.numGlobals];
        int internalGlobalCount = 0;
        int externalGlobalCount = 0;
        for (int i = 0; i < this.numGlobals; ++i) {
            if (!this.globalExternal(i)) {
                this.globalAddresses[i] = internalGlobalCount++;
                continue;
            }
            this.globalAddresses[i] = -externalGlobalCount - 1;
            ++externalGlobalCount;
        }
        assert (internalGlobalCount == this.numInternalGlobals());
        assert (externalGlobalCount == this.numExternalGlobals());
    }

    private void removeFunctionReferences() {
        CompilerAsserts.neverPartOfCompilation();
        this.functionReferences = null;
    }

    public static class TableInfo {
        public final int initialSize;
        public final int maximumSize;
        public final byte elemType;

        public TableInfo(int initialSize, int maximumSize, byte elemType) {
            this.initialSize = initialSize;
            this.maximumSize = maximumSize;
            this.elemType = elemType;
        }
    }

    public static class MemoryInfo {
        public final long initialSize;
        public final long maximumSize;
        public final boolean indexType64;
        public final boolean shared;

        public MemoryInfo(long initialSize, long maximumSize, boolean indexType64, boolean shared) {
            this.initialSize = initialSize;
            this.maximumSize = maximumSize;
            this.indexType64 = indexType64;
            this.shared = shared;
        }
    }

    public static final class FunctionType {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] paramTypes;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] resultTypes;
        private final int hashCode;

        FunctionType(byte[] paramTypes, byte[] resultTypes) {
            this.paramTypes = paramTypes;
            this.resultTypes = resultTypes;
            this.hashCode = Arrays.hashCode(paramTypes) ^ Arrays.hashCode(resultTypes);
        }

        public byte[] paramTypes() {
            return this.paramTypes;
        }

        public byte[] resultTypes() {
            return this.resultTypes;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            int i;
            if (!(object instanceof FunctionType)) {
                return false;
            }
            FunctionType that = (FunctionType)object;
            if (this.paramTypes.length != that.paramTypes.length) {
                return false;
            }
            for (i = 0; i < this.paramTypes.length; ++i) {
                if (this.paramTypes[i] == that.paramTypes[i]) continue;
                return false;
            }
            if (this.resultTypes.length != that.resultTypes.length) {
                return false;
            }
            for (i = 0; i < this.resultTypes.length; ++i) {
                if (this.resultTypes[i] == that.resultTypes[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            CharSequence[] paramNames = new String[this.paramTypes.length];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                paramNames[i] = WasmType.toString(this.paramTypes[i]);
            }
            CharSequence[] resultNames = new String[this.resultTypes.length];
            for (int i = 0; i < this.resultTypes.length; ++i) {
                resultNames[i] = WasmType.toString(this.resultTypes[i]);
            }
            return "(" + String.join((CharSequence)" ", paramNames) + ")->(" + String.join((CharSequence)" ", resultNames) + ")";
        }
    }
}

