/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.BitSet;
import java.util.Objects;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.globals.WasmGlobal;

public final class GlobalRegistry {
    private final long[] globals;
    private final Object[] objectGlobals;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final WasmGlobal[] externalGlobals;
    private final BitSet initialized;

    public GlobalRegistry(int internalGlobalsSize, int externalGlobalsSize) {
        this.globals = new long[internalGlobalsSize];
        this.objectGlobals = new Object[internalGlobalsSize];
        this.externalGlobals = new WasmGlobal[externalGlobalsSize];
        this.initialized = new BitSet(internalGlobalsSize + externalGlobalsSize);
    }

    public int count() {
        return this.globals.length;
    }

    public float loadAsFloat(int globalAddress) {
        return Float.intBitsToFloat(this.loadAsInt(globalAddress));
    }

    public double loadAsDouble(int globalAddress) {
        return Double.longBitsToDouble(this.loadAsLong(globalAddress));
    }

    public int loadAsInt(int address) {
        return (int)this.loadAsLong(address);
    }

    public long loadAsLong(int address) {
        if (address < 0) {
            return this.externalGlobal(address).loadAsLong();
        }
        return this.globals[address];
    }

    public Vector128 loadAsVector128(int address) {
        if (address < 0) {
            return this.externalGlobal(address).loadAsVector128();
        }
        return (Vector128)this.loadAsObject(address);
    }

    public Object loadAsReference(int address) {
        if (address < 0) {
            return this.externalGlobal(address).loadAsReference();
        }
        return this.loadAsObject(address);
    }

    private Object loadAsObject(int address) {
        assert (address >= 0) : address;
        return this.objectGlobals[address];
    }

    public void store(byte globalValueType, int address, Object value) {
        switch (globalValueType) {
            case 127: {
                this.storeInt(address, (Integer)value);
                break;
            }
            case 126: {
                this.storeLong(address, (Long)value);
                break;
            }
            case 125: {
                this.storeFloat(address, ((Float)value).floatValue());
                break;
            }
            case 124: {
                this.storeDouble(address, (Double)value);
                break;
            }
            case 123: {
                this.storeVector128(address, (Vector128)value);
                break;
            }
            case 111: 
            case 112: {
                this.storeReference(address, value);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    public void storeFloat(int address, float value) {
        this.storeInt(address, Float.floatToRawIntBits(value));
    }

    public void storeDouble(int address, double value) {
        this.storeLong(address, Double.doubleToRawLongBits(value));
    }

    public void storeInt(int address, int value) {
        this.storeLong(address, value);
    }

    public void storeLong(int address, long value) {
        if (address < 0) {
            this.externalGlobal(address).storeLong(value);
        } else {
            this.globals[address] = value;
        }
    }

    public void storeVector128(int address, Vector128 value) {
        if (address < 0) {
            this.externalGlobal(address).storeVector128(value);
        } else {
            this.storeObject(address, value);
        }
    }

    public void storeReference(int address, Object value) {
        if (address < 0) {
            this.externalGlobal(address).storeReference(value);
        } else {
            this.storeObject(address, value);
        }
    }

    private void storeObject(int address, Object value) {
        assert (address >= 0) : address;
        this.objectGlobals[address] = value;
    }

    WasmGlobal externalGlobal(int address) {
        assert (address < 0) : address;
        WasmGlobal result = this.externalGlobals[-address - 1];
        assert (result != null) : "Uninitialized external global at address: " + address;
        return result;
    }

    void setExternalGlobal(int address, WasmGlobal global) {
        assert (address < 0) : address;
        assert (this.externalGlobals[-address - 1] == null) : "Already initialized external global at address: " + address;
        this.externalGlobals[-address - 1] = Objects.requireNonNull(global);
    }

    public GlobalRegistry duplicate() {
        GlobalRegistry other = new GlobalRegistry(this.globals.length, this.externalGlobals.length);
        int i = 0;
        while (i < this.count()) {
            int address = i++;
            long value = this.loadAsLong(address);
            Object objectValue = this.loadAsObject(address);
            other.storeLong(address, value);
            other.storeObject(address, objectValue);
        }
        for (i = 0; i < this.externalGlobals.length; ++i) {
            other.externalGlobals[i] = this.externalGlobals[i];
        }
        return other;
    }

    public boolean isInitialized(int globalIndex) {
        return this.initialized.get(globalIndex);
    }

    public void setInitialized(int globalIndex, boolean value) {
        this.initialized.set(globalIndex, value);
    }
}

