/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.function.Function;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.LongVector;
import jdk.incubator.vector.ShortVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorShape;
import jdk.incubator.vector.VectorShuffle;
import jdk.incubator.vector.VectorSpecies;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.api.Vector128Ops;
import org.graalvm.wasm.api.Vector128OpsFallback;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class Vector128OpsVectorAPI
implements Vector128Ops<ByteVector> {
    private static final Vector128Ops<byte[]> fallbackOps = Vector128OpsFallback.create();
    private static final I8X16Shape I8X16 = new I8X16Shape();
    private static final I16X8Shape I16X8 = new I16X8Shape();
    private static final I32X4Shape I32X4 = new I32X4Shape();
    private static final I64X2Shape I64X2 = new I64X2Shape();
    private static final F32X4Shape F32X4 = new F32X4Shape();
    private static final F64X2Shape F64X2 = new F64X2Shape();
    private static final int FLOAT_SIGNIFICAND_WIDTH = 24;
    private static final int FLOAT_EXP_BIAS = 127;
    private static final int FLOAT_EXP_BIT_MASK = 2139095040;
    private static final long FLOAT_SIGNIF_BIT_MASK = 0x7FFFFFL;
    private static final int DOUBLE_SIGNIFICAND_WIDTH = 53;
    private static final int DOUBLE_EXP_BIAS = 1023;
    private static final long DOUBLE_EXP_BIT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final double CEIL_NEGATIVE_BOUNDARY_ARG = -0.0;
    private static final double CEIL_POSITIVE_BOUNDARY_ARG = 1.0;
    private static final double CEIL_SIGN_ARG = 1.0;
    private static final double FLOOR_NEGATIVE_BOUNDARY_ARG = -1.0;
    private static final double FLOOR_POSITIVE_BOUNDARY_ARG = 0.0;
    private static final double FLOOR_SIGN_ARG = -1.0;
    private static final String VECTOR_API_PACKAGE = Vector.class.getPackageName();
    private static final Class<? extends ByteVector> BYTE_128_CLASS = Vector128OpsVectorAPI.lookupClass(VECTOR_API_PACKAGE + ".Byte128Vector");
    private static final Class<? extends ShortVector> SHORT_128_CLASS = Vector128OpsVectorAPI.lookupClass(VECTOR_API_PACKAGE + ".Short128Vector");
    private static final Class<? extends IntVector> INT_128_CLASS = Vector128OpsVectorAPI.lookupClass(VECTOR_API_PACKAGE + ".Int128Vector");
    private static final Class<? extends LongVector> LONG_128_CLASS = Vector128OpsVectorAPI.lookupClass(VECTOR_API_PACKAGE + ".Long128Vector");
    private static final Class<? extends FloatVector> FLOAT_128_CLASS = Vector128OpsVectorAPI.lookupClass(VECTOR_API_PACKAGE + ".Float128Vector");
    private static final Class<? extends DoubleVector> DOUBLE_128_CLASS = Vector128OpsVectorAPI.lookupClass(VECTOR_API_PACKAGE + ".Double128Vector");
    private static final Class<? extends VectorMask<Byte>> BYTE_128_MASK_CLASS = Vector128OpsVectorAPI.lookupClass(VECTOR_API_PACKAGE + ".Byte128Vector$Byte128Mask");
    private static final Class<? extends VectorMask<Short>> SHORT_128_MASK_CLASS = Vector128OpsVectorAPI.lookupClass(VECTOR_API_PACKAGE + ".Short128Vector$Short128Mask");

    Vector128OpsVectorAPI() {
    }

    static Vector128Ops<ByteVector> create() {
        return new Vector128OpsVectorAPI();
    }

    @Override
    public ByteVector unary(ByteVector xVec, int vectorOpcode) {
        ByteVector x = Vector128OpsVectorAPI.castByte128((Vector<Byte>)xVec);
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)(switch (vectorOpcode) {
            case 77 -> Vector128OpsVectorAPI.unop(x, I8X16, VectorOperators.NOT);
            case 96 -> Vector128OpsVectorAPI.unop(x, I8X16, VectorOperators.ABS);
            case 97 -> Vector128OpsVectorAPI.unop(x, I8X16, VectorOperators.NEG);
            case 98 -> Vector128OpsVectorAPI.i8x16_popcnt(x);
            case 124 -> Vector128OpsVectorAPI.extadd_pairwise(x, I8X16, VectorOperators.B2S);
            case 125 -> Vector128OpsVectorAPI.extadd_pairwise(x, I8X16, VectorOperators.ZERO_EXTEND_B2S);
            case 135 -> Vector128OpsVectorAPI.extend(x, 0, I8X16, VectorOperators.B2S);
            case 137 -> Vector128OpsVectorAPI.extend(x, 0, I8X16, VectorOperators.ZERO_EXTEND_B2S);
            case 136 -> Vector128OpsVectorAPI.extend(x, 1, I8X16, VectorOperators.B2S);
            case 138 -> Vector128OpsVectorAPI.extend(x, 1, I8X16, VectorOperators.ZERO_EXTEND_B2S);
            case 128 -> Vector128OpsVectorAPI.unop(x, I16X8, VectorOperators.ABS);
            case 129 -> Vector128OpsVectorAPI.unop(x, I16X8, VectorOperators.NEG);
            case 126 -> Vector128OpsVectorAPI.extadd_pairwise(x, I16X8, VectorOperators.S2I);
            case 127 -> Vector128OpsVectorAPI.extadd_pairwise(x, I16X8, VectorOperators.ZERO_EXTEND_S2I);
            case 167 -> Vector128OpsVectorAPI.extend(x, 0, I16X8, VectorOperators.S2I);
            case 169 -> Vector128OpsVectorAPI.extend(x, 0, I16X8, VectorOperators.ZERO_EXTEND_S2I);
            case 168 -> Vector128OpsVectorAPI.extend(x, 1, I16X8, VectorOperators.S2I);
            case 170 -> Vector128OpsVectorAPI.extend(x, 1, I16X8, VectorOperators.ZERO_EXTEND_S2I);
            case 160 -> Vector128OpsVectorAPI.unop(x, I32X4, VectorOperators.ABS);
            case 161 -> Vector128OpsVectorAPI.unop(x, I32X4, VectorOperators.NEG);
            case 199 -> Vector128OpsVectorAPI.extend(x, 0, I32X4, VectorOperators.I2L);
            case 201 -> Vector128OpsVectorAPI.extend(x, 0, I32X4, VectorOperators.ZERO_EXTEND_I2L);
            case 200 -> Vector128OpsVectorAPI.extend(x, 1, I32X4, VectorOperators.I2L);
            case 202 -> Vector128OpsVectorAPI.extend(x, 1, I32X4, VectorOperators.ZERO_EXTEND_I2L);
            case 192 -> Vector128OpsVectorAPI.unop(x, I64X2, VectorOperators.ABS);
            case 193 -> Vector128OpsVectorAPI.unop(x, I64X2, VectorOperators.NEG);
            case 224 -> Vector128OpsVectorAPI.unop(x, F32X4, VectorOperators.ABS);
            case 225 -> Vector128OpsVectorAPI.unop(x, F32X4, VectorOperators.NEG);
            case 227 -> Vector128OpsVectorAPI.unop(x, F32X4, VectorOperators.SQRT);
            case 103 -> Vector128OpsVectorAPI.ceil(x, F32X4, I32X4, VectorOperators.REINTERPRET_F2I, VectorOperators.REINTERPRET_I2F, Vector128OpsVectorAPI::getExponentFloats, 24, I32X4.broadcast(0x7FFFFFL));
            case 104 -> Vector128OpsVectorAPI.floor(x, F32X4, I32X4, VectorOperators.REINTERPRET_F2I, VectorOperators.REINTERPRET_I2F, Vector128OpsVectorAPI::getExponentFloats, 24, I32X4.broadcast(0x7FFFFFL));
            case 105 -> Vector128OpsVectorAPI.trunc(x, F32X4, I32X4, VectorOperators.REINTERPRET_F2I, VectorOperators.REINTERPRET_I2F, Vector128OpsVectorAPI::getExponentFloats, 24, I32X4.broadcast(0x7FFFFFL));
            case 106 -> Vector128OpsVectorAPI.nearest(x, F32X4, 0x800000L);
            case 236 -> Vector128OpsVectorAPI.unop(x, F64X2, VectorOperators.ABS);
            case 237 -> Vector128OpsVectorAPI.unop(x, F64X2, VectorOperators.NEG);
            case 239 -> Vector128OpsVectorAPI.unop(x, F64X2, VectorOperators.SQRT);
            case 116 -> Vector128OpsVectorAPI.ceil(x, F64X2, I64X2, VectorOperators.REINTERPRET_D2L, VectorOperators.REINTERPRET_L2D, Vector128OpsVectorAPI::getExponentDoubles, 53, I64X2.broadcast(0xFFFFFFFFFFFFFL));
            case 117 -> Vector128OpsVectorAPI.floor(x, F64X2, I64X2, VectorOperators.REINTERPRET_D2L, VectorOperators.REINTERPRET_L2D, Vector128OpsVectorAPI::getExponentDoubles, 53, I64X2.broadcast(0xFFFFFFFFFFFFFL));
            case 122 -> Vector128OpsVectorAPI.trunc(x, F64X2, I64X2, VectorOperators.REINTERPRET_D2L, VectorOperators.REINTERPRET_L2D, Vector128OpsVectorAPI::getExponentDoubles, 53, I64X2.broadcast(0xFFFFFFFFFFFFFL));
            case 148 -> Vector128OpsVectorAPI.nearest(x, F64X2, 0x10000000000000L);
            case 165, 248 -> (ByteVector)this.fromArray(fallbackOps.unary(x.toArray(), vectorOpcode));
            case 166, 249 -> (ByteVector)this.fromArray(fallbackOps.unary(x.toArray(), vectorOpcode));
            case 250 -> Vector128OpsVectorAPI.convert(x, I32X4, VectorOperators.I2F);
            case 251 -> (ByteVector)this.fromArray(fallbackOps.unary(x.toArray(), vectorOpcode));
            case 197, 252 -> (ByteVector)this.fromArray(fallbackOps.unary(x.toArray(), vectorOpcode));
            case 198, 253 -> (ByteVector)this.fromArray(fallbackOps.unary(x.toArray(), vectorOpcode));
            case 254 -> Vector128OpsVectorAPI.convert(x, I32X4, VectorOperators.I2D);
            case 255 -> Vector128OpsVectorAPI.f64x2_convert_low_i32x4_u(x);
            case 94 -> (ByteVector)this.fromArray(fallbackOps.unary(x.toArray(), vectorOpcode));
            case 95 -> (ByteVector)this.fromArray(fallbackOps.unary(x.toArray(), vectorOpcode));
            default -> throw CompilerDirectives.shouldNotReachHere();
        }));
    }

    @Override
    public ByteVector binary(ByteVector xVec, ByteVector yVec, int vectorOpcode) {
        ByteVector x = Vector128OpsVectorAPI.castByte128((Vector<Byte>)xVec);
        ByteVector y = Vector128OpsVectorAPI.castByte128((Vector<Byte>)yVec);
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)(switch (vectorOpcode) {
            case 14, 162 -> Vector128OpsVectorAPI.i8x16_swizzle(x, y);
            case 78 -> Vector128OpsVectorAPI.binop(x, y, I8X16, (VectorOperators.Binary)VectorOperators.AND);
            case 79 -> Vector128OpsVectorAPI.binop(x, y, I8X16, VectorOperators.AND_NOT);
            case 80 -> Vector128OpsVectorAPI.binop(x, y, I8X16, (VectorOperators.Binary)VectorOperators.OR);
            case 81 -> Vector128OpsVectorAPI.binop(x, y, I8X16, (VectorOperators.Binary)VectorOperators.XOR);
            case 35 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.EQ);
            case 36 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.NE);
            case 37 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.LT);
            case 38 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.ULT);
            case 39 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.GT);
            case 40 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.UGT);
            case 41 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.LE);
            case 42 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.ULE);
            case 43 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.GE);
            case 44 -> Vector128OpsVectorAPI.relop(x, y, I8X16, VectorOperators.UGE);
            case 45 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.EQ);
            case 46 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.NE);
            case 47 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.LT);
            case 48 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.ULT);
            case 49 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.GT);
            case 50 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.UGT);
            case 51 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.LE);
            case 52 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.ULE);
            case 53 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.GE);
            case 54 -> Vector128OpsVectorAPI.relop(x, y, I16X8, VectorOperators.UGE);
            case 55 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.EQ);
            case 56 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.NE);
            case 57 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.LT);
            case 58 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.ULT);
            case 59 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.GT);
            case 60 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.UGT);
            case 61 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.LE);
            case 62 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.ULE);
            case 63 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.GE);
            case 64 -> Vector128OpsVectorAPI.relop(x, y, I32X4, VectorOperators.UGE);
            case 214 -> Vector128OpsVectorAPI.relop(x, y, I64X2, VectorOperators.EQ);
            case 215 -> Vector128OpsVectorAPI.relop(x, y, I64X2, VectorOperators.NE);
            case 216 -> Vector128OpsVectorAPI.relop(x, y, I64X2, VectorOperators.LT);
            case 217 -> Vector128OpsVectorAPI.relop(x, y, I64X2, VectorOperators.GT);
            case 218 -> Vector128OpsVectorAPI.relop(x, y, I64X2, VectorOperators.LE);
            case 219 -> Vector128OpsVectorAPI.relop(x, y, I64X2, VectorOperators.GE);
            case 65 -> Vector128OpsVectorAPI.f32x4_relop(x, y, VectorOperators.EQ);
            case 66 -> Vector128OpsVectorAPI.f32x4_relop(x, y, VectorOperators.NE);
            case 67 -> Vector128OpsVectorAPI.f32x4_relop(x, y, VectorOperators.LT);
            case 68 -> Vector128OpsVectorAPI.f32x4_relop(x, y, VectorOperators.GT);
            case 69 -> Vector128OpsVectorAPI.f32x4_relop(x, y, VectorOperators.LE);
            case 70 -> Vector128OpsVectorAPI.f32x4_relop(x, y, VectorOperators.GE);
            case 71 -> Vector128OpsVectorAPI.f64x2_relop(x, y, VectorOperators.EQ);
            case 72 -> Vector128OpsVectorAPI.f64x2_relop(x, y, VectorOperators.NE);
            case 73 -> Vector128OpsVectorAPI.f64x2_relop(x, y, VectorOperators.LT);
            case 74 -> Vector128OpsVectorAPI.f64x2_relop(x, y, VectorOperators.GT);
            case 75 -> Vector128OpsVectorAPI.f64x2_relop(x, y, VectorOperators.LE);
            case 76 -> Vector128OpsVectorAPI.f64x2_relop(x, y, VectorOperators.GE);
            case 101 -> Vector128OpsVectorAPI.narrow(x, y, I16X8, I8X16, -128L, 127L);
            case 102 -> Vector128OpsVectorAPI.narrow(x, y, I16X8, I8X16, 0L, 255L);
            case 110 -> Vector128OpsVectorAPI.binop(x, y, I8X16, (VectorOperators.Binary)VectorOperators.ADD);
            case 111 -> Vector128OpsVectorAPI.binop_sat(x, y, I8X16, I16X8, VectorOperators.B2S, (VectorOperators.Binary)VectorOperators.ADD, -128L, 127L);
            case 112 -> Vector128OpsVectorAPI.binop_sat(x, y, I8X16, I16X8, VectorOperators.ZERO_EXTEND_B2S, (VectorOperators.Binary)VectorOperators.ADD, 0L, 255L);
            case 113 -> Vector128OpsVectorAPI.binop(x, y, I8X16, VectorOperators.SUB);
            case 114 -> Vector128OpsVectorAPI.binop_sat(x, y, I8X16, I16X8, VectorOperators.B2S, VectorOperators.SUB, -128L, 127L);
            case 115 -> Vector128OpsVectorAPI.binop_sat(x, y, I8X16, I16X8, VectorOperators.ZERO_EXTEND_B2S, VectorOperators.SUB, 0L, 255L);
            case 118 -> Vector128OpsVectorAPI.binop(x, y, I8X16, (VectorOperators.Binary)VectorOperators.MIN);
            case 119 -> (ByteVector)this.fromArray(fallbackOps.binary(x.toArray(), y.toArray(), vectorOpcode));
            case 120 -> Vector128OpsVectorAPI.binop(x, y, I8X16, (VectorOperators.Binary)VectorOperators.MAX);
            case 121 -> (ByteVector)this.fromArray(fallbackOps.binary(x.toArray(), y.toArray(), vectorOpcode));
            case 123 -> Vector128OpsVectorAPI.avgr_u(x, y, I8X16, I16X8, VectorOperators.ZERO_EXTEND_B2S);
            case 133 -> Vector128OpsVectorAPI.narrow(x, y, I32X4, I16X8, -32768L, 32767L);
            case 134 -> Vector128OpsVectorAPI.narrow(x, y, I32X4, I16X8, 0L, 65535L);
            case 130, 154 -> Vector128OpsVectorAPI.i16x8_q15mulr_sat_s(x, y);
            case 142 -> Vector128OpsVectorAPI.binop(x, y, I16X8, (VectorOperators.Binary)VectorOperators.ADD);
            case 143 -> Vector128OpsVectorAPI.binop_sat(x, y, I16X8, I32X4, VectorOperators.S2I, (VectorOperators.Binary)VectorOperators.ADD, -32768L, 32767L);
            case 144 -> Vector128OpsVectorAPI.binop_sat(x, y, I16X8, I32X4, VectorOperators.ZERO_EXTEND_S2I, (VectorOperators.Binary)VectorOperators.ADD, 0L, 65535L);
            case 145 -> Vector128OpsVectorAPI.binop(x, y, I16X8, VectorOperators.SUB);
            case 146 -> Vector128OpsVectorAPI.binop_sat(x, y, I16X8, I32X4, VectorOperators.S2I, VectorOperators.SUB, -32768L, 32767L);
            case 147 -> Vector128OpsVectorAPI.binop_sat(x, y, I16X8, I32X4, VectorOperators.ZERO_EXTEND_S2I, VectorOperators.SUB, 0L, 65535L);
            case 149 -> Vector128OpsVectorAPI.binop(x, y, I16X8, (VectorOperators.Binary)VectorOperators.MUL);
            case 150 -> Vector128OpsVectorAPI.binop(x, y, I16X8, (VectorOperators.Binary)VectorOperators.MIN);
            case 151 -> (ByteVector)this.fromArray(fallbackOps.binary(x.toArray(), y.toArray(), vectorOpcode));
            case 152 -> Vector128OpsVectorAPI.binop(x, y, I16X8, (VectorOperators.Binary)VectorOperators.MAX);
            case 153 -> (ByteVector)this.fromArray(fallbackOps.binary(x.toArray(), y.toArray(), vectorOpcode));
            case 155 -> Vector128OpsVectorAPI.avgr_u(x, y, I16X8, I32X4, VectorOperators.ZERO_EXTEND_S2I);
            case 156 -> Vector128OpsVectorAPI.extmul(x, y, I8X16, VectorOperators.B2S, 0);
            case 158 -> Vector128OpsVectorAPI.extmul(x, y, I8X16, VectorOperators.ZERO_EXTEND_B2S, 0);
            case 157 -> Vector128OpsVectorAPI.extmul(x, y, I8X16, VectorOperators.B2S, 1);
            case 159 -> Vector128OpsVectorAPI.extmul(x, y, I8X16, VectorOperators.ZERO_EXTEND_B2S, 1);
            case 174 -> Vector128OpsVectorAPI.binop(x, y, I32X4, (VectorOperators.Binary)VectorOperators.ADD);
            case 177 -> Vector128OpsVectorAPI.binop(x, y, I32X4, VectorOperators.SUB);
            case 181 -> Vector128OpsVectorAPI.binop(x, y, I32X4, (VectorOperators.Binary)VectorOperators.MUL);
            case 182 -> Vector128OpsVectorAPI.binop(x, y, I32X4, (VectorOperators.Binary)VectorOperators.MIN);
            case 183 -> (ByteVector)this.fromArray(fallbackOps.binary(x.toArray(), y.toArray(), vectorOpcode));
            case 184 -> Vector128OpsVectorAPI.binop(x, y, I32X4, (VectorOperators.Binary)VectorOperators.MAX);
            case 185 -> (ByteVector)this.fromArray(fallbackOps.binary(x.toArray(), y.toArray(), vectorOpcode));
            case 186 -> Vector128OpsVectorAPI.i32x4_dot_i16x8_s(x, y);
            case 188 -> Vector128OpsVectorAPI.extmul(x, y, I16X8, VectorOperators.S2I, 0);
            case 190 -> Vector128OpsVectorAPI.extmul(x, y, I16X8, VectorOperators.ZERO_EXTEND_S2I, 0);
            case 189 -> Vector128OpsVectorAPI.extmul(x, y, I16X8, VectorOperators.S2I, 1);
            case 191 -> Vector128OpsVectorAPI.extmul(x, y, I16X8, VectorOperators.ZERO_EXTEND_S2I, 1);
            case 206 -> Vector128OpsVectorAPI.binop(x, y, I64X2, (VectorOperators.Binary)VectorOperators.ADD);
            case 209 -> Vector128OpsVectorAPI.binop(x, y, I64X2, VectorOperators.SUB);
            case 213 -> Vector128OpsVectorAPI.binop(x, y, I64X2, (VectorOperators.Binary)VectorOperators.MUL);
            case 220 -> Vector128OpsVectorAPI.extmul(x, y, I32X4, VectorOperators.I2L, 0);
            case 222 -> Vector128OpsVectorAPI.extmul(x, y, I32X4, VectorOperators.ZERO_EXTEND_I2L, 0);
            case 221 -> Vector128OpsVectorAPI.extmul(x, y, I32X4, VectorOperators.I2L, 1);
            case 223 -> Vector128OpsVectorAPI.extmul(x, y, I32X4, VectorOperators.ZERO_EXTEND_I2L, 1);
            case 228 -> Vector128OpsVectorAPI.binop(x, y, F32X4, (VectorOperators.Binary)VectorOperators.ADD);
            case 229 -> Vector128OpsVectorAPI.binop(x, y, F32X4, VectorOperators.SUB);
            case 230 -> Vector128OpsVectorAPI.binop(x, y, F32X4, (VectorOperators.Binary)VectorOperators.MUL);
            case 231 -> Vector128OpsVectorAPI.binop(x, y, F32X4, VectorOperators.DIV);
            case 180, 232 -> Vector128OpsVectorAPI.binop(x, y, F32X4, (VectorOperators.Binary)VectorOperators.MIN);
            case 226, 233 -> Vector128OpsVectorAPI.binop(x, y, F32X4, (VectorOperators.Binary)VectorOperators.MAX);
            case 234 -> Vector128OpsVectorAPI.pmin(x, y, F32X4);
            case 235 -> Vector128OpsVectorAPI.pmax(x, y, F32X4);
            case 240 -> Vector128OpsVectorAPI.binop(x, y, F64X2, (VectorOperators.Binary)VectorOperators.ADD);
            case 241 -> Vector128OpsVectorAPI.binop(x, y, F64X2, VectorOperators.SUB);
            case 242 -> Vector128OpsVectorAPI.binop(x, y, F64X2, (VectorOperators.Binary)VectorOperators.MUL);
            case 243 -> Vector128OpsVectorAPI.binop(x, y, F64X2, VectorOperators.DIV);
            case 212, 244 -> Vector128OpsVectorAPI.binop(x, y, F64X2, (VectorOperators.Binary)VectorOperators.MIN);
            case 238, 245 -> Vector128OpsVectorAPI.binop(x, y, F64X2, (VectorOperators.Binary)VectorOperators.MAX);
            case 246 -> Vector128OpsVectorAPI.pmin(x, y, F64X2);
            case 247 -> Vector128OpsVectorAPI.pmax(x, y, F64X2);
            case 187 -> Vector128OpsVectorAPI.i16x8_relaxed_dot_i8x16_i7x16_s(x, y);
            default -> throw CompilerDirectives.shouldNotReachHere();
        }));
    }

    @Override
    public ByteVector ternary(ByteVector xVec, ByteVector yVec, ByteVector zVec, int vectorOpcode) {
        ByteVector x = Vector128OpsVectorAPI.castByte128((Vector<Byte>)xVec);
        ByteVector y = Vector128OpsVectorAPI.castByte128((Vector<Byte>)yVec);
        ByteVector z = Vector128OpsVectorAPI.castByte128((Vector<Byte>)zVec);
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)(switch (vectorOpcode) {
            case 82, 178, 179, 210, 211 -> Vector128OpsVectorAPI.bitselect(x, y, z);
            case 175, 176 -> Vector128OpsVectorAPI.f32x4_ternop(x, y, z, vectorOpcode);
            case 207, 208 -> Vector128OpsVectorAPI.f64x2_ternop(x, y, z, vectorOpcode);
            case 194 -> Vector128OpsVectorAPI.i32x4_relaxed_dot_i8x16_i7x16_add_s(x, y, z);
            default -> throw CompilerDirectives.shouldNotReachHere();
        }));
    }

    @Override
    public int vectorToInt(ByteVector xVec, int vectorOpcode) {
        ByteVector x = Vector128OpsVectorAPI.castByte128((Vector<Byte>)xVec);
        return switch (vectorOpcode) {
            case 83 -> Vector128OpsVectorAPI.v128_any_true(x);
            case 99 -> Vector128OpsVectorAPI.all_true(x, I8X16);
            case 100 -> Vector128OpsVectorAPI.bitmask(x, I8X16);
            case 131 -> Vector128OpsVectorAPI.all_true(x, I16X8);
            case 132 -> Vector128OpsVectorAPI.bitmask(x, I16X8);
            case 163 -> Vector128OpsVectorAPI.all_true(x, I32X4);
            case 164 -> Vector128OpsVectorAPI.bitmask(x, I32X4);
            case 195 -> fallbackOps.vectorToInt(x.toArray(), vectorOpcode);
            case 196 -> Vector128OpsVectorAPI.bitmask(x, I64X2);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public ByteVector shift(ByteVector xVec, int shift, int vectorOpcode) {
        ByteVector x = Vector128OpsVectorAPI.castByte128((Vector<Byte>)xVec);
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)(switch (vectorOpcode) {
            case 107 -> Vector128OpsVectorAPI.shiftop(x, (byte)shift, I8X16, VectorOperators.LSHL);
            case 108 -> Vector128OpsVectorAPI.shiftop(x, (byte)shift, I8X16, VectorOperators.ASHR);
            case 109 -> Vector128OpsVectorAPI.shiftop(x, (byte)shift, I8X16, VectorOperators.LSHR);
            case 139 -> Vector128OpsVectorAPI.shiftop(x, (short)shift, I16X8, VectorOperators.LSHL);
            case 140 -> Vector128OpsVectorAPI.shiftop(x, (short)shift, I16X8, VectorOperators.ASHR);
            case 141 -> Vector128OpsVectorAPI.shiftop(x, (short)shift, I16X8, VectorOperators.LSHR);
            case 171 -> Vector128OpsVectorAPI.shiftop(x, shift, I32X4, VectorOperators.LSHL);
            case 172 -> Vector128OpsVectorAPI.shiftop(x, shift, I32X4, VectorOperators.ASHR);
            case 173 -> Vector128OpsVectorAPI.shiftop(x, shift, I32X4, VectorOperators.LSHR);
            case 203 -> Vector128OpsVectorAPI.shiftop(x, shift, I64X2, VectorOperators.LSHL);
            case 204 -> Vector128OpsVectorAPI.shiftop(x, shift, I64X2, VectorOperators.ASHR);
            case 205 -> Vector128OpsVectorAPI.shiftop(x, shift, I64X2, VectorOperators.LSHR);
            default -> throw CompilerDirectives.shouldNotReachHere();
        }));
    }

    @Override
    public ByteVector v128_load8x8(long value, int vectorOpcode) {
        ByteVector bytes = LongVector.zero(I64X2.species()).withLane(0, value).reinterpretAsBytes();
        VectorOperators.Conversion conversion = switch (vectorOpcode) {
            case 1 -> VectorOperators.B2S;
            case 2 -> VectorOperators.ZERO_EXTEND_B2S;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)bytes.convert(conversion, 0).reinterpretAsBytes());
    }

    @Override
    public ByteVector v128_load16x4(long value, int vectorOpcode) {
        ShortVector shorts = LongVector.zero(I64X2.species()).withLane(0, value).reinterpretAsShorts();
        VectorOperators.Conversion conversion = switch (vectorOpcode) {
            case 3 -> VectorOperators.S2I;
            case 4 -> VectorOperators.ZERO_EXTEND_S2I;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)shorts.convert(conversion, 0).reinterpretAsBytes());
    }

    @Override
    public ByteVector v128_load32x2(long value, int vectorOpcode) {
        IntVector ints = LongVector.zero(I64X2.species()).withLane(0, value).reinterpretAsInts();
        VectorOperators.Conversion conversion = switch (vectorOpcode) {
            case 5 -> VectorOperators.I2L;
            case 6 -> VectorOperators.ZERO_EXTEND_I2L;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)ints.convert(conversion, 0).reinterpretAsBytes());
    }

    @Override
    public ByteVector v128_load32_zero(int value) {
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)I32X4.zero().withLane(0, value).reinterpretAsBytes());
    }

    @Override
    public ByteVector v128_load64_zero(long value) {
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)I64X2.zero().withLane(0, value).reinterpretAsBytes());
    }

    @Override
    public ByteVector i8x16_splat(byte value) {
        return I8X16.broadcast(value);
    }

    @Override
    public ByteVector i16x8_splat(short value) {
        return I16X8.broadcast(value).reinterpretAsBytes();
    }

    @Override
    public ByteVector i32x4_splat(int value) {
        return I32X4.broadcast(value).reinterpretAsBytes();
    }

    @Override
    public ByteVector i64x2_splat(long value) {
        return I64X2.broadcast(value).reinterpretAsBytes();
    }

    @Override
    public ByteVector f32x4_splat(float value) {
        return F32X4.broadcast(value).reinterpretAsBytes();
    }

    @Override
    public ByteVector f64x2_splat(double value) {
        return F64X2.broadcast(value).reinterpretAsBytes();
    }

    @Override
    public ByteVector i8x16_shuffle(ByteVector xVec, ByteVector yVec, ByteVector indicesVec) {
        ByteVector x = Vector128OpsVectorAPI.castByte128((Vector<Byte>)xVec);
        ByteVector y = Vector128OpsVectorAPI.castByte128((Vector<Byte>)yVec);
        ByteVector indices = Vector128OpsVectorAPI.castByte128((Vector<Byte>)indicesVec);
        VectorShuffle shuffle = indices.add((byte)-32, indices.lt((byte)16).not()).toShuffle();
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)x.rearrange(shuffle, (Vector)y));
    }

    @Override
    public byte i8x16_extract_lane_s(ByteVector vec, int laneIndex) {
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec).lane(laneIndex);
    }

    @Override
    public int i8x16_extract_lane(ByteVector vec, int laneIndex, int vectorOpcode) {
        ByteVector v = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec);
        return switch (vectorOpcode) {
            case 21 -> v.lane(laneIndex);
            case 22 -> Byte.toUnsignedInt(v.lane(laneIndex));
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public ByteVector i8x16_replace_lane(ByteVector vec, int laneIndex, byte value) {
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec).withLane(laneIndex, value));
    }

    @Override
    public short i16x8_extract_lane_s(ByteVector vecBytes, int laneIndex) {
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsShorts().lane(laneIndex);
    }

    @Override
    public int i16x8_extract_lane(ByteVector vecBytes, int laneIndex, int vectorOpcode) {
        ShortVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsShorts();
        return switch (vectorOpcode) {
            case 24 -> vec.lane(laneIndex);
            case 25 -> Short.toUnsignedInt(vec.lane(laneIndex));
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    @Override
    public ByteVector i16x8_replace_lane(ByteVector vecBytes, int laneIndex, short value) {
        ShortVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsShorts();
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec.withLane(laneIndex, value).reinterpretAsBytes());
    }

    @Override
    public int i32x4_extract_lane(ByteVector vecBytes, int laneIndex) {
        IntVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsInts();
        return vec.lane(laneIndex);
    }

    @Override
    public ByteVector i32x4_replace_lane(ByteVector vecBytes, int laneIndex, int value) {
        IntVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsInts();
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec.withLane(laneIndex, value).reinterpretAsBytes());
    }

    @Override
    public long i64x2_extract_lane(ByteVector vecBytes, int laneIndex) {
        LongVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsLongs();
        return vec.lane(laneIndex);
    }

    @Override
    public ByteVector i64x2_replace_lane(ByteVector vecBytes, int laneIndex, long value) {
        LongVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsLongs();
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec.withLane(laneIndex, value).reinterpretAsBytes());
    }

    @Override
    public float f32x4_extract_lane(ByteVector vecBytes, int laneIndex) {
        FloatVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsFloats();
        return vec.lane(laneIndex);
    }

    @Override
    public ByteVector f32x4_replace_lane(ByteVector vecBytes, int laneIndex, float value) {
        FloatVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsFloats();
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec.withLane(laneIndex, value).reinterpretAsBytes());
    }

    @Override
    public double f64x2_extract_lane(ByteVector vecBytes, int laneIndex) {
        DoubleVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsDoubles();
        return vec.lane(laneIndex);
    }

    @Override
    public ByteVector f64x2_replace_lane(ByteVector vecBytes, int laneIndex, double value) {
        DoubleVector vec = Vector128OpsVectorAPI.castByte128((Vector<Byte>)vecBytes).reinterpretAsDoubles();
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec.withLane(laneIndex, value).reinterpretAsBytes());
    }

    private static <E> ByteVector unop(ByteVector xBytes, Shape<E> shape, VectorOperators.Unary op) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector result = x.lanewise(op);
        return result.reinterpretAsBytes();
    }

    private static ByteVector i8x16_popcnt(ByteVector x) {
        ByteVector popcnt = x.sub((Vector)x.lanewise(VectorOperators.LSHR, 1L).and((byte)85));
        popcnt = popcnt.and((byte)51).add((Vector)popcnt.lanewise(VectorOperators.LSHR, 2L).and((byte)51));
        return popcnt.add((Vector)popcnt.lanewise(VectorOperators.LSHR, 4L)).and((byte)15);
    }

    private static <E, F> ByteVector extadd_pairwise(ByteVector xBytes, Shape<E> shape, VectorOperators.Conversion<E, F> conv) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector evens = x.compress(shape.evensMask).convert(conv, 0);
        Vector odds = x.compress(shape.oddsMask).convert(conv, 0);
        Vector result = evens.add(odds);
        return result.reinterpretAsBytes();
    }

    private static <E, F> ByteVector extend(ByteVector xBytes, int part, Shape<E> shape, VectorOperators.Conversion<E, F> conv) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector result = x.convert(conv, part);
        return result.reinterpretAsBytes();
    }

    private static IntVector getExponentFloats(Vector<Float> x) {
        return Vector128OpsVectorAPI.castInt128((Vector<Integer>)x.convert(VectorOperators.REINTERPRET_F2I, 0).lanewise((VectorOperators.Binary)VectorOperators.AND, 2139095040L).lanewise(VectorOperators.LSHR, 23L).sub((Vector)I32X4.broadcast(127)));
    }

    private static LongVector getExponentDoubles(Vector<Double> x) {
        return Vector128OpsVectorAPI.castLong128((Vector<Long>)x.convert(VectorOperators.REINTERPRET_D2L, 0).lanewise((VectorOperators.Binary)VectorOperators.AND, 0x7FF0000000000000L).lanewise(VectorOperators.LSHR, 52L).sub((Vector)I64X2.broadcast(1023L)));
    }

    private static <F, I> ByteVector ceil(ByteVector xBytes, Shape<F> floatingShape, Shape<I> integralShape, VectorOperators.Conversion<F, I> floatingAsIntegral, VectorOperators.Conversion<I, F> integralAsFloating, Function<Vector<F>, Vector<I>> getExponent, int significantWidth, Vector<I> significandBitMaskVec) {
        Vector<F> x = floatingShape.reinterpret(xBytes);
        return Vector128OpsVectorAPI.floorOrCeil(x, floatingShape, integralShape, floatingAsIntegral, integralAsFloating, getExponent, significantWidth, significandBitMaskVec, floatingShape.broadcast(-0.0), floatingShape.broadcast(1.0), floatingShape.broadcast(1.0));
    }

    private static <F, I> ByteVector floor(ByteVector xBytes, Shape<F> floatingShape, Shape<I> integralShape, VectorOperators.Conversion<F, I> floatingAsIntegral, VectorOperators.Conversion<I, F> integralAsFloating, Function<Vector<F>, Vector<I>> getExponent, int significantWidth, Vector<I> significandBitMaskVec) {
        Vector<F> x = floatingShape.reinterpret(xBytes);
        return Vector128OpsVectorAPI.floorOrCeil(x, floatingShape, integralShape, floatingAsIntegral, integralAsFloating, getExponent, significantWidth, significandBitMaskVec, floatingShape.broadcast(-1.0), floatingShape.broadcast(0.0), floatingShape.broadcast(-1.0));
    }

    private static <F, I> ByteVector trunc(ByteVector xBytes, Shape<F> floatingShape, Shape<I> integralShape, VectorOperators.Conversion<F, I> floatingAsIntegral, VectorOperators.Conversion<I, F> integralAsFloating, Function<Vector<F>, Vector<I>> getExponent, int significantWidth, Vector<I> significandBitMaskVec) {
        Vector<F> x = floatingShape.reinterpret(xBytes);
        VectorMask ceil = x.lt(floatingShape.broadcast(0L));
        return Vector128OpsVectorAPI.floorOrCeil(x, floatingShape, integralShape, floatingAsIntegral, integralAsFloating, getExponent, significantWidth, significandBitMaskVec, floatingShape.broadcast(-1.0).blend(floatingShape.broadcast(-0.0), ceil), floatingShape.broadcast(0.0).blend(floatingShape.broadcast(1.0), ceil), floatingShape.broadcast(-1.0).blend(floatingShape.broadcast(1.0), ceil));
    }

    private static <F, I> ByteVector floorOrCeil(Vector<F> x, Shape<F> floatingShape, Shape<I> integralShape, VectorOperators.Conversion<F, I> floatingAsIntegral, VectorOperators.Conversion<I, F> integralAsFloating, Function<Vector<F>, Vector<I>> getExponent, int significandWidth, Vector<I> significandBitMaskVec, Vector<F> negativeBoundary, Vector<F> positiveBoundary, Vector<F> sign) {
        Vector<I> exponent = getExponent.apply(x);
        VectorMask isNegativeExponent = exponent.lt(integralShape.broadcast(0L)).cast(floatingShape.species());
        VectorMask isZero = x.eq(floatingShape.broadcast(0L));
        VectorMask isNegative = x.lt(floatingShape.broadcast(0L));
        Vector negativeExponentResult = positiveBoundary.blend(negativeBoundary, isNegative).blend(x, isZero);
        VectorMask isHighExponent = exponent.compare(VectorOperators.GE, (long)(significandWidth - 1)).cast(floatingShape.species());
        Vector<F> highExponentResult = x;
        Vector doppel = x.convert(floatingAsIntegral, 0);
        Vector mask = significandBitMaskVec.lanewise(VectorOperators.LSHR, exponent);
        VectorMask isIntegral = doppel.lanewise((VectorOperators.Binary)VectorOperators.AND, mask).eq(integralShape.broadcast(0L)).cast(floatingShape.species());
        Vector<F> integralResult = x;
        Vector fractional = doppel.lanewise((VectorOperators.Binary)VectorOperators.AND, mask.lanewise(VectorOperators.NOT)).convert(integralAsFloating, 0);
        VectorMask signMatch = x.mul(sign).compare(VectorOperators.GT, 0L).cast(floatingShape.species());
        Vector fractionalResult = fractional.blend(fractional.add(sign), signMatch);
        Vector defaultResult = fractionalResult.blend(integralResult, isIntegral);
        Vector result = defaultResult.blend(highExponentResult, isHighExponent).blend(negativeExponentResult, isNegativeExponent);
        return result.reinterpretAsBytes();
    }

    private static <E> Vector<E> sign(Vector<E> x, Shape<E> shape) {
        VectorMask negative = x.test(VectorOperators.IS_NEGATIVE);
        return shape.broadcast(1L).blend(shape.broadcast(-1L), negative);
    }

    private static <E> ByteVector nearest(ByteVector xBytes, Shape<E> shape, long maxSafePowerOfTwo) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector<E> sign = Vector128OpsVectorAPI.sign(x, shape);
        Vector xAbs = x.lanewise(VectorOperators.ABS);
        Vector<E> maxFiniteValueVec = shape.broadcast(maxSafePowerOfTwo);
        VectorMask small = xAbs.lt(maxFiniteValueVec);
        Vector xTrunc = xAbs.blend(xAbs.add(maxFiniteValueVec).sub(maxFiniteValueVec), small);
        return xTrunc.mul(sign).reinterpretAsBytes();
    }

    private static <E, F> ByteVector convert(ByteVector xBytes, Shape<E> shape, VectorOperators.Conversion<E, F> conv) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector result = x.convert(conv, 0);
        return result.reinterpretAsBytes();
    }

    private static ByteVector i32x4_trunc_sat_f32x4_u(ByteVector xBytes) {
        FloatVector x = F32X4.reinterpret(xBytes);
        DoubleVector xLow = Vector128OpsVectorAPI.castDouble128((Vector<Double>)x.convert(VectorOperators.F2D, 0));
        DoubleVector xHigh = Vector128OpsVectorAPI.castDouble128((Vector<Double>)x.convert(VectorOperators.F2D, 1));
        LongVector xLowTrunc = Vector128OpsVectorAPI.truncSatU32(xLow);
        LongVector xHighTrunc = Vector128OpsVectorAPI.truncSatU32(xHigh);
        IntVector resultLow = Vector128OpsVectorAPI.castInt128(Vector128OpsVectorAPI.compact(xLowTrunc, 0, I64X2, I32X4));
        IntVector resultHigh = Vector128OpsVectorAPI.castInt128(Vector128OpsVectorAPI.compact(xHighTrunc, -1, I64X2, I32X4));
        IntVector result = resultLow.or((Vector)resultHigh);
        return result.reinterpretAsBytes();
    }

    private static ByteVector f32x4_convert_i32x4_u(ByteVector xBytes) {
        IntVector x = xBytes.reinterpretAsInts();
        LongVector xUnsignedLow = Vector128OpsVectorAPI.castLong128((Vector<Long>)x.convert(VectorOperators.ZERO_EXTEND_I2L, 0));
        LongVector xUnsignedHigh = Vector128OpsVectorAPI.castLong128((Vector<Long>)x.convert(VectorOperators.ZERO_EXTEND_I2L, 1));
        FloatVector resultLow = Vector128OpsVectorAPI.castFloat128(Vector128OpsVectorAPI.compactGeneral(xUnsignedLow, 0, I64X2, F32X4, VectorOperators.L2F, VectorOperators.REINTERPRET_F2I, VectorOperators.ZERO_EXTEND_I2L));
        FloatVector resultHigh = Vector128OpsVectorAPI.castFloat128(Vector128OpsVectorAPI.compactGeneral(xUnsignedHigh, -1, I64X2, F32X4, VectorOperators.L2F, VectorOperators.REINTERPRET_F2I, VectorOperators.ZERO_EXTEND_I2L));
        IntVector result = resultLow.reinterpretAsInts().or((Vector)resultHigh.reinterpretAsInts());
        return result.reinterpretAsBytes();
    }

    private static ByteVector i32x4_trunc_sat_f64x2_u_zero(ByteVector xBytes) {
        DoubleVector x = F64X2.reinterpret(xBytes);
        LongVector longResult = Vector128OpsVectorAPI.truncSatU32(x);
        IntVector result = Vector128OpsVectorAPI.castInt128(Vector128OpsVectorAPI.compact(longResult, 0, I64X2, I32X4));
        return result.reinterpretAsBytes();
    }

    private static ByteVector f64x2_convert_low_i32x4_u(ByteVector xBytes) {
        IntVector x = xBytes.reinterpretAsInts();
        LongVector xUnsignedLow = Vector128OpsVectorAPI.castLong128((Vector<Long>)x.convert(VectorOperators.ZERO_EXTEND_I2L, 0));
        DoubleVector result = Vector128OpsVectorAPI.castDouble128((Vector<Double>)xUnsignedLow.convert(VectorOperators.L2D, 0));
        return result.reinterpretAsBytes();
    }

    private static ByteVector f32X4_demote_f64X2_zero(ByteVector xBytes) {
        DoubleVector x = F64X2.reinterpret(xBytes);
        Vector<Float> result = Vector128OpsVectorAPI.compactGeneral(x, 0, I64X2, F32X4, VectorOperators.D2F, VectorOperators.REINTERPRET_F2I, VectorOperators.ZERO_EXTEND_I2L);
        return result.reinterpretAsBytes();
    }

    private static ByteVector i8x16_swizzle(ByteVector valueBytes, ByteVector indexBytes) {
        ByteVector values = valueBytes;
        ByteVector indices = indexBytes;
        VectorMask safeIndices = indices.lt((byte)0).or(indices.lt((byte)16).not()).not();
        return values.rearrange(indices.toShuffle(), safeIndices);
    }

    private static <E> ByteVector binop(ByteVector xBytes, ByteVector yBytes, Shape<E> shape, VectorOperators.Binary op) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector<E> y = shape.reinterpret(yBytes);
        Vector result = x.lanewise(op, y);
        return result.reinterpretAsBytes();
    }

    private static <E> ByteVector relop(ByteVector xBytes, ByteVector yBytes, Shape<E> shape, VectorOperators.Comparison comp) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector<E> y = shape.reinterpret(yBytes);
        Vector result = x.compare(comp, y).toVector();
        return result.reinterpretAsBytes();
    }

    private static ByteVector f32x4_relop(ByteVector xBytes, ByteVector yBytes, VectorOperators.Comparison comp) {
        FloatVector x = xBytes.reinterpretAsFloats();
        FloatVector y = yBytes.reinterpretAsFloats();
        IntVector zero = I32X4.zero();
        IntVector minusOne = I32X4.broadcast(-1);
        IntVector result = zero.blend((Vector)minusOne, x.compare(comp, (Vector)y).cast(I32X4.species()));
        return result.reinterpretAsBytes();
    }

    private static ByteVector f64x2_relop(ByteVector xBytes, ByteVector yBytes, VectorOperators.Comparison comp) {
        DoubleVector x = xBytes.reinterpretAsDoubles();
        DoubleVector y = yBytes.reinterpretAsDoubles();
        LongVector zero = I64X2.zero();
        LongVector minusOne = I64X2.broadcast(-1L);
        LongVector result = zero.blend((Vector)minusOne, x.compare(comp, (Vector)y).cast(I64X2.species()));
        return result.reinterpretAsBytes();
    }

    private static <E, F> Vector<F> compact(Vector<E> vec, int part, Shape<E> inShape, Shape<F> outShape) {
        assert (inShape.species().elementType() == Short.TYPE && outShape.species().elementType() == Byte.TYPE || inShape.species().elementType() == Integer.TYPE && outShape.species().elementType() == Short.TYPE || inShape.species().elementType() == Long.TYPE && outShape.species().elementType() == Integer.TYPE);
        VectorMask mask = switch (part) {
            case 0 -> outShape.lowMask;
            case -1 -> outShape.highMask;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        return vec.reinterpretShape(outShape.species(), 0).rearrange(outShape.compressEvensShuffle, mask);
    }

    private static <W, WI, N, NI> Vector<N> compactGeneral(Vector<W> vec, int part, Shape<WI> wideIntegralShape, Shape<N> narrowShape, VectorOperators.Conversion<W, N> downcast, VectorOperators.Conversion<N, NI> asIntegral, VectorOperators.Conversion<NI, WI> zeroExtend) {
        assert (zeroExtend.domainType() == Byte.TYPE && zeroExtend.rangeType() == Short.TYPE || zeroExtend.domainType() == Short.TYPE && zeroExtend.rangeType() == Integer.TYPE || zeroExtend.domainType() == Integer.TYPE && zeroExtend.rangeType() == Long.TYPE);
        VectorMask mask = switch (part) {
            case 0 -> narrowShape.lowMask;
            case -1 -> narrowShape.highMask;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        VectorSpecies halfSizeOutShape = narrowShape.species().withShape(VectorShape.S_64_BIT);
        Vector down = vec.convertShape(downcast, halfSizeOutShape, 0);
        Vector downIntegral = down.convert(asIntegral, 0);
        Vector upIntegral = downIntegral.convertShape(zeroExtend, wideIntegralShape.species(), 0);
        Vector narrowEvens = upIntegral.reinterpretShape(narrowShape.species(), 0);
        return narrowEvens.rearrange(narrowShape.compressEvensShuffle, mask);
    }

    private static <E, F> ByteVector narrow(ByteVector xBytes, ByteVector yBytes, Shape<E> inShape, Shape<F> outShape, long min, long max) {
        Vector<E> x = inShape.reinterpret(xBytes);
        Vector<E> y = inShape.reinterpret(yBytes);
        Vector<E> xSat = Vector128OpsVectorAPI.sat(x, inShape, min, max);
        Vector<E> ySat = Vector128OpsVectorAPI.sat(y, inShape, min, max);
        Vector<F> resultLow = Vector128OpsVectorAPI.compact(xSat, 0, inShape, outShape);
        Vector<F> resultHigh = Vector128OpsVectorAPI.compact(ySat, -1, inShape, outShape);
        Vector result = resultLow.lanewise((VectorOperators.Binary)VectorOperators.OR, resultHigh);
        return result.reinterpretAsBytes();
    }

    private static <E, F> ByteVector binop_sat(ByteVector xBytes, ByteVector yBytes, Shape<E> shape, Shape<F> extendedShape, VectorOperators.Conversion<E, F> upcast, VectorOperators.Binary op, long min, long max) {
        return Vector128OpsVectorAPI.upcastBinopDowncast(xBytes, yBytes, shape, extendedShape, upcast, (x, y) -> {
            Vector rawResult = x.lanewise(op, y);
            Vector satResult = Vector128OpsVectorAPI.sat(rawResult, extendedShape, min, max);
            return satResult;
        });
    }

    private static <E, F> ByteVector avgr_u(ByteVector xBytes, ByteVector yBytes, Shape<E> shape, Shape<F> extendedShape, VectorOperators.Conversion<E, F> upcast) {
        Vector one = extendedShape.broadcast(1L);
        return Vector128OpsVectorAPI.upcastBinopDowncast(xBytes, yBytes, shape, extendedShape, upcast, (x, y) -> x.add(y).add(one).lanewise(VectorOperators.LSHR, 1L));
    }

    private static ByteVector i16x8_q15mulr_sat_s(ByteVector xBytes, ByteVector yBytes) {
        return Vector128OpsVectorAPI.upcastBinopDowncast(xBytes, yBytes, I16X8, I32X4, VectorOperators.S2I, (x, y) -> {
            Vector rawResult = x.mul(y).add((Vector)I32X4.broadcast(16384)).lanewise(VectorOperators.ASHR, (Vector)I32X4.broadcast(15));
            Vector<Integer> satResult = Vector128OpsVectorAPI.sat(rawResult, I32X4, -32768L, 32767L);
            return satResult;
        });
    }

    private static <E, F> ByteVector extmul(ByteVector xBytes, ByteVector yBytes, Shape<E> shape, VectorOperators.Conversion<E, F> extend, int part) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector<E> y = shape.reinterpret(yBytes);
        Vector xExtended = x.convert(extend, part);
        Vector yExtended = y.convert(extend, part);
        Vector result = xExtended.mul(yExtended);
        return result.reinterpretAsBytes();
    }

    private static ByteVector i32x4_dot_i16x8_s(ByteVector xBytes, ByteVector yBytes) {
        ShortVector x = xBytes.reinterpretAsShorts();
        ShortVector y = yBytes.reinterpretAsShorts();
        IntVector xEvens = Vector128OpsVectorAPI.castInt128((Vector<Integer>)x.compress(Vector128OpsVectorAPI.castShort128Mask((VectorMask<Short>)Vector128OpsVectorAPI.I16X8.evensMask)).convert(VectorOperators.S2I, 0));
        IntVector xOdds = Vector128OpsVectorAPI.castInt128((Vector<Integer>)x.compress(Vector128OpsVectorAPI.castShort128Mask((VectorMask<Short>)Vector128OpsVectorAPI.I16X8.oddsMask)).convert(VectorOperators.S2I, 0));
        IntVector yEvens = Vector128OpsVectorAPI.castInt128((Vector<Integer>)y.compress(Vector128OpsVectorAPI.castShort128Mask((VectorMask<Short>)Vector128OpsVectorAPI.I16X8.evensMask)).convert(VectorOperators.S2I, 0));
        IntVector yOdds = Vector128OpsVectorAPI.castInt128((Vector<Integer>)y.compress(Vector128OpsVectorAPI.castShort128Mask((VectorMask<Short>)Vector128OpsVectorAPI.I16X8.oddsMask)).convert(VectorOperators.S2I, 0));
        Vector xMulYEvens = xEvens.mul((Vector)yEvens);
        Vector xMulYOdds = xOdds.mul((Vector)yOdds);
        Vector dot = xMulYEvens.lanewise((VectorOperators.Binary)VectorOperators.ADD, xMulYOdds);
        return dot.reinterpretAsBytes();
    }

    private static <E> ByteVector pmin(ByteVector xBytes, ByteVector yBytes, Shape<E> shape) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector<E> y = shape.reinterpret(yBytes);
        Vector result = x.blend(y, y.compare(VectorOperators.LT, x));
        return result.reinterpretAsBytes();
    }

    private static <E> ByteVector pmax(ByteVector xBytes, ByteVector yBytes, Shape<E> shape) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector<E> y = shape.reinterpret(yBytes);
        Vector result = x.blend(y, x.compare(VectorOperators.LT, y));
        return result.reinterpretAsBytes();
    }

    private static ByteVector i16x8_relaxed_dot_i8x16_i7x16_s(ByteVector x, ByteVector y) {
        ShortVector xEvens = Vector128OpsVectorAPI.castShort128((Vector<Short>)x.compress(Vector128OpsVectorAPI.castByte128Mask((VectorMask<Byte>)Vector128OpsVectorAPI.I8X16.evensMask)).convert(VectorOperators.B2S, 0));
        ShortVector xOdds = Vector128OpsVectorAPI.castShort128((Vector<Short>)x.compress(Vector128OpsVectorAPI.castByte128Mask((VectorMask<Byte>)Vector128OpsVectorAPI.I8X16.oddsMask)).convert(VectorOperators.B2S, 0));
        ShortVector yEvens = Vector128OpsVectorAPI.castShort128((Vector<Short>)y.compress(Vector128OpsVectorAPI.castByte128Mask((VectorMask<Byte>)Vector128OpsVectorAPI.I8X16.evensMask)).convert(VectorOperators.B2S, 0));
        ShortVector yOdds = Vector128OpsVectorAPI.castShort128((Vector<Short>)y.compress(Vector128OpsVectorAPI.castByte128Mask((VectorMask<Byte>)Vector128OpsVectorAPI.I8X16.oddsMask)).convert(VectorOperators.B2S, 0));
        Vector xMulYEvens = xEvens.mul((Vector)yEvens);
        Vector xMulYOdds = xOdds.mul((Vector)yOdds);
        Vector dot = xMulYEvens.lanewise(VectorOperators.SADD, xMulYOdds);
        return dot.reinterpretAsBytes();
    }

    private static ByteVector bitselect(ByteVector x, ByteVector y, ByteVector mask) {
        return y.lanewise((VectorOperators.Binary)VectorOperators.XOR, (Vector)y.lanewise((VectorOperators.Binary)VectorOperators.XOR, (Vector)x).lanewise((VectorOperators.Binary)VectorOperators.AND, (Vector)mask));
    }

    private static ByteVector f32x4_ternop(ByteVector xBytes, ByteVector yBytes, ByteVector zBytes, int vectorOpcode) {
        FloatVector x = xBytes.reinterpretAsFloats();
        FloatVector y = yBytes.reinterpretAsFloats();
        FloatVector z = zBytes.reinterpretAsFloats();
        FloatVector result = switch (vectorOpcode) {
            case 175 -> x.lanewise(VectorOperators.FMA, (Vector)y, (Vector)z);
            case 176 -> x.neg().lanewise(VectorOperators.FMA, (Vector)y, (Vector)z);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        return result.reinterpretAsBytes();
    }

    private static ByteVector f64x2_ternop(ByteVector xBytes, ByteVector yBytes, ByteVector zBytes, int vectorOpcode) {
        DoubleVector x = F64X2.reinterpret(xBytes);
        DoubleVector y = F64X2.reinterpret(yBytes);
        DoubleVector z = F64X2.reinterpret(zBytes);
        DoubleVector result = switch (vectorOpcode) {
            case 207 -> x.lanewise(VectorOperators.FMA, (Vector)y, (Vector)z);
            case 208 -> Vector128OpsVectorAPI.castDouble128((Vector<Double>)x.neg()).lanewise(VectorOperators.FMA, (Vector)y, (Vector)z);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        return result.reinterpretAsBytes();
    }

    private static ByteVector i32x4_relaxed_dot_i8x16_i7x16_add_s(ByteVector x, ByteVector y, ByteVector zBytes) {
        IntVector z = zBytes.reinterpretAsInts();
        ShortVector xEvens = Vector128OpsVectorAPI.castShort128((Vector<Short>)x.compress(Vector128OpsVectorAPI.castByte128Mask((VectorMask<Byte>)Vector128OpsVectorAPI.I8X16.evensMask)).convert(VectorOperators.B2S, 0));
        ShortVector xOdds = Vector128OpsVectorAPI.castShort128((Vector<Short>)x.compress(Vector128OpsVectorAPI.castByte128Mask((VectorMask<Byte>)Vector128OpsVectorAPI.I8X16.oddsMask)).convert(VectorOperators.B2S, 0));
        ShortVector yEvens = Vector128OpsVectorAPI.castShort128((Vector<Short>)y.compress(Vector128OpsVectorAPI.castByte128Mask((VectorMask<Byte>)Vector128OpsVectorAPI.I8X16.evensMask)).convert(VectorOperators.B2S, 0));
        ShortVector yOdds = Vector128OpsVectorAPI.castShort128((Vector<Short>)y.compress(Vector128OpsVectorAPI.castByte128Mask((VectorMask<Byte>)Vector128OpsVectorAPI.I8X16.oddsMask)).convert(VectorOperators.B2S, 0));
        ShortVector xMulYEvens = xEvens.mul((Vector)yEvens);
        ShortVector xMulYOdds = xOdds.mul((Vector)yOdds);
        ShortVector dot = xMulYEvens.lanewise(VectorOperators.SADD, (Vector)xMulYOdds);
        IntVector dotEvens = Vector128OpsVectorAPI.castInt128((Vector<Integer>)dot.compress(Vector128OpsVectorAPI.castShort128Mask((VectorMask<Short>)Vector128OpsVectorAPI.I16X8.evensMask)).convert(VectorOperators.S2I, 0));
        IntVector dotOdds = Vector128OpsVectorAPI.castInt128((Vector<Integer>)dot.compress(Vector128OpsVectorAPI.castShort128Mask((VectorMask<Short>)Vector128OpsVectorAPI.I16X8.oddsMask)).convert(VectorOperators.S2I, 0));
        IntVector dots = dotEvens.add((Vector)dotOdds);
        IntVector result = dots.add((Vector)z);
        return result.reinterpretAsBytes();
    }

    private static int v128_any_true(ByteVector vec) {
        return vec.eq((byte)0).allTrue() ? 0 : 1;
    }

    private static <E> int all_true(ByteVector vecBytes, Shape<E> shape) {
        Vector<E> vec = shape.reinterpret(vecBytes);
        return vec.eq(shape.zero()).anyTrue() ? 0 : 1;
    }

    private static <E> int bitmask(ByteVector vecBytes, Shape<E> shape) {
        Vector<E> vec = shape.reinterpret(vecBytes);
        VectorMask mask = vec.lt(shape.zero());
        return (int)mask.toLong();
    }

    private static <E> ByteVector shiftop(ByteVector xBytes, int shift, Shape<E> shape, VectorOperators.Binary shiftOp) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector result = x.lanewise(shiftOp, (long)shift);
        return result.reinterpretAsBytes();
    }

    private static <E> Class<? extends E> lookupClass(String className) {
        return Class.forName(Vector.class.getModule(), className);
    }

    private static ByteVector castByte128(Vector<Byte> vec) {
        return BYTE_128_CLASS.cast(vec);
    }

    private static ShortVector castShort128(Vector<Short> vec) {
        return SHORT_128_CLASS.cast(vec);
    }

    private static IntVector castInt128(Vector<Integer> vec) {
        return INT_128_CLASS.cast(vec);
    }

    private static LongVector castLong128(Vector<Long> vec) {
        return LONG_128_CLASS.cast(vec);
    }

    private static FloatVector castFloat128(Vector<Float> vec) {
        return FLOAT_128_CLASS.cast(vec);
    }

    private static DoubleVector castDouble128(Vector<Double> vec) {
        return DOUBLE_128_CLASS.cast(vec);
    }

    private static VectorMask<Byte> castByte128Mask(VectorMask<Byte> mask) {
        return BYTE_128_MASK_CLASS.cast(mask);
    }

    private static VectorMask<Short> castShort128Mask(VectorMask<Short> mask) {
        return SHORT_128_MASK_CLASS.cast(mask);
    }

    private static <E> Vector<E> sat(Vector<E> vec, Shape<E> shape, long min, long max) {
        Vector<E> vMin = shape.broadcast(min);
        Vector<E> vMax = shape.broadcast(max);
        return vec.max(vMin).min(vMax);
    }

    private static LongVector truncSatU32(DoubleVector x) {
        VectorMask underflow = x.test(VectorOperators.IS_NAN).or(x.test(VectorOperators.IS_NEGATIVE)).cast(I64X2.species());
        VectorMask overflow = x.compare(VectorOperators.GT, (Vector)F64X2.broadcast(4.294967295E9)).cast(I64X2.species());
        LongVector zero = I64X2.zero();
        LongVector u32max = I64X2.broadcast(0xFFFFFFFFL);
        LongVector trunc = Vector128OpsVectorAPI.castLong128((Vector<Long>)x.convert(VectorOperators.D2L, 0));
        return trunc.blend((Vector)u32max, overflow).blend((Vector)zero, underflow);
    }

    private static <E, F> ByteVector upcastBinopDowncast(ByteVector xBytes, ByteVector yBytes, Shape<E> shape, Shape<F> extendedShape, VectorOperators.Conversion<E, F> upcast, BinaryVectorOp<F> op) {
        Vector<E> x = shape.reinterpret(xBytes);
        Vector<E> y = shape.reinterpret(yBytes);
        Vector xLow = x.convert(upcast, 0);
        Vector xHigh = x.convert(upcast, 1);
        Vector yLow = y.convert(upcast, 0);
        Vector yHigh = y.convert(upcast, 1);
        Vector<E> resultLow = Vector128OpsVectorAPI.compact(op.apply(xLow, yLow), 0, extendedShape, shape);
        Vector<E> resultHigh = Vector128OpsVectorAPI.compact(op.apply(xHigh, yHigh), -1, extendedShape, shape);
        Vector result = resultLow.lanewise((VectorOperators.Binary)VectorOperators.OR, resultHigh);
        return result.reinterpretAsBytes();
    }

    @Override
    public ByteVector fromArray(byte[] bytes, int offset) {
        return ByteVector.fromArray(I8X16.species(), (byte[])bytes, (int)offset);
    }

    @Override
    public byte[] toArray(ByteVector vec) {
        return Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec).toArray();
    }

    @Override
    public void intoArray(ByteVector vec, byte[] array, int offset) {
        Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec).intoArray(array, offset);
    }

    @Override
    public Vector128 toVector128(ByteVector vec) {
        return new Vector128(Vector128OpsVectorAPI.castByte128((Vector<Byte>)vec).toArray());
    }

    @Override
    public ByteVector fromVector128(Vector128 vector128) {
        return (ByteVector)this.fromArray(vector128.getBytes());
    }

    private static final class I8X16Shape
    extends Shape<Byte> {
        private I8X16Shape() {
        }

        public ByteVector reinterpret(ByteVector bytes) {
            return Vector128OpsVectorAPI.castByte128((Vector<Byte>)bytes);
        }

        @Override
        public VectorSpecies<Byte> species() {
            return ByteVector.SPECIES_128;
        }

        public ByteVector zero() {
            return Vector128OpsVectorAPI.castByte128((Vector<Byte>)ByteVector.zero(this.species()));
        }

        public ByteVector broadcast(long e) {
            return Vector128OpsVectorAPI.castByte128((Vector<Byte>)ByteVector.broadcast(this.species(), (long)e));
        }

        public ByteVector broadcast(byte e) {
            return Vector128OpsVectorAPI.castByte128((Vector<Byte>)ByteVector.broadcast(this.species(), (byte)e));
        }
    }

    private static abstract class Shape<E> {
        public final VectorShuffle<E> compressEvensShuffle = VectorShuffle.fromOp(this.species(), i -> i * 2 % this.species().length());
        public final VectorMask<E> lowMask = VectorMask.fromLong(this.species(), (long)((1L << this.species().length() / 2) - 1L));
        public final VectorMask<E> highMask = VectorMask.fromLong(this.species(), (long)((1L << this.species().length() / 2) - 1L << this.species().length() / 2));
        public final VectorMask<E> evensMask;
        public final VectorMask<E> oddsMask;

        protected Shape() {
            boolean[] values = new boolean[this.species().length() + 1];
            for (int i2 = 0; i2 < values.length; ++i2) {
                values[i2] = i2 % 2 == 0;
            }
            this.evensMask = this.species().loadMask(values, 0);
            this.oddsMask = this.species().loadMask(values, 1);
        }

        public abstract Vector<E> reinterpret(ByteVector var1);

        public abstract VectorSpecies<E> species();

        public Vector<E> zero() {
            return this.species().zero();
        }

        public Vector<E> broadcast(long e) {
            return this.species().broadcast(e);
        }

        public Vector<E> broadcast(double e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static final class I16X8Shape
    extends Shape<Short> {
        private I16X8Shape() {
        }

        public ShortVector reinterpret(ByteVector bytes) {
            return Vector128OpsVectorAPI.castShort128((Vector<Short>)Vector128OpsVectorAPI.castByte128((Vector<Byte>)bytes).reinterpretAsShorts());
        }

        @Override
        public VectorSpecies<Short> species() {
            return ShortVector.SPECIES_128;
        }

        public ShortVector zero() {
            return Vector128OpsVectorAPI.castShort128((Vector<Short>)ShortVector.zero(this.species()));
        }

        public ShortVector broadcast(long e) {
            return Vector128OpsVectorAPI.castShort128((Vector<Short>)ShortVector.broadcast(this.species(), (long)e));
        }

        public ShortVector broadcast(short e) {
            return Vector128OpsVectorAPI.castShort128((Vector<Short>)ShortVector.broadcast(this.species(), (short)e));
        }
    }

    private static final class I32X4Shape
    extends Shape<Integer> {
        private I32X4Shape() {
        }

        public IntVector reinterpret(ByteVector bytes) {
            return Vector128OpsVectorAPI.castInt128((Vector<Integer>)Vector128OpsVectorAPI.castByte128((Vector<Byte>)bytes).reinterpretAsInts());
        }

        @Override
        public VectorSpecies<Integer> species() {
            return IntVector.SPECIES_128;
        }

        public IntVector zero() {
            return Vector128OpsVectorAPI.castInt128((Vector<Integer>)IntVector.zero(this.species()));
        }

        public IntVector broadcast(long e) {
            return Vector128OpsVectorAPI.castInt128((Vector<Integer>)IntVector.broadcast(this.species(), (long)e));
        }

        public IntVector broadcast(int e) {
            return Vector128OpsVectorAPI.castInt128((Vector<Integer>)IntVector.broadcast(this.species(), (int)e));
        }
    }

    private static final class I64X2Shape
    extends Shape<Long> {
        private I64X2Shape() {
        }

        public LongVector reinterpret(ByteVector bytes) {
            return Vector128OpsVectorAPI.castLong128((Vector<Long>)Vector128OpsVectorAPI.castByte128((Vector<Byte>)bytes).reinterpretAsLongs());
        }

        @Override
        public VectorSpecies<Long> species() {
            return LongVector.SPECIES_128;
        }

        public LongVector zero() {
            return Vector128OpsVectorAPI.castLong128((Vector<Long>)LongVector.zero(this.species()));
        }

        public LongVector broadcast(long e) {
            return Vector128OpsVectorAPI.castLong128((Vector<Long>)LongVector.broadcast(this.species(), (long)e));
        }
    }

    private static final class F32X4Shape
    extends Shape<Float> {
        private F32X4Shape() {
        }

        public FloatVector reinterpret(ByteVector bytes) {
            return Vector128OpsVectorAPI.castFloat128((Vector<Float>)Vector128OpsVectorAPI.castByte128((Vector<Byte>)bytes).reinterpretAsFloats());
        }

        @Override
        public VectorSpecies<Float> species() {
            return FloatVector.SPECIES_128;
        }

        public FloatVector zero() {
            return Vector128OpsVectorAPI.castFloat128((Vector<Float>)FloatVector.zero(this.species()));
        }

        public FloatVector broadcast(long e) {
            return Vector128OpsVectorAPI.castFloat128((Vector<Float>)FloatVector.broadcast(this.species(), (long)e));
        }

        public FloatVector broadcast(double e) {
            float f = (float)e;
            if ((double)f != e) {
                throw new IllegalArgumentException();
            }
            return this.broadcast(f);
        }

        public FloatVector broadcast(float e) {
            return Vector128OpsVectorAPI.castFloat128((Vector<Float>)FloatVector.broadcast(this.species(), (float)e));
        }
    }

    private static final class F64X2Shape
    extends Shape<Double> {
        private F64X2Shape() {
        }

        public DoubleVector reinterpret(ByteVector bytes) {
            return Vector128OpsVectorAPI.castDouble128((Vector<Double>)Vector128OpsVectorAPI.castByte128((Vector<Byte>)bytes).reinterpretAsDoubles());
        }

        @Override
        public VectorSpecies<Double> species() {
            return DoubleVector.SPECIES_128;
        }

        public DoubleVector zero() {
            return Vector128OpsVectorAPI.castDouble128((Vector<Double>)DoubleVector.zero(this.species()));
        }

        public DoubleVector broadcast(long e) {
            return Vector128OpsVectorAPI.castDouble128((Vector<Double>)DoubleVector.broadcast(this.species(), (long)e));
        }

        public DoubleVector broadcast(double e) {
            return Vector128OpsVectorAPI.castDouble128((Vector<Double>)DoubleVector.broadcast(this.species(), (double)e));
        }
    }

    @FunctionalInterface
    private static interface BinaryVectorOp<F> {
        public Vector<F> apply(Vector<F> var1, Vector<F> var2);
    }
}

