/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.predefined.wasi.types.Filetype;

public final class Fdstat {
    public static final int BYTES = 24;

    private Fdstat() {
    }

    public static Filetype readFsFiletype(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return Filetype.fromValue((byte)memoryLib.load_i32_8u(memory, node, address + 0));
    }

    public static void writeFsFiletype(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, Filetype value) {
        memoryLib.store_i32_8(memory, node, address + 0, value.toValue());
    }

    public static short readFsFlags(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return (short)memoryLib.load_i32_16u(memory, node, address + 2);
    }

    public static void writeFsFlags(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, short value) {
        memoryLib.store_i32_16(memory, node, address + 2, value);
    }

    public static long readFsRightsBase(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 8);
    }

    public static void writeFsRightsBase(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 8, value);
    }

    public static long readFsRightsInheriting(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 16);
    }

    public static void writeFsRightsInheriting(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 16, value);
    }
}

