/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.io.IOException;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.fd.FdManager;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiFdRenumberNode
extends WasmBuiltinRootNode {
    public WasiFdRenumberNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.fdRenumber(instance.store(), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public int fdRenumber(WasmStore store, int fd, int to) {
        FdManager fdManager;
        FdManager fdManager2 = fdManager = store.fdManager();
        synchronized (fdManager2) {
            Fd handle = fdManager.get(fd);
            if (handle == null) {
                return Errno.Badf.ordinal();
            }
            if (fd == to) {
                return Errno.Success.ordinal();
            }
            Fd toHandle = fdManager.get(to);
            if (toHandle == null) {
                return Errno.Badf.ordinal();
            }
            try {
                toHandle.close();
            }
            catch (IOException e) {
                return Errno.Io.ordinal();
            }
            fdManager.renumber(fd, to);
            return Errno.Success.ordinal();
        }
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_fd_renumber";
    }
}

