/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiFdFilestatSetTimesNode
extends WasmBuiltinRootNode {
    protected WasiFdFilestatSetTimesNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.fdstatSetTime(instance.store(), (Integer)WasmArguments.getArgument(args, 0), (Long)WasmArguments.getArgument(args, 1), (Long)WasmArguments.getArgument(args, 2), (Integer)WasmArguments.getArgument(args, 3));
    }

    @CompilerDirectives.TruffleBoundary
    private int fdstatSetTime(WasmStore store, int fd, long atim, long mtim, int fstFlags) {
        Fd handle = store.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        return handle.filestatSetTimes((Node)this, atim, mtim, fstFlags).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_fd_filestat_set_times";
    }
}

