/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import org.graalvm.wasm.nodes.WasmInstrumentableFunctionNode;

@GeneratedBy(value=WasmInstrumentableFunctionNode.class)
public final class WasmInstrumentableFunctionNodeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private WasmInstrumentableFunctionNodeGen() {
    }

    static {
        LibraryExport.register(WasmInstrumentableFunctionNode.class, (LibraryExport[])new LibraryExport[]{new NodeLibraryExports()});
    }

    @GeneratedBy(value=WasmInstrumentableFunctionNode.class)
    public static class NodeLibraryExports
    extends LibraryExport<NodeLibrary> {
        private NodeLibraryExports() {
            super(NodeLibrary.class, WasmInstrumentableFunctionNode.class, false, false, 0);
        }

        protected NodeLibrary createUncached(Object receiver) {
            assert (receiver instanceof WasmInstrumentableFunctionNode);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NodeLibrary createCached(Object receiver) {
            assert (receiver instanceof WasmInstrumentableFunctionNode);
            return new Cached(receiver);
        }

        @GeneratedBy(value=WasmInstrumentableFunctionNode.class)
        public static class Uncached
        extends NodeLibrary
        implements UnadoptableNode {
            private final Class<? extends WasmInstrumentableFunctionNode> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((WasmInstrumentableFunctionNode)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public boolean hasScope(Object receiver, Frame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmInstrumentableFunctionNode)receiver).hasScope(frame);
            }

            public Object getScope(Object receiver, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmInstrumentableFunctionNode)receiver).getScope(frame, nodeEnter);
            }
        }

        @GeneratedBy(value=WasmInstrumentableFunctionNode.class)
        public static class Cached
        extends NodeLibrary {
            private final Class<? extends WasmInstrumentableFunctionNode> receiverClass_;

            protected Cached(Object receiver) {
                WasmInstrumentableFunctionNode castReceiver = (WasmInstrumentableFunctionNode)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public boolean hasScope(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmInstrumentableFunctionNode)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasScope(frame);
            }

            public Object getScope(Object receiver, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmInstrumentableFunctionNode)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getScope(frame, nodeEnter);
            }
        }
    }
}

