/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.nio.file.Path;

public class DebugSourceLoader {
    @CompilerDirectives.TruffleBoundary
    public static Source create(Path path, String language, TruffleLanguage.Env env) {
        Source source;
        block3: {
            if (path == null || language == null) {
                return null;
            }
            source = null;
            try {
                source = Source.newBuilder((String)language, (CharSequence)"", (String)path.toString()).content(Source.CONTENT_NONE).build();
            }
            catch (SecurityException e) {
                if (env == null) break block3;
                env.getLogger("").warning("Debug source file could not be loaded or accessed: " + String.valueOf(path));
            }
        }
        return source;
    }

    @CompilerDirectives.TruffleBoundary
    public static Source load(Path path, String language, TruffleLanguage.Env env) {
        if (path == null || language == null) {
            return null;
        }
        Source source = null;
        try {
            TruffleFile file = env.getInternalTruffleFile(path.toString());
            source = Source.newBuilder((String)language, (TruffleFile)file).build();
        }
        catch (IOException | SecurityException e) {
            env.getLogger("").warning("Debug source file could not be loaded or accessed: " + String.valueOf(path));
        }
        return source;
    }
}

