/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data;

import com.oracle.truffle.api.CompilerDirectives;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.collection.IntArrayList;
import org.graalvm.wasm.debugging.DebugLineMap;
import org.graalvm.wasm.debugging.data.DebugDataUtil;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.DebugTypeRef;
import org.graalvm.wasm.debugging.data.objects.DebugConstantObject;
import org.graalvm.wasm.debugging.data.objects.DebugMember;
import org.graalvm.wasm.debugging.data.objects.DebugParameter;
import org.graalvm.wasm.debugging.data.objects.DebugVariable;
import org.graalvm.wasm.debugging.data.types.DebugArrayType;
import org.graalvm.wasm.debugging.data.types.DebugBaseType;
import org.graalvm.wasm.debugging.data.types.DebugEnumType;
import org.graalvm.wasm.debugging.data.types.DebugInheritance;
import org.graalvm.wasm.debugging.data.types.DebugPointerToMemberType;
import org.graalvm.wasm.debugging.data.types.DebugPointerType;
import org.graalvm.wasm.debugging.data.types.DebugStructType;
import org.graalvm.wasm.debugging.data.types.DebugSubroutineType;
import org.graalvm.wasm.debugging.data.types.DebugTypeDef;
import org.graalvm.wasm.debugging.data.types.DebugVariantType;
import org.graalvm.wasm.debugging.parser.DebugData;
import org.graalvm.wasm.debugging.parser.DebugParserContext;
import org.graalvm.wasm.debugging.parser.DebugParserScope;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;

public abstract class DebugObjectFactory {
    private static final DebugObject[] EMPTY_OBJECTS = new DebugObject[0];
    private static final DebugType[] EMPTY_TYPES = new DebugType[0];
    private final EconomicMap<Integer, DebugType> types = EconomicMap.create();
    private final EconomicMap<Integer, DebugObject> objects = EconomicMap.create();

    public abstract String languageName();

    protected abstract String namespaceSeparator();

    protected DebugType createArrayType(String name, DebugType elementType, int[] dimensionLengths) {
        return new DebugArrayType(name, elementType, dimensionLengths);
    }

    protected DebugType createStructType(String name, DebugObject[] members, DebugType[] superTypes) {
        return new DebugStructType(name, members, superTypes);
    }

    protected DebugType createEnumType(String name, DebugType baseType, EconomicMap<Long, String> values) {
        return new DebugEnumType(name, baseType, values);
    }

    protected DebugObject createParameter(String name, DebugType type, byte[] locationExpression) {
        return new DebugParameter(name, type, locationExpression);
    }

    protected DebugObject createMember(String name, DebugType type, byte[] locationExpression, int offset, int bitOffset, int bitSize) {
        return new DebugMember(name, type, locationExpression, offset, bitOffset, bitSize);
    }

    protected DebugType createPointerType(DebugType baseType) {
        return new DebugPointerType(baseType);
    }

    protected DebugType createSubroutineType(String name, DebugType returnType, DebugType[] parameterTypes) {
        return new DebugSubroutineType(name, returnType, parameterTypes);
    }

    protected DebugType createTypeDef(String name, DebugType baseType) {
        return new DebugTypeDef(name, baseType);
    }

    protected DebugObject createUnspecifiedParameters() {
        return new DebugConstantObject("...", new DebugConstantDisplayValue("..."));
    }

    protected DebugType createVariantType(String name, DebugObject discriminant, EconomicMap<Long, DebugObject> values) {
        return new DebugVariantType(name, discriminant, values);
    }

    protected DebugType createBaseType(String name, int encoding, int byteSize, int bitOffset, int bitSize) {
        return new DebugBaseType(name, encoding, byteSize, bitOffset, bitSize);
    }

    protected DebugType createQualifierType(int tag, String name, DebugType baseType) {
        return baseType;
    }

    protected DebugType createUnspecifiedType() {
        return DebugConstantObject.UNSPECIFIED;
    }

    private DebugType parseArrayType(DebugParserContext context, DebugParserScope scope, DebugData data) {
        String name = data.asStringOrNull(3);
        DebugType elementType = this.parse(context, scope, data.asI32OrDefault(73));
        if (elementType == null) {
            return null;
        }
        if (DebugObjectFactory.getChildOrNull(data, 33) == null) {
            return null;
        }
        IntArrayList dimensionLengths = new IntArrayList();
        DebugObjectFactory.forEachChild(data, 33, s -> dimensionLengths.add(s.asU32OrDefault(55, 0)));
        return this.createArrayType(name, elementType, dimensionLengths.toArray());
    }

    private DebugType parseStructType(DebugParserContext context, DebugParserScope scope, DebugData data) {
        String name = data.asStringOrNull(3);
        DebugData variantPart = DebugObjectFactory.getChildOrNull(data, 51);
        if (variantPart != null) {
            return this.parseVariantType(context, scope, name, variantPart);
        }
        ArrayList superTypes = new ArrayList();
        DebugObjectFactory.forEachChild(data, 28, i -> {
            if (i.asI32OrDefault(73, -1) == data.offset()) {
                return;
            }
            DebugType superType = this.parse(context, scope, (DebugData)i);
            if (superType != null) {
                superTypes.add(superType);
            }
        });
        ArrayList members = new ArrayList();
        DebugObjectFactory.forEachChild(data, 13, m -> {
            DebugObject member = this.parseObject(context, scope, (DebugData)m);
            if (member != null) {
                members.add(member);
            }
        });
        DebugObjectFactory.forEachChild(data, 46, s -> this.parse(context, scope, (DebugData)s));
        return this.createStructType(name, members.toArray(EMPTY_OBJECTS), superTypes.toArray(EMPTY_TYPES));
    }

    private DebugType parseEnumType(DebugParserContext context, DebugParserScope scope, DebugData data) {
        String name = data.asStringOrNull(3);
        DebugType baseType = this.parse(context, scope, data.asI32OrDefault(73));
        if (baseType == null) {
            return null;
        }
        EconomicMap values = EconomicMap.create();
        DebugObjectFactory.forEachChild(data, 40, e -> {
            long constValue = e.asI64OrDefault(28);
            if (constValue != -1L) {
                values.put((Object)constValue, (Object)e.asStringOrNull(3));
            }
        });
        return this.createEnumType(name, baseType, (EconomicMap<Long, String>)values);
    }

    private DebugObject parseFormalParameter(DebugParserContext context, DebugParserScope scope, DebugData data) {
        int location;
        String name = data.asStringOrNull(3);
        DebugType type = this.parse(context, scope, data.asI32OrDefault(73));
        if (type == null) {
            return null;
        }
        byte[] locationExpression = data.asByteArrayOrNull(2);
        if (locationExpression == null && (location = data.asI32OrDefault(2)) != -1) {
            locationExpression = context.readLocationListOrNull(location);
        }
        DebugObject parameter = this.createParameter(name, type, locationExpression);
        if (name != null) {
            scope.addVariable(parameter);
        }
        return parameter;
    }

    private void parseLexicalBlock(DebugParserContext context, DebugParserScope scope, DebugData data) {
        DebugParserScope blockScope;
        if (data.hasAttribute(17)) {
            int[] pcs = DebugDataUtil.readPcsOrNull(data, context);
            if (pcs == null) {
                return;
            }
            assert (pcs.length == 2) : "the pc range of a debug lexical block must contain exactly two values (start pc and end pc) ";
            blockScope = scope.with(null, pcs[0], pcs[1]);
        } else {
            blockScope = scope;
        }
        this.parseChildren(context, blockScope, data);
    }

    private DebugType parseImport(DebugParserContext context, DebugParserScope scope, DebugData data) {
        return this.parse(context, scope, data.asI32OrDefault(24));
    }

    private DebugObject parseMember(DebugParserContext context, DebugParserScope scope, DebugData data) {
        String name = data.asStringOrNull(3);
        DebugType type = this.parse(context, scope, data.asI32OrDefault(73));
        if (type == null) {
            return null;
        }
        byte[] locationExpression = data.asByteArrayOrNull(56);
        int offset = data.asI32OrDefault(56, 0);
        int bitOffset = data.asI32OrDefault(12, -1);
        int bitSize = data.asI32OrDefault(13, -1);
        return this.createMember(name, type, locationExpression, offset, bitOffset, bitSize);
    }

    private DebugType parsePointerType(DebugParserContext context, DebugParserScope scope, DebugData data) {
        DebugType type = this.parse(context, scope, data.asI32OrDefault(73));
        if (type == null) {
            return null;
        }
        return this.createPointerType(type);
    }

    private DebugType parseSubroutineType(DebugParserContext context, DebugParserScope scope, DebugData data) {
        String name = data.asStringOrNull(3);
        DebugType returnType = this.parse(context, scope, data.asI32OrDefault(73));
        ArrayList<DebugType> parameterTypes = new ArrayList<DebugType>();
        for (DebugData child : data.children()) {
            DebugType param;
            int tag = child.tag();
            if (tag != 5 && tag != 24 || (param = this.parse(context, scope, child)) == null) continue;
            parameterTypes.add(param);
        }
        return this.createSubroutineType(name, returnType, parameterTypes.toArray(EMPTY_TYPES));
    }

    private DebugType parseTypeDef(DebugParserContext context, DebugParserScope scope, DebugData data) {
        String name = data.asStringOrNull(3);
        if (name == null) {
            return null;
        }
        DebugType baseType = this.parse(context, scope, data.asI32OrDefault(73));
        return this.createTypeDef(name, baseType);
    }

    private DebugType parseVariantType(DebugParserContext context, DebugParserScope scope, String name, DebugData data) {
        int discr = data.asI32OrDefault(21);
        DebugObject discriminant = discr != -1 ? this.parseObject(context, scope, discr) : this.parseObject(context, scope, data.asI32OrDefault(73));
        if (discriminant == null) {
            return null;
        }
        EconomicMap values = EconomicMap.create();
        DebugParserScope variantScope = scope.with(name);
        DebugObjectFactory.forEachChild(data, 25, v -> {
            long discValue = v.asI64OrDefault(22);
            if (discValue == -1L) {
                return;
            }
            DebugObject entry = null;
            for (DebugData child : v.children()) {
                entry = this.parseObject(context, variantScope, child);
            }
            if (entry == null) {
                return;
            }
            values.put((Object)discValue, entry);
        });
        return this.createVariantType(name, discriminant, (EconomicMap<Long, DebugObject>)values);
    }

    private DebugType parseInheritance(DebugParserContext context, DebugParserScope scope, DebugData data) {
        DebugType referenceType = this.parse(context, scope, data.asI32OrDefault(73));
        if (referenceType == null) {
            return null;
        }
        byte[] locationExpression = data.asByteArrayOrNull(56);
        int memberOffset = data.asI32OrDefault(56, 0);
        return new DebugInheritance(referenceType, locationExpression, memberOffset);
    }

    private DebugType parsePointerToMemberType(DebugParserContext context, DebugParserScope scope, DebugData data) {
        DebugType memberType = this.parse(context, scope, data.asI32OrDefault(73));
        DebugType containingType = this.parse(context, scope, data.asI32OrDefault(29));
        return new DebugPointerToMemberType(memberType, containingType);
    }

    private DebugType parseQualifierType(DebugParserContext context, DebugParserScope scope, DebugData data) {
        String name = data.asStringOrNull(3);
        DebugType baseType = this.parse(context, scope, data.asI32OrDefault(73));
        if (baseType == null) {
            return null;
        }
        return this.createQualifierType(data.tag(), name, baseType);
    }

    private DebugType parseBaseType(DebugData data) {
        int bitOffset;
        String name = data.asStringOrNull(3);
        if (name == null) {
            return null;
        }
        int encoding = data.asI32OrDefault(62);
        if (encoding == -1) {
            return null;
        }
        int byteSize = data.asI32OrDefault(11);
        int bitSize = data.asI32OrDefault(13, -1);
        if (byteSize == -1) {
            if (bitSize == -1) {
                return null;
            }
            byteSize = 1;
        }
        if ((bitOffset = data.asI32OrDefault(12, -1)) == -1) {
            bitOffset = data.asI32OrDefault(107, 0);
        }
        return this.createBaseType(name, encoding, byteSize, bitSize, bitOffset);
    }

    private DebugType parseSubprogram(DebugParserContext context, DebugData data) {
        String name;
        int fileIndex;
        DebugData specData = context.dataOrNull(data.asI32OrDefault(71));
        if (specData != null) {
            int fileIndexValue = specData.asU32OrDefault(58);
            fileIndex = fileIndexValue != -1 ? fileIndexValue : data.asU32OrDefault(58, -1);
            name = specData.asStringOrNull(3);
        } else {
            fileIndex = data.asU32OrDefault(58, -1);
            name = data.asStringOrNull(3);
        }
        DebugLineMap lineMap = context.lineMapOrNull(fileIndex);
        if (lineMap == null) {
            return null;
        }
        if (data.exists(60)) {
            return null;
        }
        int inline = data.asI32OrDefault(32, 0);
        if (inline == 1 || inline == 3) {
            return null;
        }
        int[] pcs = DebugDataUtil.readPcsOrNull(data, context);
        if (pcs == null) {
            return null;
        }
        assert (pcs.length == 2) : "the pc range of a debug subprogram (function) must contain exactly two values (start pc and end pc)";
        int scopeStartPc = pcs[0];
        int scopeEndPc = pcs[1];
        int startLine = lineMap.getNextLine(scopeStartPc, scopeEndPc);
        if (startLine == -1) {
            return null;
        }
        Path path = context.pathOrNull(fileIndex);
        byte[] frameBaseExpression = data.asByteArrayOrNull(64);
        if (frameBaseExpression == null) {
            return null;
        }
        DebugParserScope functionScope = DebugParserScope.createFunctionScope(scopeStartPc, scopeEndPc, fileIndex);
        this.parseChildren(context, functionScope, data);
        List<DebugObject> globals = context.globals();
        List<DebugObject> variables = functionScope.variables();
        DebugFunction function = new DebugFunction(name, lineMap, path, context.language(), startLine, frameBaseExpression, variables, globals);
        if (name != null) {
            context.addFunction(scopeStartPc, function);
        }
        return function;
    }

    private DebugObject parseVariable(DebugParserContext context, DebugParserScope scope, DebugData data) {
        int startLineNumber;
        int fileIndex;
        int location;
        DebugType type;
        String variableName;
        DebugData specData = context.dataOrNull(data.asI32OrDefault(71));
        if (specData != null) {
            variableName = specData.asStringOrNull(3);
            type = this.parse(context, scope, specData.asI32OrDefault(73));
        } else {
            variableName = data.asStringOrNull(3);
            type = this.parse(context, scope, data.asI32OrDefault(73));
        }
        if (type == null) {
            return null;
        }
        String scopeName = scope.nameOrNull();
        Object name = scopeName == null ? variableName : scopeName + this.namespaceSeparator() + variableName;
        if (data.exists(60)) {
            return null;
        }
        byte[] locationExpression = data.asByteArrayOrNull(2);
        if (locationExpression == null && (location = data.asI32OrDefault(2)) != -1) {
            locationExpression = context.readLocationListOrNull(location);
        }
        if (locationExpression == null && specData != null && (locationExpression = specData.asByteArrayOrNull(2)) == null && (location = data.asI32OrDefault(2)) != -1) {
            locationExpression = context.readLocationListOrNull(location);
        }
        if ((fileIndex = data.asU32OrDefault(58, -1)) == -1) {
            fileIndex = specData != null ? specData.asU32OrDefault(58, scope.fileIndex()) : scope.fileIndex();
        }
        if ((startLineNumber = data.asU32OrDefault(59, -1)) == -1 && specData != null) {
            startLineNumber = specData.asU32OrDefault(59, -1);
        }
        int startLocation = context.sourceOffsetOrDefault(fileIndex, startLineNumber, scope.startLocation());
        int endLocation = scope.endLocation();
        DebugObject variable = startLocation != -1 && locationExpression != null ? new DebugVariable((String)name, type, locationExpression, startLocation, endLocation) : DebugConstantObject.UNDEFINED;
        if (variableName != null) {
            scope.addVariable(variable);
        }
        return variable;
    }

    private DebugType parseNamespace(DebugParserContext context, DebugParserScope scope, DebugData data) {
        String name = data.asStringOrEmpty(3);
        this.parseChildren(context, scope.with(name), data);
        return null;
    }

    private DebugType parse(DebugParserContext context, DebugParserScope scope, int offset) {
        if (offset == -1) {
            return null;
        }
        DebugData data = context.dataOrNull(offset);
        if (data == null) {
            return null;
        }
        return this.parse(context, scope, data);
    }

    @CompilerDirectives.TruffleBoundary
    public DebugType parse(DebugParserContext context, DebugParserScope scope, DebugData data) {
        DebugType type;
        int tag = data.tag();
        if (tag == 11) {
            this.parseLexicalBlock(context, scope, data);
            return null;
        }
        if (tag == 52 || tag == 13 || tag == 5 || tag == 24) {
            return this.parseObject(context, scope, data);
        }
        if (this.types.containsKey((Object)data.offset())) {
            return (DebugType)this.types.get((Object)data.offset());
        }
        DebugTypeRef objectRef = new DebugTypeRef();
        this.types.put((Object)data.offset(), (Object)objectRef);
        switch (data.tag()) {
            case 1: {
                DebugType debugType = this.parseArrayType(context, scope, data);
                break;
            }
            case 2: 
            case 19: 
            case 23: {
                DebugType debugType = this.parseStructType(context, scope, data);
                break;
            }
            case 4: {
                DebugType debugType = this.parseEnumType(context, scope, data);
                break;
            }
            case 8: 
            case 58: {
                DebugType debugType = this.parseImport(context, scope, data);
                break;
            }
            case 15: 
            case 16: 
            case 66: {
                DebugType debugType = this.parsePointerType(context, scope, data);
                break;
            }
            case 21: {
                DebugType debugType = this.parseSubroutineType(context, scope, data);
                break;
            }
            case 22: {
                DebugType debugType = this.parseTypeDef(context, scope, data);
                break;
            }
            case 28: {
                DebugType debugType = this.parseInheritance(context, scope, data);
                break;
            }
            case 31: {
                DebugType debugType = this.parsePointerToMemberType(context, scope, data);
                break;
            }
            case 35: 
            case 38: 
            case 53: 
            case 55: {
                DebugType debugType = this.parseQualifierType(context, scope, data);
                break;
            }
            case 36: {
                DebugType debugType = this.parseBaseType(data);
                break;
            }
            case 46: {
                DebugType debugType = this.parseSubprogram(context, data);
                break;
            }
            case 57: {
                DebugType debugType = this.parseNamespace(context, scope, data);
                break;
            }
            case 59: {
                DebugType debugType = this.createUnspecifiedType();
                break;
            }
            default: {
                DebugType debugType = type = null;
            }
        }
        if (type != null) {
            this.types.put((Object)data.offset(), (Object)type);
            objectRef.setDelegate(type);
        }
        return type;
    }

    private DebugObject parseObject(DebugParserContext context, DebugParserScope scope, int offset) {
        if (offset == -1) {
            return null;
        }
        DebugData data = context.dataOrNull(offset);
        if (data == null) {
            return null;
        }
        return this.parseObject(context, scope, data);
    }

    private DebugObject parseObject(DebugParserContext context, DebugParserScope scope, DebugData data) {
        DebugObject object;
        if (this.objects.containsKey((Object)data.offset())) {
            return (DebugObject)this.objects.get((Object)data.offset());
        }
        switch (data.tag()) {
            case 5: {
                DebugObject debugObject = this.parseFormalParameter(context, scope, data);
                break;
            }
            case 13: {
                DebugObject debugObject = this.parseMember(context, scope, data);
                break;
            }
            case 24: {
                DebugObject debugObject = this.createUnspecifiedParameters();
                break;
            }
            case 52: {
                DebugObject debugObject = this.parseVariable(context, scope, data);
                break;
            }
            default: {
                DebugObject debugObject = object = null;
            }
        }
        if (object != null) {
            this.objects.put((Object)data.offset(), (Object)object);
        }
        return object;
    }

    private static void forEachChild(DebugData data, int childTag, Consumer<DebugData> func) {
        for (DebugData child : data.children()) {
            if (child.tag() != childTag) continue;
            func.accept(child);
        }
    }

    private static DebugData getChildOrNull(DebugData data, int childTag) {
        for (DebugData child : data.children()) {
            if (child.tag() != childTag) continue;
            return child;
        }
        return null;
    }

    private void parseChildren(DebugParserContext context, DebugParserScope scope, DebugData data) {
        for (DebugData child : data.children()) {
            this.parse(context, scope, child);
        }
    }
}

