/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.collection;

import java.util.Arrays;
import java.util.NoSuchElementException;

public final class ByteArrayList {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private byte[] array = null;
    private int size = 0;

    public void add(byte b) {
        this.ensureSize();
        this.array[this.size] = b;
        ++this.size;
    }

    public void push(byte b) {
        this.add(b);
    }

    public byte popBack() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Cannot pop from an empty ByteArrayList.");
        }
        --this.size;
        return this.array[this.size];
    }

    public byte top() {
        return this.array[this.size - 1];
    }

    public void set(int index, byte b) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " greater or equal to list size" + this.size() + ".");
        }
        this.array[index] = b;
    }

    public byte get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " greater or equal to list size" + this.size() + ".");
        }
        return this.array[index];
    }

    public int size() {
        return this.size;
    }

    public void addRange(byte[] src, int srcOffset, int length) {
        this.ensureSize(this.size + length);
        System.arraycopy(src, srcOffset, this.array, this.size, length);
        this.size += length;
    }

    public void allocate(int length) {
        this.ensureSize(this.size + length);
        this.size += length;
    }

    private void ensureSize() {
        if (this.array == null) {
            this.array = new byte[4];
        } else if (this.size == this.array.length) {
            byte[] narray = new byte[this.array.length * 2];
            System.arraycopy(this.array, 0, narray, 0, this.size);
            this.array = narray;
        }
    }

    private void ensureSize(int newSize) {
        if (this.array == null) {
            this.array = new byte[2 * Integer.highestOneBit(newSize)];
        } else if (newSize > this.array.length) {
            byte[] narray = new byte[2 * Integer.highestOneBit(newSize)];
            System.arraycopy(this.array, 0, narray, 0, this.size);
            this.array = narray;
        }
    }

    public byte[] toArray() {
        byte[] result = new byte[this.size];
        if (this.array != null) {
            System.arraycopy(this.array, 0, result, 0, this.size);
            return result;
        }
        return EMPTY_BYTE_ARRAY;
    }

    public static byte[] concat(ByteArrayList ... byteArrayLists) {
        int totalSize = Arrays.stream(byteArrayLists).mapToInt(ByteArrayList::size).sum();
        byte[] result = new byte[totalSize];
        int resultOffset = 0;
        for (ByteArrayList byteArrayList : byteArrayLists) {
            if (byteArrayList.array == null) continue;
            System.arraycopy(byteArrayList.array, 0, result, resultOffset, byteArrayList.size);
            resultOffset += byteArrayList.size;
        }
        return result;
    }
}

