/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.TruffleObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.wasm.ImportDescriptor;
import org.graalvm.wasm.ImportValueSupplier;
import org.graalvm.wasm.Linker;
import org.graalvm.wasm.MemoryRegistry;
import org.graalvm.wasm.TableRegistry;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmContextOptions;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmInstantiator;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmOptions;
import org.graalvm.wasm.api.WebAssembly;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.exception.WasmJsApiException;
import org.graalvm.wasm.parser.bytecode.BytecodeParser;
import org.graalvm.wasm.predefined.BuiltinModule;
import org.graalvm.wasm.predefined.wasi.fd.FdManager;

public final class WasmStore
implements TruffleObject {
    private final WasmContext context;
    private final WasmLanguage language;
    private final MemoryRegistry memoryRegistry;
    private final TableRegistry tableRegistry;
    private final Linker linker;
    private final Map<String, WasmInstance> moduleInstances;
    private final FdManager filesManager;
    private final WasmContextOptions contextOptions;

    public WasmStore(WasmContext context, WasmLanguage language) {
        this.context = context;
        this.language = language;
        this.contextOptions = context.getContextOptions();
        this.tableRegistry = new TableRegistry();
        this.memoryRegistry = new MemoryRegistry();
        this.moduleInstances = new LinkedHashMap<String, WasmInstance>();
        this.linker = new Linker();
        this.filesManager = context.fdManager();
    }

    public WasmContext context() {
        return this.context;
    }

    public TruffleLanguage.Env environment() {
        return this.context.environment();
    }

    public WasmLanguage language() {
        return this.language;
    }

    public MemoryRegistry memories() {
        return this.memoryRegistry;
    }

    public TableRegistry tables() {
        return this.tableRegistry;
    }

    public Linker linker() {
        return this.linker;
    }

    public FdManager fdManager() {
        return this.filesManager;
    }

    public Map<String, WasmInstance> moduleInstances() {
        return this.moduleInstances;
    }

    @CompilerDirectives.TruffleBoundary
    public WasmInstance lookupModuleInstance(WasmModule module) {
        WasmInstance instance = this.moduleInstances.get(module.name());
        assert (instance == null || instance.module() == module);
        return instance;
    }

    @CompilerDirectives.TruffleBoundary
    public WasmInstance lookupModuleInstance(String name) {
        return this.moduleInstances.get(name);
    }

    public void register(WasmInstance instance) {
        if (this.moduleInstances.containsKey(instance.name())) {
            throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Context already contains an instance named '" + instance.name() + "'.");
        }
        this.moduleInstances.put(instance.name(), instance);
    }

    public ImportValueSupplier instantiateBuiltinInstances() {
        Map builtinModules = (Map)WasmOptions.Builtins.getValue(this.environment().getOptions());
        ImportValueSupplier importValues = ImportValueSupplier.none();
        if (builtinModules.isEmpty()) {
            return importValues;
        }
        for (Map.Entry entry : builtinModules.entrySet()) {
            String name = (String)entry.getKey();
            BuiltinModule builtinModule = (BuiltinModule)entry.getValue();
            WasmInstance importingModuleInstance = this.lookupImportingModuleInstance(name);
            if (importingModuleInstance == null) continue;
            WasmInstance builtinInstance = builtinModule.createInstance(this.language, this, name);
            this.moduleInstances.put(name, builtinInstance);
            if (builtinInstance.module().numImportedSymbols() == 0) continue;
            importValues = importValues.andThen((importDesc, intoInstance) -> {
                if (intoInstance == builtinInstance) {
                    try {
                        return WebAssembly.instanceExport(importingModuleInstance, importDesc.memberName());
                    }
                    catch (WasmJsApiException wasmJsApiException) {
                        // empty catch block
                    }
                }
                return null;
            });
        }
        return importValues;
    }

    private WasmInstance lookupImportingModuleInstance(String moduleName) {
        for (WasmInstance instance : this.moduleInstances().values()) {
            for (ImportDescriptor importDesc : instance.module().importedSymbols()) {
                if (!moduleName.equals(importDesc.moduleName())) continue;
                return instance;
            }
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public WasmInstance readInstance(WasmModule module) {
        if (this.moduleInstances.containsKey(module.name())) {
            throw WasmException.create(Failure.UNSPECIFIED_INVALID, null, "Module " + module.name() + " is already instantiated in this context.");
        }
        WasmInstantiator translator = new WasmInstantiator(this.language);
        WasmInstance instance = translator.createInstance(this, module);
        this.register(instance);
        return instance;
    }

    public void reinitInstance(WasmInstance instance, boolean reinitMemory) {
        BytecodeParser.resetGlobalState(instance.module(), instance);
        if (reinitMemory) {
            BytecodeParser.resetMemoryState(instance.module(), instance);
            BytecodeParser.resetTableState(this, instance.module(), instance);
            Linker.runStartFunction(instance);
        }
    }

    public WasmContextOptions getContextOptions() {
        return this.contextOptions;
    }
}

