/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.Source;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.ImportDescriptor;
import org.graalvm.wasm.ImportValueSupplier;
import org.graalvm.wasm.LinkAction;
import org.graalvm.wasm.ModuleLimits;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmInstantiator;
import org.graalvm.wasm.WasmStore;
import org.graalvm.wasm.WasmTable;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.parser.DebugTranslator;
import org.graalvm.wasm.exception.ExceptionProvider;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.globals.WasmGlobal;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.parser.ir.CodeEntry;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmModule
extends SymbolTable
implements TruffleObject {
    private final String name;
    private volatile List<LinkAction> linkActions;
    private final ModuleLimits limits;
    private Source source;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] bytecode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] customData;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] codeSection;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private CodeEntry[] codeEntries;
    @CompilerDirectives.CompilationFinal
    private boolean isParsed;
    private volatile boolean hasBeenInstantiated;
    private final ReentrantLock lock = new ReentrantLock();
    @CompilerDirectives.CompilationFinal
    private int debugInfoOffset;
    @CompilerDirectives.CompilationFinal
    private EconomicMap<Integer, DebugFunction> debugFunctions;
    private static final VarHandle LINK_ACTIONS;

    private WasmModule(String name, ModuleLimits limits) {
        this.name = name;
        this.limits = limits == null ? ModuleLimits.DEFAULTS : limits;
        this.linkActions = new ArrayList<LinkAction>();
        this.isParsed = false;
        this.debugInfoOffset = -1;
    }

    public static WasmModule create(String name, ModuleLimits limits) {
        return new WasmModule(name, limits);
    }

    public static WasmModule createBuiltin(String name) {
        return new WasmModule(name, null);
    }

    @Override
    protected WasmModule module() {
        return this;
    }

    public SymbolTable symbolTable() {
        return this;
    }

    public String name() {
        return this.name;
    }

    public List<LinkAction> getOrRecreateLinkActions() {
        List result = LINK_ACTIONS.getAndSet(this, null);
        if (result != null) {
            return result;
        }
        return WasmInstantiator.recreateLinkActions(this);
    }

    public void addLinkAction(LinkAction action) {
        assert (!this.isParsed());
        this.linkActions.add(action);
    }

    public boolean hasBeenInstantiated() {
        return this.hasBeenInstantiated;
    }

    public void setHasBeenInstantiated() {
        this.hasBeenInstantiated = true;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public ModuleLimits limits() {
        return this.limits;
    }

    public Source source() {
        if (this.source == null) {
            this.source = this.isBuiltin() ? Source.newBuilder((String)"wasm", (CharSequence)"", (String)this.name).internal(true).build() : Source.newBuilder((String)"wasm", (CharSequence)"", (String)this.name).build();
        }
        return this.source;
    }

    public byte[] bytecode() {
        return this.bytecode;
    }

    public int bytecodeLength() {
        return this.bytecode != null ? this.bytecode.length : 0;
    }

    public void setBytecode(byte[] bytecode) {
        this.bytecode = bytecode;
    }

    public CodeEntry[] codeEntries() {
        return this.codeEntries;
    }

    public void setCodeEntries(CodeEntry[] codeEntries) {
        this.codeEntries = codeEntries;
    }

    public boolean hasCodeEntries() {
        return this.codeEntries != null;
    }

    public void setParsed() {
        this.isParsed = true;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    public boolean isBuiltin() {
        return this.bytecode == null;
    }

    public byte[] customData() {
        return this.customData;
    }

    public void setCustomData(byte[] customData) {
        this.customData = customData;
    }

    public byte[] codeSection() {
        return this.codeSection;
    }

    public void setCodeSection(byte[] codeSection) {
        this.codeSection = codeSection;
    }

    public boolean hasDebugInfo() {
        return this.debugInfoOffset != -1;
    }

    public void setDebugInfoOffset(int offset) {
        this.debugInfoOffset = offset;
    }

    public int debugInfoOffset() {
        return this.debugInfoOffset;
    }

    @CompilerDirectives.TruffleBoundary
    public int functionSourceCodeStartOffset(int functionIndex) {
        if (this.codeSection == null) {
            return -1;
        }
        int codeEntryIndex = functionIndex - this.numImportedFunctions();
        int startOffset = BinaryStreamParser.rawPeekI32(this.codeSection, this.codeSection.length - 4);
        return BinaryStreamParser.rawPeekI32(this.codeSection, startOffset + 12 * codeEntryIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public int functionSourceCodeInstructionOffset(int functionIndex) {
        if (this.codeSection == null) {
            return -1;
        }
        int codeEntryIndex = functionIndex - this.numImportedFunctions();
        int startOffset = BinaryStreamParser.rawPeekI32(this.codeSection, this.codeSection.length - 4);
        return BinaryStreamParser.rawPeekI32(this.codeSection, startOffset + 4 + 12 * codeEntryIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public int functionSourceCodeEndOffset(int functionIndex) {
        if (this.codeSection == null) {
            return -1;
        }
        int codeEntryIndex = functionIndex - this.numImportedFunctions();
        int startOffset = BinaryStreamParser.rawPeekI32(this.codeSection, this.codeSection.length - 4);
        return BinaryStreamParser.rawPeekI32(this.codeSection, startOffset + 8 + 12 * codeEntryIndex);
    }

    public String toString() {
        return "wasm-module(" + this.name + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public EconomicMap<Integer, DebugFunction> debugFunctions() {
        if (this.debugFunctions == null && this.hasDebugInfo()) {
            DebugTranslator translator = new DebugTranslator(this.customData);
            this.debugFunctions = translator.readCompilationUnits(this.customData, this.debugInfoOffset);
        }
        return this.debugFunctions;
    }

    @ExportMessage
    boolean isInstantiable() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object instantiate(Object ... arguments) {
        Object importObject;
        WasmContext context = WasmContext.get(null);
        if (arguments.length == 0) {
            importObject = WasmConstant.NULL;
        } else if (arguments.length == 1) {
            importObject = arguments[0];
        } else {
            throw WasmException.provider().createTypeError(Failure.TYPE_MISMATCH, "Can only provide a single import object.");
        }
        WasmStore store = new WasmStore(context, context.language());
        return this.createInstance(store, importObject, WasmException.provider(), false);
    }

    public WasmInstance createInstance(WasmStore store, Object importObject, ExceptionProvider exceptionProvider, boolean importsOnlyInImportObject) {
        WasmInstance instance = store.readInstance(this);
        ImportValueSupplier imports = this.resolveModuleImports(importObject, exceptionProvider, importsOnlyInImportObject);
        store.linker().tryLink(instance, imports);
        return instance;
    }

    private ImportValueSupplier resolveModuleImports(Object importObject, ExceptionProvider exceptionProvider, boolean importsOnlyInImportObject) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(importObject);
        ArrayList<Object> resolvedImports = new ArrayList<Object>(this.numImportedSymbols());
        if (!this.importedSymbols().isEmpty() && !WasmModule.importObjectExists(importObject)) {
            if (importsOnlyInImportObject) {
                throw exceptionProvider.createTypeError(Failure.TYPE_MISMATCH, "Module requires imports, but import object is undefined.");
            }
            return ImportValueSupplier.none();
        }
        for (ImportDescriptor descriptor : this.importedSymbols()) {
            int listIndex = resolvedImports.size();
            assert (listIndex == descriptor.importedSymbolIndex());
            Object member = WasmModule.getImportObjectMember(importObject, descriptor, exceptionProvider, importsOnlyInImportObject);
            if (member == null) {
                assert (!importsOnlyInImportObject);
                resolvedImports.add(null);
                continue;
            }
            resolvedImports.add(switch (descriptor.identifier()) {
                case 0 -> WasmModule.requireCallable(member, descriptor, exceptionProvider);
                case 1 -> WasmModule.requireWasmTable(member, descriptor, exceptionProvider);
                case 2 -> WasmModule.requireWasmMemory(member, descriptor, exceptionProvider);
                case 3 -> WasmModule.requireWasmGlobal(member, descriptor, exceptionProvider);
                default -> throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Unknown import descriptor type: " + descriptor.identifier());
            });
        }
        assert (resolvedImports.size() == this.numImportedSymbols());
        return (importDesc, instance) -> {
            if (instance.module() == this) {
                return resolvedImports.get(importDesc.importedSymbolIndex());
            }
            return null;
        };
    }

    private static boolean importObjectExists(Object importObject) {
        InteropLibrary interop = InteropLibrary.getUncached((Object)importObject);
        return !interop.isNull(importObject) && interop.hasMembers(importObject);
    }

    private static Object getImportObjectMember(Object importObject, ImportDescriptor descriptor, ExceptionProvider exceptionProvider, boolean importsOnlyInImportObject) {
        try {
            InteropLibrary importObjectInterop = InteropLibrary.getUncached((Object)importObject);
            if (!importObjectInterop.isMemberReadable(importObject, descriptor.moduleName())) {
                if (!importsOnlyInImportObject) {
                    return null;
                }
                throw exceptionProvider.formatTypeError(Failure.TYPE_MISMATCH, "Import object does not contain module \"%s\".", descriptor.moduleName());
            }
            Object importedModuleObject = importObjectInterop.readMember(importObject, descriptor.moduleName());
            InteropLibrary moduleObjectInterop = InteropLibrary.getUncached((Object)importedModuleObject);
            if (!moduleObjectInterop.isMemberReadable(importedModuleObject, descriptor.memberName())) {
                throw exceptionProvider.formatLinkError(Failure.UNKNOWN_IMPORT, "Import module object \"%s\" does not contain \"%s\".", descriptor.moduleName(), descriptor.memberName());
            }
            return moduleObjectInterop.readMember(importedModuleObject, descriptor.memberName());
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Unexpected state.");
        }
    }

    private static Object requireCallable(Object member, ImportDescriptor importDescriptor, ExceptionProvider exceptionProvider) {
        if (!(member instanceof WasmFunctionInstance) && !InteropLibrary.getUncached().isExecutable(member)) {
            throw exceptionProvider.createLinkError(Failure.INCOMPATIBLE_IMPORT_TYPE, "Member " + String.valueOf(member) + " " + String.valueOf(importDescriptor) + " is not callable.");
        }
        return member;
    }

    private static WasmMemory requireWasmMemory(Object member, ImportDescriptor importDescriptor, ExceptionProvider exceptionProvider) {
        if (!(member instanceof WasmMemory)) {
            throw exceptionProvider.createLinkError(Failure.INCOMPATIBLE_IMPORT_TYPE, "Member " + String.valueOf(member) + " " + String.valueOf(importDescriptor) + " is not a valid memory.");
        }
        WasmMemory memory = (WasmMemory)member;
        return memory;
    }

    private static WasmTable requireWasmTable(Object member, ImportDescriptor importDescriptor, ExceptionProvider exceptionProvider) {
        if (!(member instanceof WasmTable)) {
            throw exceptionProvider.createLinkError(Failure.INCOMPATIBLE_IMPORT_TYPE, "Member " + String.valueOf(member) + " " + String.valueOf(importDescriptor) + " is not a valid table.");
        }
        WasmTable table = (WasmTable)member;
        return table;
    }

    private static WasmGlobal requireWasmGlobal(Object member, ImportDescriptor importDescriptor, ExceptionProvider exceptionProvider) {
        if (!(member instanceof WasmGlobal)) {
            throw exceptionProvider.createLinkError(Failure.INCOMPATIBLE_IMPORT_TYPE, "Member " + String.valueOf(member) + " " + String.valueOf(importDescriptor) + " is not a valid global.");
        }
        WasmGlobal global = (WasmGlobal)member;
        return global;
    }

    static {
        try {
            LINK_ACTIONS = MethodHandles.lookup().findVarHandle(WasmModule.class, "linkActions", List.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

