/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;

public class MemoryContext {
    private final ReferenceQueue<WasmMemory> cleanerRefQueue = new ReferenceQueue();
    private final Set<Cleanable> phantomCleanableSet = ConcurrentHashMap.newKeySet();
    private final Set<Cleanable> weakCleanableSet = ConcurrentHashMap.newKeySet();

    public void close() {
        this.weakCleanableSet.forEach(Cleanable::clean);
        this.phantomCleanableSet.forEach(Cleanable::clean);
        this.processCleanerQueue();
    }

    public void registerCleaner(WasmMemory referent, Runnable cleanup) {
        this.processCleanerQueue();
        this.phantomCleanableSet.add(new PhantomCleanableRef(referent, this.cleanerRefQueue, cleanup, this.phantomCleanableSet));
        this.weakCleanableSet.add(new WeakCleanableRef(referent, this.cleanerRefQueue, this.weakCleanableSet));
    }

    private void processCleanerQueue() {
        Cleanable ref;
        while ((ref = (Cleanable)((Object)this.cleanerRefQueue.poll())) != null) {
            ref.clean();
        }
    }

    private static final class PhantomCleanableRef
    extends PhantomReference<WasmMemory>
    implements Cleanable {
        private final Runnable action;
        private final Set<Cleanable> cleanableRefs;

        PhantomCleanableRef(WasmMemory referent, ReferenceQueue<? super WasmMemory> queue, Runnable action, Set<Cleanable> cleanableRefs) {
            super(referent, queue);
            this.action = action;
            this.cleanableRefs = cleanableRefs;
        }

        @Override
        public void clean() {
            super.clear();
            this.cleanableRefs.remove(this);
            this.action.run();
        }
    }

    private static final class WeakCleanableRef
    extends WeakReference<WasmMemory>
    implements Cleanable {
        private final Set<Cleanable> cleanableRefs;

        WeakCleanableRef(WasmMemory referent, ReferenceQueue<? super WasmMemory> queue, Set<Cleanable> cleanableRefs) {
            super(referent, queue);
            this.cleanableRefs = cleanableRefs;
        }

        @Override
        public void clean() {
            WasmMemory wasmMemory = (WasmMemory)this.get();
            super.clear();
            if (wasmMemory != null) {
                WasmMemoryLibrary.getUncached().close(wasmMemory);
            }
            this.cleanableRefs.remove(this);
        }
    }

    private static interface Cleanable {
        public void clean();
    }
}

