/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.util;

public class ExtraDataAccessor {
    private static final int INDICATOR_REMOVAL_MASK = Integer.MAX_VALUE;
    public static final int COMPACT_IF_LENGTH = 2;
    public static final int EXTENDED_IF_LENGTH = 3;
    public static final int COMPACT_IF_PROFILE_OFFSET = 1;
    public static final int EXTENDED_IF_PROFILE_OFFSET = 2;
    public static final int COMPACT_BR_IF_LENGTH = 2;
    public static final int EXTENDED_BR_IF_LENGTH = 6;
    public static final int COMPACT_BR_IF_PROFILE_OFFSET = 1;
    public static final int EXTENDED_BR_IF_PROFILE_OFFSET = 5;
    public static final int COMPACT_BR_TABLE_PROFILE_OFFSET = 0;
    public static final int EXTENDED_BR_TABLE_PROFILE_OFFSET = 1;
    public static final int COMPACT_BR_TABLE_HEADER_LENGTH = 1;
    public static final int EXTENDED_BR_TABLE_HEADER_LENGTH = 2;
    public static final int CALL_LENGTH = 1;
    public static final int COMPACT_CALL_INDIRECT_LENGTH = 1;
    public static final int EXTENDED_CALL_INDIRECT_LENGTH = 2;
    public static final int COMPACT_CALL_INDIRECT_PROFILE_OFFSET = 0;
    public static final int EXTENDED_CALL_INDIRECT_PROFILE_OFFSET = 1;
    public static final int PRIMITIVE_UNWIND = 0x800000;
    public static final int REFERENCE_UNWIND = Integer.MIN_VALUE;
    public static final int UNKNOWN_UNWIND = -2139095040;

    public static int firstValueUnsigned(int[] extraData, int offset, boolean compact) {
        if (compact) {
            return extraData[offset] >>> 16;
        }
        return extraData[offset] & Integer.MAX_VALUE;
    }

    public static int firstValueSigned(int[] extraData, int offset, boolean compact) {
        if (compact) {
            return extraData[offset] << 1 >> 17;
        }
        return extraData[offset] << 1 >> 1;
    }

    public static int secondValueSigned(int[] extraData, int offset, boolean compact) {
        if (compact) {
            return extraData[offset] << 16 >> 16;
        }
        return extraData[offset + 1];
    }

    public static int thirdValueUnsigned(int[] extraData, int offset, boolean compact) {
        if (compact) {
            return extraData[offset + 1] & 0x80800000;
        }
        return extraData[offset + 2];
    }

    public static int fourthValueUnsigned(int[] extraData, int offset, boolean compact) {
        if (compact) {
            return (extraData[offset + 1] & 0x7F000000) >>> 24;
        }
        return extraData[offset + 3];
    }

    public static int fifthValueUnsigned(int[] extraData, int offset, boolean compact) {
        if (compact) {
            return (extraData[offset + 1] & 0x7F0000) >>> 16;
        }
        return extraData[offset + 4];
    }
}

