/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.predefined.wasi.types.Filetype;

public final class Filestat {
    public static final int BYTES = 64;

    private Filestat() {
    }

    public static long readDev(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 0);
    }

    public static void writeDev(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 0, value);
    }

    public static long readIno(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 8);
    }

    public static void writeIno(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 8, value);
    }

    public static Filetype readFiletype(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return Filetype.fromValue((byte)memoryLib.load_i32_8u(memory, node, address + 16));
    }

    public static void writeFiletype(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, Filetype value) {
        memoryLib.store_i32_8(memory, node, address + 16, value.toValue());
    }

    public static long readNlink(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 24);
    }

    public static void writeNlink(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 24, value);
    }

    public static long readSize(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 32);
    }

    public static void writeSize(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 32, value);
    }

    public static long readAtim(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 40);
    }

    public static void writeAtim(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 40, value);
    }

    public static long readMtim(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 48);
    }

    public static void writeMtim(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 48, value);
    }

    public static long readCtim(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 56);
    }

    public static void writeCtim(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 56, value);
    }
}

