/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Advice;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiFdAdviseNode
extends WasmBuiltinRootNode {
    public WasiFdAdviseNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return WasiFdAdviseNode.fdAdvise(context, (Integer)WasmArguments.getArgument(args, 0), (Long)WasmArguments.getArgument(args, 1), (Long)WasmArguments.getArgument(args, 2), (Integer)WasmArguments.getArgument(args, 3));
    }

    @CompilerDirectives.TruffleBoundary
    private static int fdAdvise(WasmContext context, int fd, long offset, long length, int adviceValue) {
        Fd handle = context.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        if (adviceValue < 0 || adviceValue >= Advice.values().length) {
            return Errno.Inval.ordinal();
        }
        Advice advice = Advice.values()[adviceValue];
        if (length < 0L) {
            return Errno.Inval.ordinal();
        }
        return handle.advise(offset, length, advice).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_fd_advise";
    }
}

