/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.types.Clockid;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiClockTimeGetNode
extends WasmBuiltinRootNode {
    public WasiClockTimeGetNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        assert (WasmArguments.getArgumentCount(args) == 3);
        return this.clockTimeGet(this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 2));
    }

    @CompilerDirectives.TruffleBoundary
    private Object clockTimeGet(WasmMemory memory, int clockIdValue, int resultAddress) {
        Clockid clockId = Clockid.values()[clockIdValue];
        switch (clockId) {
            case Realtime: {
                this.memoryLib.store_i64(memory, (Node)this, resultAddress, WasiClockTimeGetNode.realtimeNow());
                break;
            }
            case Monotonic: {
                this.memoryLib.store_i64(memory, (Node)this, resultAddress, WasiClockTimeGetNode.monotonicNow());
                break;
            }
            case ProcessCputimeId: 
            case ThreadCputimeId: {
                throw WasiClockTimeGetNode.unimplementedClock(clockId);
            }
        }
        return Errno.Success.ordinal();
    }

    @CompilerDirectives.TruffleBoundary
    public static long realtimeNow() {
        return ChronoUnit.NANOS.between(Instant.EPOCH, Instant.now());
    }

    @CompilerDirectives.TruffleBoundary
    public static long monotonicNow() {
        return System.nanoTime();
    }

    @CompilerDirectives.TruffleBoundary
    private static WasmException unimplementedClock(Clockid clockId) {
        throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Unimplemented ClockID: " + clockId.name());
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_clock_time_get";
    }
}

