/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiArgsSizesGetNode
extends WasmBuiltinRootNode {
    public WasiArgsSizesGetNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.argsSizesGet(this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1));
    }

    @CompilerDirectives.TruffleBoundary
    private int argsSizesGet(WasmMemory memory, int argcAddress, int argvBufSizeAddress) {
        String[] arguments = this.getContext().environment().getApplicationArguments();
        int argc = arguments.length;
        int argvBufSize = 0;
        for (String argument : arguments) {
            argvBufSize += WasmMemory.encodedStringLength(argument);
            ++argvBufSize;
        }
        this.memoryLib.store_i32(memory, (Node)this, argcAddress, argc);
        this.memoryLib.store_i32(memory, (Node)this, argvBufSizeAddress, argvBufSize);
        return Errno.Success.ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_args_sizes_get";
    }
}

