/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmCodeEntry;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmMath;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmTable;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.api.Vector128Ops;
import org.graalvm.wasm.constants.Vector128OpStackEffects;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.nodes.WasmDirectCallNode;
import org.graalvm.wasm.nodes.WasmFrame;
import org.graalvm.wasm.nodes.WasmIndirectCallNode;
import org.graalvm.wasm.nodes.WasmNotifyFunction;
import org.graalvm.wasm.nodes.WasmRootNode;

public final class WasmFunctionNode
extends Node
implements BytecodeOSRNode {
    private static final float MIN_FLOAT_TRUNCATABLE_TO_INT = -2.1474836E9f;
    private static final float MAX_FLOAT_TRUNCATABLE_TO_INT = 2.1474835E9f;
    private static final float MIN_FLOAT_TRUNCATABLE_TO_U_INT = -0.99999994f;
    private static final float MAX_FLOAT_TRUNCATABLE_TO_U_INT = 4.294967E9f;
    private static final double MIN_DOUBLE_TRUNCATABLE_TO_INT = -2.1474836489999995E9;
    private static final double MAX_DOUBLE_TRUNCATABLE_TO_INT = 2.1474836479999998E9;
    private static final double MIN_DOUBLE_TRUNCATABLE_TO_U_INT = -0.9999999999999999;
    private static final double MAX_DOUBLE_TRUNCATABLE_TO_U_INT = 4.2949672959999995E9;
    private static final float MIN_FLOAT_TRUNCATABLE_TO_LONG = -9.223372E18f;
    private static final float MAX_FLOAT_TRUNCATABLE_TO_LONG = 9.2233715E18f;
    private static final float MIN_FLOAT_TRUNCATABLE_TO_U_LONG = -0.99999994f;
    private static final float MAX_FLOAT_TRUNCATABLE_TO_U_LONG = 1.8446743E19f;
    private static final double MIN_DOUBLE_TRUNCATABLE_TO_LONG = -9.223372036854776E18;
    private static final double MAX_DOUBLE_TRUNCATABLE_TO_LONG = 9.223372036854775E18;
    private static final double MIN_DOUBLE_TRUNCATABLE_TO_U_LONG = -0.9999999999999999;
    private static final double MAX_DOUBLE_TRUNCATABLE_TO_U_LONG = 1.844674407370955E19;
    private static final int REPORT_LOOP_STRIDE = 256;
    private final WasmModule module;
    private final WasmCodeEntry codeEntry;
    @Node.Children
    private Node[] callNodes;
    @CompilerDirectives.CompilationFinal
    private Object osrMetadata;
    @CompilerDirectives.CompilationFinal
    private int bytecodeStartOffset;
    @CompilerDirectives.CompilationFinal
    private int bytecodeEndOffset;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] bytecode;
    @CompilerDirectives.CompilationFinal
    private WasmNotifyFunction notifyFunction;
    @Node.Children
    private WasmMemoryLibrary[] memoryLibs;
    private static final int MAX_PROFILE_VALUE = 255;
    private static final int MAX_TABLE_PROFILE_VALUE = 65535;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WasmFunctionNode(WasmModule module, WasmCodeEntry codeEntry, int bytecodeStartOffset, int bytecodeEndOffset, Node[] callNodes, WasmMemoryLibrary[] memoryLibs) {
        this.module = module;
        this.codeEntry = codeEntry;
        this.bytecodeStartOffset = bytecodeStartOffset;
        this.bytecodeEndOffset = bytecodeEndOffset;
        this.bytecode = codeEntry.bytecode();
        this.callNodes = new Node[callNodes.length];
        for (int childIndex = 0; childIndex < callNodes.length; ++childIndex) {
            this.callNodes[childIndex] = this.insert(callNodes[childIndex].deepCopy());
        }
        this.memoryLibs = memoryLibs;
    }

    private void enterErrorBranch() {
        this.codeEntry.errorBranch();
    }

    void updateBytecode(byte[] bytecode, int bytecodeStartOffset, int bytecodeEndOffset, WasmNotifyFunction notifyFunction) {
        this.bytecode = bytecode;
        this.bytecodeStartOffset = bytecodeStartOffset;
        this.bytecodeEndOffset = bytecodeEndOffset;
        this.notifyFunction = notifyFunction;
    }

    private WasmMemory memory(WasmInstance instance, int index) {
        return instance.memory(index).checkSize(this.memoryLib(index), this.module.memoryInitialSize(index));
    }

    private WasmMemoryLibrary memoryLib(int memoryIndex) {
        return this.memoryLibs[memoryIndex];
    }

    public Object executeOSR(VirtualFrame osrFrame, int target, Object interpreterState) {
        WasmOSRInterpreterState state = (WasmOSRInterpreterState)interpreterState;
        WasmContext context = WasmContext.get(this);
        WasmInstance instance = ((WasmRootNode)this.getRootNode()).instance(osrFrame);
        return this.executeBodyFromOffset(context, instance, osrFrame, target, state.stackPointer, state.line);
    }

    public Object getOSRMetadata() {
        return this.osrMetadata;
    }

    public void setOSRMetadata(Object osrMetadata) {
        this.osrMetadata = osrMetadata;
    }

    public Object[] storeParentFrameInArguments(VirtualFrame parentFrame) {
        CompilerAsserts.neverPartOfCompilation();
        WasmInstance instance = ((WasmRootNode)this.getRootNode()).instance(parentFrame);
        Object[] osrFrameArgs = new Object[]{instance, parentFrame};
        if (!$assertionsDisabled && !WasmArguments.isValid(osrFrameArgs)) {
            throw new AssertionError();
        }
        return osrFrameArgs;
    }

    public Frame restoreParentFrameFromArguments(Object[] arguments) {
        return (Frame)arguments[1];
    }

    public void execute(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        this.executeBodyFromOffset(context, instance, frame, this.bytecodeStartOffset, this.codeEntry.localCount(), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HostCompilerDirectives.BytecodeInterpreterSwitch
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    public Object executeBodyFromOffset(WasmContext context, WasmInstance instance, VirtualFrame frame, int startOffset, int startStackPointer, int startLine) {
        int localCount = this.codeEntry.localCount();
        byte[] bytecode = this.bytecode;
        BackEdgeCounter backEdgeCounter = new BackEdgeCounter();
        int offset = startOffset;
        int stackPointer = startStackPointer;
        int line = startLine;
        WasmMemory zeroMemory = !this.codeEntry.usesMemoryZero() ? null : this.memory(instance, 0);
        WasmMemoryLibrary zeroMemoryLib = !this.codeEntry.usesMemoryZero() ? null : this.memoryLib(0);
        this.check(bytecode.length, Integer.MAX_VALUE);
        int opcode = 0;
        block243: while (offset < this.bytecodeEndOffset) {
            opcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
            CompilerAsserts.partialEvaluationConstant((int)(++offset));
            switch (opcode) {
                case 0: {
                    this.enterErrorBranch();
                    throw WasmException.create(Failure.UNREACHABLE, this);
                }
                case 1: {
                    continue block243;
                }
                case 2: 
                case 3: 
                case 10: {
                    offset += opcode;
                    continue block243;
                }
                case 4: {
                    if (backEdgeCounter.count > 0) {
                        LoopNode.reportLoopCount((Node)this, (int)backEdgeCounter.count);
                    }
                    int resultCount = this.codeEntry.resultCount();
                    WasmFunctionNode.unwindStack(frame, stackPointer, localCount, resultCount);
                    WasmFunctionNode.dropStack(frame, stackPointer, localCount + resultCount);
                    if (this.notifyFunction != null) {
                        this.notifyFunction.notifyLine(frame, line, -1, line);
                    }
                    return WasmConstant.RETURN_VALUE;
                }
                case 5: {
                    int value = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    int stackSize = value & 0x3F;
                    int targetStackPointer = stackSize + localCount;
                    switch (value & 0xC0) {
                        case 128: {
                            WasmFrame.copyPrimitive(frame, stackPointer - 1, targetStackPointer);
                            WasmFunctionNode.dropStack(frame, stackPointer, targetStackPointer + 1);
                            stackPointer = targetStackPointer + 1;
                            continue block243;
                        }
                        case 192: {
                            WasmFrame.copyObject(frame, stackPointer - 1, targetStackPointer);
                            WasmFunctionNode.dropStack(frame, stackPointer, targetStackPointer + 1);
                            stackPointer = targetStackPointer + 1;
                            continue block243;
                        }
                    }
                    WasmFunctionNode.dropStack(frame, stackPointer, targetStackPointer);
                    stackPointer = targetStackPointer;
                    continue block243;
                }
                case 6: {
                    int value = BinaryStreamParser.rawPeekU16(bytecode, offset);
                    int stackSize = BinaryStreamParser.rawPeekU8(bytecode, offset + 1);
                    offset += 2;
                    int resultCount = value & 0x3F;
                    int resultType = value & 0xC0;
                    int targetStackPointer = stackSize + localCount;
                    switch (resultType) {
                        case 64: {
                            WasmFunctionNode.unwindPrimitiveStack(frame, stackPointer, targetStackPointer, resultCount);
                            break;
                        }
                        case 128: {
                            WasmFunctionNode.unwindObjectStack(frame, stackPointer, targetStackPointer, resultCount);
                            break;
                        }
                        case 192: {
                            WasmFunctionNode.unwindStack(frame, stackPointer, targetStackPointer, resultCount);
                        }
                    }
                    WasmFunctionNode.dropStack(frame, stackPointer, targetStackPointer + resultCount);
                    stackPointer = targetStackPointer + resultCount;
                    continue block243;
                }
                case 7: {
                    int resultType = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    int resultCount = BinaryStreamParser.rawPeekI32(bytecode, offset + 1);
                    int stackSize = BinaryStreamParser.rawPeekI32(bytecode, offset + 5);
                    offset += 9;
                    int targetStackPointer = stackSize + localCount;
                    switch (resultType) {
                        case 1: {
                            WasmFunctionNode.unwindPrimitiveStack(frame, stackPointer, targetStackPointer, resultCount);
                            break;
                        }
                        case 2: {
                            WasmFunctionNode.unwindObjectStack(frame, stackPointer, targetStackPointer, resultCount);
                            break;
                        }
                        case 3: {
                            WasmFunctionNode.unwindStack(frame, stackPointer, targetStackPointer, resultCount);
                        }
                    }
                    WasmFunctionNode.dropStack(frame, stackPointer, targetStackPointer + resultCount);
                    stackPointer = targetStackPointer + resultCount;
                    continue block243;
                }
                case 8: {
                    Object result;
                    if (CompilerDirectives.hasNextTier() && ++backEdgeCounter.count >= 256) {
                        LoopNode.reportLoopCount((Node)this, (int)256);
                        backEdgeCounter.count = 0;
                    }
                    if (!CompilerDirectives.inInterpreter() || !BytecodeOSRNode.pollOSRBackEdge((BytecodeOSRNode)this) || (result = BytecodeOSRNode.tryOSR((BytecodeOSRNode)this, (int)offset, (Object)new WasmOSRInterpreterState(stackPointer, line), null, (VirtualFrame)frame)) == null) continue block243;
                    if (backEdgeCounter.count > 0) {
                        LoopNode.reportLoopCount((Node)this, (int)backEdgeCounter.count);
                    }
                    return result;
                }
                case 9: {
                    if (WasmFunctionNode.profileCondition(bytecode, offset + 4, WasmFrame.popBoolean(frame, --stackPointer))) {
                        offset += 6;
                        continue block243;
                    }
                    int offsetDelta = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += offsetDelta;
                    continue block243;
                }
                case 11: {
                    int offsetDelta = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    offset -= offsetDelta;
                    continue block243;
                }
                case 12: {
                    int offsetDelta = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += offsetDelta;
                    continue block243;
                }
                case 13: {
                    if (WasmFunctionNode.profileCondition(bytecode, offset + 1, WasmFrame.popBoolean(frame, --stackPointer))) {
                        int offsetDelta = BinaryStreamParser.rawPeekU8(bytecode, offset);
                        offset -= offsetDelta;
                        continue block243;
                    }
                    offset += 3;
                    continue block243;
                }
                case 14: {
                    if (WasmFunctionNode.profileCondition(bytecode, offset + 4, WasmFrame.popBoolean(frame, --stackPointer))) {
                        int offsetDelta = BinaryStreamParser.rawPeekI32(bytecode, offset);
                        offset += offsetDelta;
                        continue block243;
                    }
                    offset += 6;
                    continue block243;
                }
                case 15: {
                    int offsetDelta;
                    int index = WasmFrame.popInt(frame, --stackPointer);
                    int size = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    int counterOffset = offset + 1;
                    if (CompilerDirectives.inInterpreter()) {
                        if (index < 0 || index >= size) {
                            index = size - 1;
                        }
                        int indexOffset = offset + 3 + index * 6;
                        WasmFunctionNode.updateBranchTableProfile(bytecode, counterOffset, indexOffset + 4);
                        int offsetDelta2 = BinaryStreamParser.rawPeekI32(bytecode, indexOffset);
                        offset = indexOffset + offsetDelta2;
                        continue block243;
                    }
                    for (int i = 0; i < size; ++i) {
                        int indexOffset = offset + 3 + i * 6;
                        if (!WasmFunctionNode.profileBranchTable(bytecode, counterOffset, indexOffset + 4, i == index || i == size - 1)) continue;
                        offsetDelta = BinaryStreamParser.rawPeekI32(bytecode, indexOffset);
                        offset = indexOffset + offsetDelta;
                        continue block243;
                    }
                    throw CompilerDirectives.shouldNotReachHere((String)"br_table");
                }
                case 16: {
                    int offsetDelta;
                    int index = WasmFrame.popInt(frame, --stackPointer);
                    int size = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    int counterOffset = offset + 4;
                    if (CompilerDirectives.inInterpreter()) {
                        if (index < 0 || index >= size) {
                            index = size - 1;
                        }
                        int indexOffset = offset + 6 + index * 6;
                        WasmFunctionNode.updateBranchTableProfile(bytecode, counterOffset, indexOffset + 4);
                        int offsetDelta3 = BinaryStreamParser.rawPeekI32(bytecode, indexOffset);
                        offset = indexOffset + offsetDelta3;
                        continue block243;
                    }
                    for (int i = 0; i < size; ++i) {
                        int indexOffset = offset + 6 + i * 6;
                        if (!WasmFunctionNode.profileBranchTable(bytecode, counterOffset, indexOffset + 4, i == index || i == size - 1)) continue;
                        offsetDelta = BinaryStreamParser.rawPeekI32(bytecode, indexOffset);
                        offset = indexOffset + offsetDelta;
                        continue block243;
                    }
                    throw CompilerDirectives.shouldNotReachHere((String)"br_table");
                }
                case 17: 
                case 18: {
                    int functionIndex;
                    int callNodeIndex;
                    if (opcode == 17) {
                        callNodeIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                        functionIndex = BinaryStreamParser.rawPeekU8(bytecode, offset + 1);
                        offset += 2;
                    } else {
                        callNodeIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                        functionIndex = BinaryStreamParser.rawPeekI32(bytecode, offset + 4);
                        offset += 8;
                    }
                    WasmFunction function = this.module.symbolTable().function(functionIndex);
                    int paramCount = function.paramCount();
                    Object[] args = this.createArgumentsForCall(frame, function.typeIndex(), paramCount, stackPointer);
                    stackPointer -= paramCount;
                    stackPointer = this.executeDirectCall(frame, stackPointer, instance, callNodeIndex, function, args);
                    CompilerAsserts.partialEvaluationConstant((int)stackPointer);
                    continue block243;
                }
                case 19: 
                case 20: {
                    Object prev;
                    TruffleContext truffleContext;
                    boolean enterContext;
                    boolean functionFromCurrentContext;
                    int profileOffset;
                    int tableIndex;
                    int expectedFunctionTypeIndex;
                    int callNodeIndex;
                    --stackPointer;
                    SymbolTable symtab = this.module.symbolTable();
                    if (opcode == 19) {
                        callNodeIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                        expectedFunctionTypeIndex = BinaryStreamParser.rawPeekU8(bytecode, offset + 1);
                        tableIndex = BinaryStreamParser.rawPeekU8(bytecode, offset + 2);
                        profileOffset = offset + 3;
                        offset += 5;
                    } else {
                        callNodeIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                        expectedFunctionTypeIndex = BinaryStreamParser.rawPeekI32(bytecode, offset + 4);
                        tableIndex = BinaryStreamParser.rawPeekI32(bytecode, offset + 8);
                        profileOffset = offset + 12;
                        offset += 14;
                    }
                    WasmTable table = context.tables().table(instance.tableAddress(tableIndex));
                    Object[] elements = table.elements();
                    int elementIndex = WasmFrame.popInt(frame, stackPointer);
                    if (elementIndex < 0 || elementIndex >= elements.length) {
                        this.enterErrorBranch();
                        throw WasmException.format(Failure.UNDEFINED_ELEMENT, (Node)this, "Element index '%d' out of table bounds.", elementIndex);
                    }
                    Object element = elements[elementIndex];
                    if (element == WasmConstant.NULL) {
                        this.enterErrorBranch();
                        throw WasmException.format(Failure.UNINITIALIZED_ELEMENT, (Node)this, "Table element at index %d is uninitialized.", elementIndex);
                    }
                    if (!(element instanceof WasmFunctionInstance)) {
                        this.enterErrorBranch();
                        throw WasmException.format(Failure.UNSPECIFIED_TRAP, (Node)this, "Unknown table element type: %s", element);
                    }
                    WasmFunctionInstance functionInstance = (WasmFunctionInstance)element;
                    WasmFunction function = functionInstance.function();
                    CallTarget target = functionInstance.target();
                    WasmContext functionInstanceContext = functionInstance.context();
                    int expectedTypeEquivalenceClass = symtab.equivalenceClass(expectedFunctionTypeIndex);
                    boolean bl = functionFromCurrentContext = functionInstanceContext == context;
                    if (WasmFunctionNode.profileCondition(bytecode, profileOffset, functionFromCurrentContext)) {
                        if (expectedTypeEquivalenceClass != function.typeEquivalenceClass()) {
                            this.enterErrorBranch();
                            this.failFunctionTypeCheck(function, expectedFunctionTypeIndex);
                        }
                    } else if (function != null && !function.type().equals(symtab.typeAt(expectedFunctionTypeIndex))) {
                        this.enterErrorBranch();
                        this.failFunctionTypeCheck(function, expectedFunctionTypeIndex);
                    }
                    int paramCount = this.module.symbolTable().functionTypeParamCount(expectedFunctionTypeIndex);
                    Object[] args = this.createArgumentsForCall(frame, expectedFunctionTypeIndex, paramCount, stackPointer);
                    stackPointer -= paramCount;
                    WasmArguments.setModuleInstance(args, functionInstance.moduleInstance());
                    boolean bl2 = enterContext = !functionFromCurrentContext;
                    if (enterContext) {
                        truffleContext = functionInstanceContext.environment().getContext();
                        prev = truffleContext.enter((Node)this);
                    } else {
                        truffleContext = null;
                        prev = null;
                    }
                    try {
                        Object result = this.executeIndirectCallNode(callNodeIndex, target, args);
                        WasmLanguage language = enterContext ? functionInstanceContext.language() : WasmLanguage.get(this);
                        stackPointer = this.pushIndirectCallResult(frame, stackPointer, expectedFunctionTypeIndex, result, language);
                        CompilerAsserts.partialEvaluationConstant((int)stackPointer);
                        continue block243;
                    }
                    finally {
                        if (!enterContext) continue block243;
                        truffleContext.leave((Node)this, prev);
                        continue block243;
                    }
                }
                case 21: {
                    WasmFrame.dropPrimitive(frame, --stackPointer);
                    continue block243;
                }
                case 22: {
                    WasmFrame.dropObject(frame, --stackPointer);
                    continue block243;
                }
                case 23: {
                    if (WasmFrame.popBoolean(frame, stackPointer - 1)) {
                        WasmFrame.drop(frame, stackPointer - 2);
                    } else {
                        WasmFrame.copyPrimitive(frame, stackPointer - 2, stackPointer - 3);
                        WasmFrame.dropPrimitive(frame, stackPointer - 2);
                    }
                    stackPointer -= 2;
                    continue block243;
                }
                case 24: {
                    if (WasmFrame.popBoolean(frame, stackPointer - 1)) {
                        WasmFrame.dropObject(frame, stackPointer - 2);
                    } else {
                        WasmFrame.copyObject(frame, stackPointer - 2, stackPointer - 3);
                        WasmFrame.dropObject(frame, stackPointer - 2);
                    }
                    stackPointer -= 2;
                    continue block243;
                }
                case 25: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    WasmFunctionNode.local_get(frame, stackPointer, index);
                    ++stackPointer;
                    continue block243;
                }
                case 26: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmFunctionNode.local_get(frame, stackPointer, index);
                    ++stackPointer;
                    continue block243;
                }
                case 27: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    WasmFunctionNode.local_get_obj(frame, stackPointer, index);
                    ++stackPointer;
                    continue block243;
                }
                case 28: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmFunctionNode.local_get_obj(frame, stackPointer, index);
                    ++stackPointer;
                    continue block243;
                }
                case 29: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    WasmFunctionNode.local_set(frame, --stackPointer, index);
                    continue block243;
                }
                case 30: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmFunctionNode.local_set(frame, --stackPointer, index);
                    continue block243;
                }
                case 31: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    WasmFunctionNode.local_set_obj(frame, --stackPointer, index);
                    continue block243;
                }
                case 32: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmFunctionNode.local_set_obj(frame, --stackPointer, index);
                    continue block243;
                }
                case 33: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    WasmFunctionNode.local_tee(frame, stackPointer - 1, index);
                    continue block243;
                }
                case 34: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmFunctionNode.local_tee(frame, stackPointer - 1, index);
                    continue block243;
                }
                case 35: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    WasmFunctionNode.local_tee_obj(frame, stackPointer - 1, index);
                    continue block243;
                }
                case 36: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmFunctionNode.local_tee_obj(frame, stackPointer - 1, index);
                    continue block243;
                }
                case 37: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    this.global_get(context, instance, frame, stackPointer, index);
                    ++stackPointer;
                    continue block243;
                }
                case 38: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    this.global_get(context, instance, frame, stackPointer, index);
                    ++stackPointer;
                    continue block243;
                }
                case 39: {
                    int index = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    this.global_set(context, instance, frame, --stackPointer, index);
                    continue block243;
                }
                case 40: {
                    int index = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    this.global_set(context, instance, frame, --stackPointer, index);
                    continue block243;
                }
                case 41: 
                case 44: 
                case 47: 
                case 50: 
                case 53: 
                case 56: 
                case 59: 
                case 62: 
                case 65: 
                case 68: 
                case 71: 
                case 74: 
                case 77: 
                case 80: {
                    long memOffset;
                    int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    int indexType64 = encoding & 0x80;
                    int offsetLength = encoding & 0xF;
                    int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, ++offset);
                    offset += 4;
                    switch (offsetLength) {
                        case 1: {
                            memOffset = BinaryStreamParser.rawPeekU8(bytecode, offset);
                            ++offset;
                            break;
                        }
                        case 4: {
                            memOffset = BinaryStreamParser.rawPeekU32(bytecode, offset);
                            offset += 4;
                            break;
                        }
                        case 8: {
                            memOffset = BinaryStreamParser.rawPeekI64(bytecode, offset);
                            offset += 8;
                            break;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    long baseAddress = indexType64 == 0 ? Integer.toUnsignedLong(WasmFrame.popInt(frame, stackPointer - 1)) : WasmFrame.popLong(frame, stackPointer - 1);
                    long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                    WasmMemory memory = this.memory(instance, memoryIndex);
                    this.load(memory, this.memoryLib(memoryIndex), frame, stackPointer - 1, opcode, address);
                    continue block243;
                }
                case 42: {
                    int memOffset = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    int baseAddress = WasmFrame.popInt(frame, stackPointer - 1);
                    long address = WasmFunctionNode.effectiveMemoryAddress(memOffset, baseAddress);
                    int value = zeroMemoryLib.load_i32(zeroMemory, this, address);
                    WasmFrame.pushInt(frame, stackPointer - 1, value);
                    continue block243;
                }
                case 43: {
                    int memOffset = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    int baseAddress = WasmFrame.popInt(frame, stackPointer - 1);
                    long address = WasmFunctionNode.effectiveMemoryAddress(memOffset, baseAddress);
                    int value = zeroMemoryLib.load_i32(zeroMemory, this, address);
                    WasmFrame.pushInt(frame, stackPointer - 1, value);
                    continue block243;
                }
                case 45: 
                case 48: 
                case 51: 
                case 54: 
                case 57: 
                case 60: 
                case 63: 
                case 66: 
                case 69: 
                case 72: 
                case 75: 
                case 78: 
                case 81: {
                    int memOffset = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    int baseAddress = WasmFrame.popInt(frame, stackPointer - 1);
                    long address = WasmFunctionNode.effectiveMemoryAddress(memOffset, baseAddress);
                    this.load(zeroMemory, zeroMemoryLib, frame, stackPointer - 1, opcode, address);
                    continue block243;
                }
                case 46: 
                case 49: 
                case 52: 
                case 55: 
                case 58: 
                case 61: 
                case 64: 
                case 67: 
                case 70: 
                case 73: 
                case 76: 
                case 79: 
                case 82: {
                    int memOffset = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    int baseAddress = WasmFrame.popInt(frame, stackPointer - 1);
                    long address = WasmFunctionNode.effectiveMemoryAddress(memOffset, baseAddress);
                    this.load(zeroMemory, zeroMemoryLib, frame, stackPointer - 1, opcode, address);
                    continue block243;
                }
                case 83: 
                case 86: 
                case 89: 
                case 92: 
                case 95: 
                case 98: 
                case 101: 
                case 104: 
                case 107: {
                    long memOffset;
                    int flags = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    int indexType64 = flags & 0x80;
                    int offsetEncoding = flags & 0xF;
                    int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, ++offset);
                    offset += 4;
                    switch (offsetEncoding) {
                        case 1: {
                            memOffset = BinaryStreamParser.rawPeekU8(bytecode, offset);
                            ++offset;
                            break;
                        }
                        case 4: {
                            memOffset = BinaryStreamParser.rawPeekU32(bytecode, offset);
                            offset += 4;
                            break;
                        }
                        case 8: {
                            memOffset = BinaryStreamParser.rawPeekI64(bytecode, offset);
                            offset += 8;
                            break;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    long baseAddress = indexType64 == 0 ? Integer.toUnsignedLong(WasmFrame.popInt(frame, stackPointer - 2)) : WasmFrame.popLong(frame, stackPointer - 2);
                    long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                    WasmMemory memory = this.memory(instance, memoryIndex);
                    this.store(memory, this.memoryLib(memoryIndex), frame, stackPointer - 1, opcode, address);
                    stackPointer -= 2;
                    continue block243;
                }
                case 84: {
                    int memOffset = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    int baseAddress = WasmFrame.popInt(frame, stackPointer - 2);
                    long address = WasmFunctionNode.effectiveMemoryAddress(memOffset, baseAddress);
                    int value = WasmFrame.popInt(frame, stackPointer - 1);
                    zeroMemoryLib.store_i32(zeroMemory, this, address, value);
                    stackPointer -= 2;
                    continue block243;
                }
                case 85: {
                    int memOffset = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    int baseAddress = WasmFrame.popInt(frame, stackPointer - 2);
                    long address = WasmFunctionNode.effectiveMemoryAddress(memOffset, baseAddress);
                    int value = WasmFrame.popInt(frame, stackPointer - 1);
                    zeroMemoryLib.store_i32(zeroMemory, this, address, value);
                    stackPointer -= 2;
                    continue block243;
                }
                case 87: 
                case 90: 
                case 93: 
                case 96: 
                case 99: 
                case 102: 
                case 105: 
                case 108: {
                    int memOffset = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    int baseAddress = WasmFrame.popInt(frame, stackPointer - 2);
                    long address = WasmFunctionNode.effectiveMemoryAddress(memOffset, baseAddress);
                    this.store(zeroMemory, zeroMemoryLib, frame, stackPointer - 1, opcode, address);
                    stackPointer -= 2;
                    continue block243;
                }
                case 88: 
                case 91: 
                case 94: 
                case 97: 
                case 100: 
                case 103: 
                case 106: 
                case 109: {
                    int memOffset = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    int baseAddress = WasmFrame.popInt(frame, stackPointer - 2);
                    long address = WasmFunctionNode.effectiveMemoryAddress(memOffset, baseAddress);
                    this.store(zeroMemory, zeroMemoryLib, frame, stackPointer - 1, opcode, address);
                    stackPointer -= 2;
                    continue block243;
                }
                case 110: {
                    int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmMemory memory = this.memory(instance, memoryIndex);
                    int pageSize = (int)this.memoryLib(memoryIndex).size(memory);
                    WasmFrame.pushInt(frame, stackPointer, pageSize);
                    ++stackPointer;
                    continue block243;
                }
                case 111: {
                    int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmMemory memory = this.memory(instance, memoryIndex);
                    int extraSize = WasmFrame.popInt(frame, stackPointer - 1);
                    int previousSize = (int)this.memoryLib(memoryIndex).grow(memory, extraSize);
                    WasmFrame.pushInt(frame, stackPointer - 1, previousSize);
                    continue block243;
                }
                case 112: {
                    byte value = BinaryStreamParser.rawPeekI8(bytecode, offset);
                    ++offset;
                    WasmFrame.pushInt(frame, stackPointer, value);
                    ++stackPointer;
                    continue block243;
                }
                case 113: {
                    int value = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    offset += 4;
                    WasmFrame.pushInt(frame, stackPointer, value);
                    ++stackPointer;
                    continue block243;
                }
                case 114: {
                    long value = BinaryStreamParser.rawPeekI8(bytecode, offset);
                    ++offset;
                    WasmFrame.pushLong(frame, stackPointer, value);
                    ++stackPointer;
                    continue block243;
                }
                case 115: {
                    long value = BinaryStreamParser.rawPeekI64(bytecode, offset);
                    offset += 8;
                    WasmFrame.pushLong(frame, stackPointer, value);
                    ++stackPointer;
                    continue block243;
                }
                case 118: {
                    WasmFunctionNode.i32_eqz(frame, stackPointer);
                    continue block243;
                }
                case 119: {
                    WasmFunctionNode.i32_eq(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 120: {
                    WasmFunctionNode.i32_ne(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 121: {
                    WasmFunctionNode.i32_lt_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 122: {
                    WasmFunctionNode.i32_lt_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 123: {
                    WasmFunctionNode.i32_gt_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 124: {
                    WasmFunctionNode.i32_gt_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 125: {
                    WasmFunctionNode.i32_le_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 126: {
                    WasmFunctionNode.i32_le_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 127: {
                    WasmFunctionNode.i32_ge_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 128: {
                    WasmFunctionNode.i32_ge_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 129: {
                    WasmFunctionNode.i64_eqz(frame, stackPointer);
                    continue block243;
                }
                case 130: {
                    WasmFunctionNode.i64_eq(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 131: {
                    WasmFunctionNode.i64_ne(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 132: {
                    WasmFunctionNode.i64_lt_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 133: {
                    WasmFunctionNode.i64_lt_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 134: {
                    WasmFunctionNode.i64_gt_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 135: {
                    WasmFunctionNode.i64_gt_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 136: {
                    WasmFunctionNode.i64_le_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 137: {
                    WasmFunctionNode.i64_le_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 138: {
                    WasmFunctionNode.i64_ge_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 139: {
                    WasmFunctionNode.i64_ge_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 140: {
                    WasmFunctionNode.f32_eq(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 141: {
                    WasmFunctionNode.f32_ne(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 142: {
                    WasmFunctionNode.f32_lt(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 143: {
                    WasmFunctionNode.f32_gt(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 144: {
                    WasmFunctionNode.f32_le(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 145: {
                    WasmFunctionNode.f32_ge(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 146: {
                    WasmFunctionNode.f64_eq(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 147: {
                    WasmFunctionNode.f64_ne(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 148: {
                    WasmFunctionNode.f64_lt(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 149: {
                    WasmFunctionNode.f64_gt(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 150: {
                    WasmFunctionNode.f64_le(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 151: {
                    WasmFunctionNode.f64_ge(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 152: {
                    WasmFunctionNode.i32_clz(frame, stackPointer);
                    continue block243;
                }
                case 153: {
                    WasmFunctionNode.i32_ctz(frame, stackPointer);
                    continue block243;
                }
                case 154: {
                    WasmFunctionNode.i32_popcnt(frame, stackPointer);
                    continue block243;
                }
                case 155: {
                    WasmFunctionNode.i32_add(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 156: {
                    WasmFunctionNode.i32_sub(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 157: {
                    WasmFunctionNode.i32_mul(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 158: {
                    this.i32_div_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 159: {
                    this.i32_div_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 160: {
                    this.i32_rem_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 161: {
                    this.i32_rem_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 162: {
                    WasmFunctionNode.i32_and(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 163: {
                    WasmFunctionNode.i32_or(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 164: {
                    WasmFunctionNode.i32_xor(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 165: {
                    WasmFunctionNode.i32_shl(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 166: {
                    WasmFunctionNode.i32_shr_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 167: {
                    WasmFunctionNode.i32_shr_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 168: {
                    WasmFunctionNode.i32_rotl(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 169: {
                    WasmFunctionNode.i32_rotr(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 170: {
                    WasmFunctionNode.i64_clz(frame, stackPointer);
                    continue block243;
                }
                case 171: {
                    WasmFunctionNode.i64_ctz(frame, stackPointer);
                    continue block243;
                }
                case 172: {
                    WasmFunctionNode.i64_popcnt(frame, stackPointer);
                    continue block243;
                }
                case 173: {
                    WasmFunctionNode.i64_add(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 174: {
                    WasmFunctionNode.i64_sub(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 175: {
                    WasmFunctionNode.i64_mul(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 176: {
                    this.i64_div_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 177: {
                    this.i64_div_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 178: {
                    this.i64_rem_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 179: {
                    this.i64_rem_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 180: {
                    WasmFunctionNode.i64_and(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 181: {
                    WasmFunctionNode.i64_or(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 182: {
                    WasmFunctionNode.i64_xor(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 183: {
                    WasmFunctionNode.i64_shl(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 184: {
                    WasmFunctionNode.i64_shr_s(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 185: {
                    WasmFunctionNode.i64_shr_u(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 186: {
                    WasmFunctionNode.i64_rotl(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 187: {
                    WasmFunctionNode.i64_rotr(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 116: {
                    float value = Float.intBitsToFloat(BinaryStreamParser.rawPeekI32(bytecode, offset));
                    offset += 4;
                    WasmFrame.pushFloat(frame, stackPointer, value);
                    ++stackPointer;
                    continue block243;
                }
                case 188: {
                    WasmFunctionNode.f32_abs(frame, stackPointer);
                    continue block243;
                }
                case 189: {
                    WasmFunctionNode.f32_neg(frame, stackPointer);
                    continue block243;
                }
                case 190: {
                    WasmFunctionNode.f32_ceil(frame, stackPointer);
                    continue block243;
                }
                case 191: {
                    WasmFunctionNode.f32_floor(frame, stackPointer);
                    continue block243;
                }
                case 192: {
                    WasmFunctionNode.f32_trunc(frame, stackPointer);
                    continue block243;
                }
                case 193: {
                    WasmFunctionNode.f32_nearest(frame, stackPointer);
                    continue block243;
                }
                case 194: {
                    WasmFunctionNode.f32_sqrt(frame, stackPointer);
                    continue block243;
                }
                case 195: {
                    WasmFunctionNode.f32_add(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 196: {
                    WasmFunctionNode.f32_sub(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 197: {
                    WasmFunctionNode.f32_mul(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 198: {
                    WasmFunctionNode.f32_div(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 199: {
                    WasmFunctionNode.f32_min(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 200: {
                    WasmFunctionNode.f32_max(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 201: {
                    WasmFunctionNode.f32_copysign(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 117: {
                    double value = Double.longBitsToDouble(BinaryStreamParser.rawPeekI64(bytecode, offset));
                    offset += 8;
                    WasmFrame.pushDouble(frame, stackPointer, value);
                    ++stackPointer;
                    continue block243;
                }
                case 202: {
                    WasmFunctionNode.f64_abs(frame, stackPointer);
                    continue block243;
                }
                case 203: {
                    WasmFunctionNode.f64_neg(frame, stackPointer);
                    continue block243;
                }
                case 204: {
                    WasmFunctionNode.f64_ceil(frame, stackPointer);
                    continue block243;
                }
                case 205: {
                    WasmFunctionNode.f64_floor(frame, stackPointer);
                    continue block243;
                }
                case 206: {
                    WasmFunctionNode.f64_trunc(frame, stackPointer);
                    continue block243;
                }
                case 207: {
                    WasmFunctionNode.f64_nearest(frame, stackPointer);
                    continue block243;
                }
                case 208: {
                    WasmFunctionNode.f64_sqrt(frame, stackPointer);
                    continue block243;
                }
                case 209: {
                    WasmFunctionNode.f64_add(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 210: {
                    WasmFunctionNode.f64_sub(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 211: {
                    WasmFunctionNode.f64_mul(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 212: {
                    WasmFunctionNode.f64_div(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 213: {
                    WasmFunctionNode.f64_min(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 214: {
                    WasmFunctionNode.f64_max(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 215: {
                    WasmFunctionNode.f64_copysign(frame, stackPointer);
                    --stackPointer;
                    continue block243;
                }
                case 216: {
                    WasmFunctionNode.i32_wrap_i64(frame, stackPointer);
                    continue block243;
                }
                case 217: {
                    this.i32_trunc_f32_s(frame, stackPointer);
                    continue block243;
                }
                case 218: {
                    this.i32_trunc_f32_u(frame, stackPointer);
                    continue block243;
                }
                case 219: {
                    this.i32_trunc_f64_s(frame, stackPointer);
                    continue block243;
                }
                case 220: {
                    this.i32_trunc_f64_u(frame, stackPointer);
                    continue block243;
                }
                case 221: {
                    WasmFunctionNode.i64_extend_i32_s(frame, stackPointer);
                    continue block243;
                }
                case 222: {
                    WasmFunctionNode.i64_extend_i32_u(frame, stackPointer);
                    continue block243;
                }
                case 223: {
                    this.i64_trunc_f32_s(frame, stackPointer);
                    continue block243;
                }
                case 224: {
                    this.i64_trunc_f32_u(frame, stackPointer);
                    continue block243;
                }
                case 225: {
                    this.i64_trunc_f64_s(frame, stackPointer);
                    continue block243;
                }
                case 226: {
                    this.i64_trunc_f64_u(frame, stackPointer);
                    continue block243;
                }
                case 227: {
                    WasmFunctionNode.f32_convert_i32_s(frame, stackPointer);
                    continue block243;
                }
                case 228: {
                    WasmFunctionNode.f32_convert_i32_u(frame, stackPointer);
                    continue block243;
                }
                case 229: {
                    WasmFunctionNode.f32_convert_i64_s(frame, stackPointer);
                    continue block243;
                }
                case 230: {
                    WasmFunctionNode.f32_convert_i64_u(frame, stackPointer);
                    continue block243;
                }
                case 231: {
                    WasmFunctionNode.f32_demote_f64(frame, stackPointer);
                    continue block243;
                }
                case 232: {
                    WasmFunctionNode.f64_convert_i32_s(frame, stackPointer);
                    continue block243;
                }
                case 233: {
                    WasmFunctionNode.f64_convert_i32_u(frame, stackPointer);
                    continue block243;
                }
                case 234: {
                    WasmFunctionNode.f64_convert_i64_s(frame, stackPointer);
                    continue block243;
                }
                case 235: {
                    WasmFunctionNode.f64_convert_i64_u(frame, stackPointer);
                    continue block243;
                }
                case 236: {
                    WasmFunctionNode.f64_promote_f32(frame, stackPointer);
                    continue block243;
                }
                case 237: {
                    WasmFunctionNode.i32_reinterpret_f32(frame, stackPointer);
                    continue block243;
                }
                case 238: {
                    WasmFunctionNode.i64_reinterpret_f64(frame, stackPointer);
                    continue block243;
                }
                case 239: {
                    WasmFunctionNode.f32_reinterpret_i32(frame, stackPointer);
                    continue block243;
                }
                case 240: {
                    WasmFunctionNode.f64_reinterpret_i64(frame, stackPointer);
                    continue block243;
                }
                case 241: {
                    WasmFunctionNode.i32_extend8_s(frame, stackPointer);
                    continue block243;
                }
                case 242: {
                    WasmFunctionNode.i32_extend16_s(frame, stackPointer);
                    continue block243;
                }
                case 243: {
                    WasmFunctionNode.i64_extend8_s(frame, stackPointer);
                    continue block243;
                }
                case 244: {
                    WasmFunctionNode.i64_extend16_s(frame, stackPointer);
                    continue block243;
                }
                case 245: {
                    WasmFunctionNode.i64_extend32_s(frame, stackPointer);
                    continue block243;
                }
                case 246: {
                    WasmFrame.pushReference(frame, stackPointer, WasmConstant.NULL);
                    ++stackPointer;
                    continue block243;
                }
                case 247: {
                    Object refType = WasmFrame.popReference(frame, stackPointer - 1);
                    WasmFrame.pushInt(frame, stackPointer - 1, refType == WasmConstant.NULL ? 1 : 0);
                    continue block243;
                }
                case 248: {
                    int functionIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    WasmFunction function = this.module.symbolTable().function(functionIndex);
                    WasmFunctionInstance functionInstance = instance.functionInstance(function);
                    WasmFrame.pushReference(frame, stackPointer, functionInstance);
                    ++stackPointer;
                    offset += 4;
                    continue block243;
                }
                case 249: {
                    int tableIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    this.table_get(context, instance, frame, stackPointer, tableIndex);
                    offset += 4;
                    continue block243;
                }
                case 250: {
                    int tableIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    this.table_set(context, instance, frame, stackPointer, tableIndex);
                    stackPointer -= 2;
                    offset += 4;
                    continue block243;
                }
                case 251: {
                    int miscOpcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    CompilerAsserts.partialEvaluationConstant((int)miscOpcode);
                    switch (miscOpcode) {
                        case 0: {
                            WasmFunctionNode.i32_trunc_sat_f32_s(frame, stackPointer);
                            continue block243;
                        }
                        case 1: {
                            WasmFunctionNode.i32_trunc_sat_f32_u(frame, stackPointer);
                            continue block243;
                        }
                        case 2: {
                            WasmFunctionNode.i32_trunc_sat_f64_s(frame, stackPointer);
                            continue block243;
                        }
                        case 3: {
                            WasmFunctionNode.i32_trunc_sat_f64_u(frame, stackPointer);
                            continue block243;
                        }
                        case 4: {
                            WasmFunctionNode.i64_trunc_sat_f32_s(frame, stackPointer);
                            continue block243;
                        }
                        case 5: {
                            WasmFunctionNode.i64_trunc_sat_f32_u(frame, stackPointer);
                            continue block243;
                        }
                        case 6: {
                            WasmFunctionNode.i64_trunc_sat_f64_s(frame, stackPointer);
                            continue block243;
                        }
                        case 7: {
                            WasmFunctionNode.i64_trunc_sat_f64_u(frame, stackPointer);
                            continue block243;
                        }
                        case 8: 
                        case 10: {
                            int dataIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, offset + 4);
                            this.executeMemoryInit(instance, frame, stackPointer, miscOpcode, memoryIndex, dataIndex);
                            stackPointer -= 3;
                            offset += 8;
                            continue block243;
                        }
                        case 12: {
                            int dataIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            WasmFunctionNode.data_drop(instance, dataIndex);
                            offset += 4;
                            continue block243;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            int destMemoryIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            int srcMemoryIndex = BinaryStreamParser.rawPeekI32(bytecode, offset + 4);
                            this.executeMemoryCopy(instance, frame, stackPointer, miscOpcode, destMemoryIndex, srcMemoryIndex);
                            stackPointer -= 3;
                            offset += 8;
                            continue block243;
                        }
                        case 18: 
                        case 19: {
                            int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            this.executeMemoryFill(instance, frame, stackPointer, miscOpcode, memoryIndex);
                            stackPointer -= 3;
                            offset += 4;
                            continue block243;
                        }
                        case 22: {
                            int elementIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            int tableIndex = BinaryStreamParser.rawPeekI32(bytecode, offset + 4);
                            int n = WasmFrame.popInt(frame, stackPointer - 1);
                            int src = WasmFrame.popInt(frame, stackPointer - 2);
                            int dst = WasmFrame.popInt(frame, stackPointer - 3);
                            this.table_init(context, instance, n, src, dst, tableIndex, elementIndex);
                            stackPointer -= 3;
                            offset += 8;
                            continue block243;
                        }
                        case 23: {
                            int elementIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            instance.dropElemInstance(elementIndex);
                            offset += 4;
                            continue block243;
                        }
                        case 24: {
                            int srcIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            int dstIndex = BinaryStreamParser.rawPeekI32(bytecode, offset + 4);
                            int n = WasmFrame.popInt(frame, stackPointer - 1);
                            int src = WasmFrame.popInt(frame, stackPointer - 2);
                            int dst = WasmFrame.popInt(frame, stackPointer - 3);
                            this.table_copy(context, instance, n, src, dst, srcIndex, dstIndex);
                            stackPointer -= 3;
                            offset += 8;
                            continue block243;
                        }
                        case 25: {
                            int tableIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            int n = WasmFrame.popInt(frame, stackPointer - 1);
                            Object val = WasmFrame.popReference(frame, stackPointer - 2);
                            int res = WasmFunctionNode.table_grow(context, instance, n, val, tableIndex);
                            WasmFrame.pushInt(frame, stackPointer - 2, res);
                            --stackPointer;
                            offset += 4;
                            continue block243;
                        }
                        case 26: {
                            int tableIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            WasmFunctionNode.table_size(context, instance, frame, stackPointer, tableIndex);
                            ++stackPointer;
                            offset += 4;
                            continue block243;
                        }
                        case 27: {
                            int tableIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            int n = WasmFrame.popInt(frame, stackPointer - 1);
                            Object val = WasmFrame.popReference(frame, stackPointer - 2);
                            int i = WasmFrame.popInt(frame, stackPointer - 3);
                            this.table_fill(context, instance, n, val, i, tableIndex);
                            stackPointer -= 3;
                            offset += 4;
                            continue block243;
                        }
                        case 20: {
                            int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            offset += 4;
                            WasmMemory memory = this.memory(instance, memoryIndex);
                            long pageSize = this.memoryLib(memoryIndex).size(memory);
                            WasmFrame.pushLong(frame, stackPointer, pageSize);
                            ++stackPointer;
                            continue block243;
                        }
                        case 21: {
                            int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, offset);
                            offset += 4;
                            WasmMemory memory = this.memory(instance, memoryIndex);
                            long extraSize = WasmFrame.popLong(frame, stackPointer - 1);
                            long previousSize = this.memoryLib(memoryIndex).grow(memory, extraSize);
                            WasmFrame.pushLong(frame, stackPointer - 1, previousSize);
                            continue block243;
                        }
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                case 252: {
                    long memOffset;
                    int atomicOpcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    CompilerAsserts.partialEvaluationConstant((int)atomicOpcode);
                    if (atomicOpcode == 63) continue block243;
                    int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    int indexType64 = encoding & 0x80;
                    int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, ++offset);
                    offset += 4;
                    if (indexType64 == 0) {
                        memOffset = BinaryStreamParser.rawPeekU32(bytecode, offset);
                        offset += 4;
                    } else {
                        memOffset = BinaryStreamParser.rawPeekI64(bytecode, offset);
                        offset += 8;
                    }
                    WasmMemory memory = this.memory(instance, memoryIndex);
                    int stackPointerDecrement = this.executeAtomic(frame, stackPointer, atomicOpcode, memory, this.memoryLib(memoryIndex), memOffset, indexType64);
                    stackPointer -= stackPointerDecrement;
                    continue block243;
                }
                case 253: {
                    int vectorOpcode = BinaryStreamParser.rawPeekU8(bytecode, offset);
                    ++offset;
                    CompilerAsserts.partialEvaluationConstant((int)vectorOpcode);
                    offset = this.executeVector(instance, frame, offset, stackPointer, vectorOpcode);
                    stackPointer += Vector128OpStackEffects.getVector128OpStackEffect(vectorOpcode);
                    continue block243;
                }
                case 254: {
                    int nextLine = BinaryStreamParser.rawPeekI32(bytecode, offset);
                    int sourceCodeLocation = BinaryStreamParser.rawPeekI32(bytecode, offset + 4);
                    offset += 8;
                    if (this.notifyFunction != null) {
                        this.notifyFunction.notifyLine(frame, line, nextLine, sourceCodeLocation);
                    }
                    line = nextLine;
                    continue block243;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        return WasmConstant.RETURN_VALUE;
    }

    @CompilerDirectives.TruffleBoundary
    private void failFunctionTypeCheck(WasmFunction function, int expectedFunctionTypeIndex) {
        throw WasmException.format(Failure.INDIRECT_CALL_TYPE__MISMATCH, (Node)this, "Actual (type %d of function %s) and expected (type %d in module %s) types differ in the indirect call.", function.typeIndex(), function.name(), expectedFunctionTypeIndex, this.module.name());
    }

    private void check(int v, int limit) {
        if (v >= limit) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, this, "array length too large");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeDirectCall(VirtualFrame frame, int stackPointer, WasmInstance instance, int callNodeIndex, WasmFunction function, Object[] args) {
        boolean imported = function.isImported();
        CompilerAsserts.partialEvaluationConstant((boolean)imported);
        Node callNode = this.callNodes[callNodeIndex];
        if (imported) {
            WasmIndirectCallNode indirectCallNode = (WasmIndirectCallNode)callNode;
            WasmFunctionInstance functionInstance = instance.functionInstance(function.index());
            TruffleContext truffleContext = functionInstance.getTruffleContext();
            WasmArguments.setModuleInstance(args, functionInstance.moduleInstance());
            Object prev = truffleContext.enter((Node)this);
            try {
                Object result = indirectCallNode.execute(instance.target(function.index()), args);
                int n = this.pushDirectCallResult(frame, stackPointer, function, result, functionInstance.context().language());
                return n;
            }
            finally {
                truffleContext.leave((Node)this, prev);
            }
        }
        WasmDirectCallNode directCallNode = (WasmDirectCallNode)callNode;
        WasmArguments.setModuleInstance(args, instance);
        if (!$assertionsDisabled && !this.assertDirectCall(instance, function, directCallNode.getTarget())) {
            throw new AssertionError();
        }
        Object result = directCallNode.execute(args);
        return this.pushDirectCallResult(frame, stackPointer, function, result, WasmLanguage.get(this));
    }

    private boolean assertDirectCall(WasmInstance instance, WasmFunction function, CallTarget target) {
        WasmFunctionInstance functionInstance = instance.functionInstance(function.index());
        if (functionInstance == null) {
            if (!$assertionsDisabled && function.isImported()) {
                throw new AssertionError();
            }
            return true;
        }
        if (!$assertionsDisabled && functionInstance.target() != target) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !function.isImported() && functionInstance.context() != WasmContext.get(this)) {
            throw new AssertionError();
        }
        return true;
    }

    private Object executeIndirectCallNode(int callNodeIndex, CallTarget target, Object[] args) {
        WasmIndirectCallNode callNode = (WasmIndirectCallNode)this.callNodes[callNodeIndex];
        return callNode.execute(target, args);
    }

    private static long effectiveMemoryAddress(int staticAddressOffset, int dynamicAddress) {
        return Integer.toUnsignedLong(dynamicAddress) + Integer.toUnsignedLong(staticAddressOffset);
    }

    private long effectiveMemoryAddress64(long staticAddressOffset, long dynamicAddress) {
        try {
            return Math.addExact(dynamicAddress, staticAddressOffset);
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.UNSPECIFIED_TRAP, "Memory address too large");
        }
    }

    private void load(WasmMemory memory, WasmMemoryLibrary memoryLib, VirtualFrame frame, int stackPointer, int opcode, long address) {
        switch (opcode) {
            case 41: 
            case 42: 
            case 43: {
                int value = memoryLib.load_i32(memory, this, address);
                WasmFrame.pushInt(frame, stackPointer, value);
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                long value = memoryLib.load_i64(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                float value = memoryLib.load_f32(memory, this, address);
                WasmFrame.pushFloat(frame, stackPointer, value);
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                double value = memoryLib.load_f64(memory, this, address);
                WasmFrame.pushDouble(frame, stackPointer, value);
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                int value = memoryLib.load_i32_8s(memory, this, address);
                WasmFrame.pushInt(frame, stackPointer, value);
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                int value = memoryLib.load_i32_8u(memory, this, address);
                WasmFrame.pushInt(frame, stackPointer, value);
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                int value = memoryLib.load_i32_16s(memory, this, address);
                WasmFrame.pushInt(frame, stackPointer, value);
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                int value = memoryLib.load_i32_16u(memory, this, address);
                WasmFrame.pushInt(frame, stackPointer, value);
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                long value = memoryLib.load_i64_8s(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                long value = memoryLib.load_i64_8u(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                long value = memoryLib.load_i64_16s(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                long value = memoryLib.load_i64_16u(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                long value = memoryLib.load_i64_32s(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                long value = memoryLib.load_i64_32u(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    private void store(WasmMemory memory, WasmMemoryLibrary memoryLib, VirtualFrame frame, int stackPointer, int opcode, long address) {
        switch (opcode) {
            case 83: 
            case 84: 
            case 85: {
                int value = WasmFrame.popInt(frame, stackPointer);
                memoryLib.store_i32(memory, this, address, value);
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                long value = WasmFrame.popLong(frame, stackPointer);
                memoryLib.store_i64(memory, this, address, value);
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                float value = WasmFrame.popFloat(frame, stackPointer);
                memoryLib.store_f32(memory, this, address, value);
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                double value = WasmFrame.popDouble(frame, stackPointer);
                memoryLib.store_f64(memory, this, address, value);
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                int value = WasmFrame.popInt(frame, stackPointer);
                memoryLib.store_i32_8(memory, this, address, (byte)value);
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                int value = WasmFrame.popInt(frame, stackPointer);
                memoryLib.store_i32_16(memory, this, address, (short)value);
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                long value = WasmFrame.popLong(frame, stackPointer);
                memoryLib.store_i64_8(memory, this, address, (byte)value);
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                long value = WasmFrame.popLong(frame, stackPointer);
                memoryLib.store_i64_16(memory, this, address, (short)value);
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                long value = WasmFrame.popLong(frame, stackPointer);
                memoryLib.store_i64_32(memory, this, address, (int)value);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    private void executeMemoryInit(WasmInstance instance, VirtualFrame frame, int stackPointer, int opcode, int memoryIndex, int dataIndex) {
        switch (opcode) {
            case 8: {
                int n = WasmFrame.popInt(frame, stackPointer - 1);
                int src = WasmFrame.popInt(frame, stackPointer - 2);
                long dst = WasmFrame.popInt(frame, stackPointer - 3);
                this.memory_init(instance, n, src, dst, dataIndex, memoryIndex);
                break;
            }
            case 10: {
                int n = WasmFrame.popInt(frame, stackPointer - 1);
                int src = WasmFrame.popInt(frame, stackPointer - 2);
                long dst = WasmFrame.popLong(frame, stackPointer - 3);
                this.memory_init(instance, n, src, dst, dataIndex, memoryIndex);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    private void executeMemoryCopy(WasmInstance instance, VirtualFrame frame, int stackPointer, int opcode, int destMemoryIndex, int srcMemoryIndex) {
        long src;
        long n;
        this.memory_copy(instance, n, src, switch (opcode) {
            case 14 -> {
                n = WasmFrame.popInt(frame, stackPointer - 1);
                src = WasmFrame.popInt(frame, stackPointer - 2);
                yield WasmFrame.popInt(frame, stackPointer - 3);
            }
            case 17 -> {
                n = WasmFrame.popLong(frame, stackPointer - 1);
                src = WasmFrame.popLong(frame, stackPointer - 2);
                yield WasmFrame.popLong(frame, stackPointer - 3);
            }
            case 16 -> {
                n = WasmFrame.popInt(frame, stackPointer - 1);
                src = WasmFrame.popInt(frame, stackPointer - 2);
                yield WasmFrame.popLong(frame, stackPointer - 3);
            }
            case 15 -> {
                n = WasmFrame.popInt(frame, stackPointer - 1);
                src = WasmFrame.popLong(frame, stackPointer - 2);
                yield WasmFrame.popInt(frame, stackPointer - 3);
            }
            default -> throw CompilerDirectives.shouldNotReachHere();
        }, destMemoryIndex, srcMemoryIndex);
    }

    private void executeMemoryFill(WasmInstance instance, VirtualFrame frame, int stackPointer, int opcode, int memoryIndex) {
        int val;
        long n;
        this.memory_fill(instance, n, val, switch (opcode) {
            case 18 -> {
                n = WasmFrame.popInt(frame, stackPointer - 1);
                val = WasmFrame.popInt(frame, stackPointer - 2);
                yield WasmFrame.popInt(frame, stackPointer - 3);
            }
            case 19 -> {
                n = WasmFrame.popLong(frame, stackPointer - 1);
                val = WasmFrame.popInt(frame, stackPointer - 2);
                yield WasmFrame.popLong(frame, stackPointer - 3);
            }
            default -> throw CompilerDirectives.shouldNotReachHere();
        }, memoryIndex);
    }

    private int executeAtomic(VirtualFrame frame, int stackPointer, int opcode, WasmMemory memory, WasmMemoryLibrary memoryLib, long memOffset, int indexType64) {
        switch (opcode) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 64: {
                long baseAddress = indexType64 == 0 ? (long)WasmFrame.popInt(frame, stackPointer - 2) : WasmFrame.popLong(frame, stackPointer - 2);
                long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                this.executeAtomicAtAddress(memory, memoryLib, frame, stackPointer - 1, opcode, address);
                return 1;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: {
                long baseAddress = indexType64 == 0 ? (long)WasmFrame.popInt(frame, stackPointer - 3) : WasmFrame.popLong(frame, stackPointer - 3);
                long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                this.executeAtomicAtAddress(memory, memoryLib, frame, stackPointer - 1, opcode, address);
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                long baseAddress = indexType64 == 0 ? (long)WasmFrame.popInt(frame, stackPointer - 1) : WasmFrame.popLong(frame, stackPointer - 1);
                long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                this.executeAtomicAtAddress(memory, memoryLib, frame, stackPointer - 1, opcode, address);
                return 0;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                long baseAddress = indexType64 == 0 ? (long)WasmFrame.popInt(frame, stackPointer - 2) : WasmFrame.popLong(frame, stackPointer - 2);
                long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                this.executeAtomicAtAddress(memory, memoryLib, frame, stackPointer - 1, opcode, address);
                return 2;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private void executeAtomicAtAddress(WasmMemory memory, WasmMemoryLibrary memoryLib, VirtualFrame frame, int stackPointer, int opcode, long address) {
        switch (opcode) {
            case 64: {
                int count = WasmFrame.popInt(frame, stackPointer);
                int waitersNotified = memoryLib.atomic_notify(memory, this, address, count);
                WasmFrame.pushInt(frame, stackPointer - 1, waitersNotified);
                break;
            }
            case 65: {
                long timeout = WasmFrame.popLong(frame, stackPointer);
                int expected = WasmFrame.popInt(frame, stackPointer - 1);
                int status = memoryLib.atomic_wait32(memory, this, address, expected, timeout);
                WasmFrame.pushInt(frame, stackPointer - 2, status);
                break;
            }
            case 66: {
                long timeout = WasmFrame.popLong(frame, stackPointer);
                long expected = WasmFrame.popLong(frame, stackPointer - 1);
                int status = memoryLib.atomic_wait64(memory, this, address, expected, timeout);
                WasmFrame.pushInt(frame, stackPointer - 2, status);
                break;
            }
            case 0: {
                int value = memoryLib.atomic_load_i32(memory, this, address);
                WasmFrame.pushInt(frame, stackPointer, value);
                break;
            }
            case 1: {
                long value = memoryLib.atomic_load_i64(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 2: {
                int value = memoryLib.atomic_load_i32_8u(memory, this, address);
                WasmFrame.pushInt(frame, stackPointer, value);
                break;
            }
            case 3: {
                int value = memoryLib.atomic_load_i32_16u(memory, this, address);
                WasmFrame.pushInt(frame, stackPointer, value);
                break;
            }
            case 4: {
                long value = memoryLib.atomic_load_i64_8u(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 5: {
                long value = memoryLib.atomic_load_i64_16u(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 6: {
                long value = memoryLib.atomic_load_i64_32u(memory, this, address);
                WasmFrame.pushLong(frame, stackPointer, value);
                break;
            }
            case 7: {
                int value = WasmFrame.popInt(frame, stackPointer);
                memoryLib.atomic_store_i32(memory, this, address, value);
                break;
            }
            case 8: {
                long value = WasmFrame.popLong(frame, stackPointer);
                memoryLib.atomic_store_i64(memory, this, address, value);
                break;
            }
            case 9: {
                int value = WasmFrame.popInt(frame, stackPointer);
                memoryLib.atomic_store_i32_8(memory, this, address, (byte)value);
                break;
            }
            case 10: {
                int value = WasmFrame.popInt(frame, stackPointer);
                memoryLib.atomic_store_i32_16(memory, this, address, (short)value);
                break;
            }
            case 11: {
                long value = WasmFrame.popLong(frame, stackPointer);
                memoryLib.atomic_store_i64_8(memory, this, address, (byte)value);
                break;
            }
            case 12: {
                long value = WasmFrame.popLong(frame, stackPointer);
                memoryLib.atomic_store_i64_16(memory, this, address, (short)value);
                break;
            }
            case 13: {
                long value = WasmFrame.popLong(frame, stackPointer);
                memoryLib.atomic_store_i64_32(memory, this, address, (int)value);
                break;
            }
            case 14: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_add_i32(memory, this, address, value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 15: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_add_i64(memory, this, address, value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 16: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_add_i32_8u(memory, this, address, (byte)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 17: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_add_i32_16u(memory, this, address, (short)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 18: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_add_i64_8u(memory, this, address, (byte)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 19: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_add_i64_16u(memory, this, address, (short)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 20: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_add_i64_32u(memory, this, address, (int)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 21: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_sub_i32(memory, this, address, value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 22: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_sub_i64(memory, this, address, value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 23: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_sub_i32_8u(memory, this, address, (byte)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 24: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_sub_i32_16u(memory, this, address, (short)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 25: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_sub_i64_8u(memory, this, address, (byte)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 26: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_sub_i64_16u(memory, this, address, (short)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 27: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_sub_i64_32u(memory, this, address, (int)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 28: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_and_i32(memory, this, address, value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 29: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_and_i64(memory, this, address, value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 30: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_and_i32_8u(memory, this, address, (byte)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 31: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_and_i32_16u(memory, this, address, (short)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 32: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_and_i64_8u(memory, this, address, (byte)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 33: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_and_i64_16u(memory, this, address, (short)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 34: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_and_i64_32u(memory, this, address, (int)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 35: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_or_i32(memory, this, address, value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 36: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_or_i64(memory, this, address, value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 37: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_or_i32_8u(memory, this, address, (byte)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 38: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_or_i32_16u(memory, this, address, (short)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 39: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_or_i64_8u(memory, this, address, (byte)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 40: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_or_i64_16u(memory, this, address, (short)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 41: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_or_i64_32u(memory, this, address, (int)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 42: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_xor_i32(memory, this, address, value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 43: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_xor_i64(memory, this, address, value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 44: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_xor_i32_8u(memory, this, address, (byte)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 45: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_xor_i32_16u(memory, this, address, (short)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 46: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_xor_i64_8u(memory, this, address, (byte)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 47: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_xor_i64_16u(memory, this, address, (short)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 48: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_xor_i64_32u(memory, this, address, (int)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 49: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_xchg_i32(memory, this, address, value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 50: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_xchg_i64(memory, this, address, value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 51: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_xchg_i32_8u(memory, this, address, (byte)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 52: {
                int value = WasmFrame.popInt(frame, stackPointer);
                int result = memoryLib.atomic_rmw_xchg_i32_16u(memory, this, address, (short)value);
                WasmFrame.pushInt(frame, stackPointer - 1, result);
                break;
            }
            case 53: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_xchg_i64_8u(memory, this, address, (byte)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 54: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_xchg_i64_16u(memory, this, address, (short)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 55: {
                long value = WasmFrame.popLong(frame, stackPointer);
                long result = memoryLib.atomic_rmw_xchg_i64_32u(memory, this, address, (int)value);
                WasmFrame.pushLong(frame, stackPointer - 1, result);
                break;
            }
            case 56: {
                int replacement = WasmFrame.popInt(frame, stackPointer);
                int expected = WasmFrame.popInt(frame, stackPointer - 1);
                int result = memoryLib.atomic_rmw_cmpxchg_i32(memory, this, address, expected, replacement);
                WasmFrame.pushInt(frame, stackPointer - 2, result);
                break;
            }
            case 57: {
                long replacement = WasmFrame.popLong(frame, stackPointer);
                long expected = WasmFrame.popLong(frame, stackPointer - 1);
                long result = memoryLib.atomic_rmw_cmpxchg_i64(memory, this, address, expected, replacement);
                WasmFrame.pushLong(frame, stackPointer - 2, result);
                break;
            }
            case 58: {
                int replacement = WasmFrame.popInt(frame, stackPointer);
                int expected = WasmFrame.popInt(frame, stackPointer - 1);
                int result = memoryLib.atomic_rmw_cmpxchg_i32_8u(memory, this, address, (byte)expected, (byte)replacement);
                WasmFrame.pushInt(frame, stackPointer - 2, result);
                break;
            }
            case 59: {
                int replacement = WasmFrame.popInt(frame, stackPointer);
                int expected = WasmFrame.popInt(frame, stackPointer - 1);
                int result = memoryLib.atomic_rmw_cmpxchg_i32_16u(memory, this, address, (short)expected, (short)replacement);
                WasmFrame.pushInt(frame, stackPointer - 2, result);
                break;
            }
            case 60: {
                long replacement = WasmFrame.popLong(frame, stackPointer);
                long expected = WasmFrame.popLong(frame, stackPointer - 1);
                long result = memoryLib.atomic_rmw_cmpxchg_i64_8u(memory, this, address, (byte)expected, (byte)replacement);
                WasmFrame.pushLong(frame, stackPointer - 2, result);
                break;
            }
            case 61: {
                long replacement = WasmFrame.popLong(frame, stackPointer);
                long expected = WasmFrame.popLong(frame, stackPointer - 1);
                long result = memoryLib.atomic_rmw_cmpxchg_i64_16u(memory, this, address, (short)expected, (short)replacement);
                WasmFrame.pushLong(frame, stackPointer - 2, result);
                break;
            }
            case 62: {
                long replacement = WasmFrame.popLong(frame, stackPointer);
                long expected = WasmFrame.popLong(frame, stackPointer - 1);
                long result = memoryLib.atomic_rmw_cmpxchg_i64_32u(memory, this, address, (int)expected, (int)replacement);
                WasmFrame.pushLong(frame, stackPointer - 2, result);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    private int executeVector(WasmInstance instance, VirtualFrame frame, int startingOffset, int startingStackPointer, int vectorOpcode) {
        byte[] bytecode = this.bytecode;
        int offset = startingOffset;
        int stackPointer = startingStackPointer;
        switch (vectorOpcode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 92: 
            case 93: {
                long memOffset;
                int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                int indexType64 = encoding & 0x80;
                int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, ++offset);
                offset += 4;
                if (indexType64 == 0) {
                    memOffset = BinaryStreamParser.rawPeekU32(bytecode, offset);
                    offset += 4;
                } else {
                    memOffset = BinaryStreamParser.rawPeekI64(bytecode, offset);
                    offset += 8;
                }
                long baseAddress = indexType64 == 0 ? Integer.toUnsignedLong(WasmFrame.popInt(frame, --stackPointer)) : WasmFrame.popLong(frame, --stackPointer);
                long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                WasmMemory memory = this.memory(instance, memoryIndex);
                this.loadVector(memory, this.memoryLib(memoryIndex), frame, stackPointer++, vectorOpcode, address);
                break;
            }
            case 11: {
                long memOffset;
                int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                int indexType64 = encoding & 0x80;
                int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, ++offset);
                offset += 4;
                if (indexType64 == 0) {
                    memOffset = BinaryStreamParser.rawPeekU32(bytecode, offset);
                    offset += 4;
                } else {
                    memOffset = BinaryStreamParser.rawPeekI64(bytecode, offset);
                    offset += 8;
                }
                Vector128 value = WasmFrame.popVector128(frame, --stackPointer);
                long baseAddress = indexType64 == 0 ? Integer.toUnsignedLong(WasmFrame.popInt(frame, --stackPointer)) : WasmFrame.popLong(frame, --stackPointer);
                long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                WasmMemory memory = this.memory(instance, memoryIndex);
                this.storeVector(memory, this.memoryLib(memoryIndex), address, value);
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                long memOffset;
                int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                int indexType64 = encoding & 0x80;
                int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, ++offset);
                offset += 4;
                if (indexType64 == 0) {
                    memOffset = BinaryStreamParser.rawPeekU32(bytecode, offset);
                    offset += 4;
                } else {
                    memOffset = BinaryStreamParser.rawPeekI64(bytecode, offset);
                    offset += 8;
                }
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                long baseAddress = indexType64 == 0 ? Integer.toUnsignedLong(WasmFrame.popInt(frame, --stackPointer)) : WasmFrame.popLong(frame, --stackPointer);
                long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                WasmMemory memory = this.memory(instance, memoryIndex);
                this.loadVectorLane(memory, this.memoryLib(memoryIndex), frame, stackPointer++, vectorOpcode, address, laneIndex, vec);
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                long memOffset;
                int encoding = BinaryStreamParser.rawPeekU8(bytecode, offset);
                int indexType64 = encoding & 0x80;
                int memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, ++offset);
                offset += 4;
                if (indexType64 == 0) {
                    memOffset = BinaryStreamParser.rawPeekU32(bytecode, offset);
                    offset += 4;
                } else {
                    memOffset = BinaryStreamParser.rawPeekI64(bytecode, offset);
                    offset += 8;
                }
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                long baseAddress = indexType64 == 0 ? Integer.toUnsignedLong(WasmFrame.popInt(frame, --stackPointer)) : WasmFrame.popLong(frame, --stackPointer);
                long address = this.effectiveMemoryAddress64(memOffset, baseAddress);
                WasmMemory memory = this.memory(instance, memoryIndex);
                this.storeVectorLane(memory, this.memoryLib(memoryIndex), vectorOpcode, address, laneIndex, vec);
                break;
            }
            case 12: {
                Vector128 value = new Vector128(Vector128Ops.v128_const(BinaryStreamParser.rawPeekI128(bytecode, offset)));
                offset += 16;
                WasmFrame.pushVector128(frame, stackPointer++, value);
                break;
            }
            case 13: {
                byte[] indices = BinaryStreamParser.rawPeekI128(bytecode, offset);
                offset += 16;
                Vector128 y = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 x = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i8x16_shuffle(x.getBytes(), y.getBytes(), indices));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 21: 
            case 22: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                int result = Vector128Ops.i8x16_extract_lane(vec.getBytes(), laneIndex, vectorOpcode);
                WasmFrame.pushInt(frame, stackPointer++, result);
                break;
            }
            case 23: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                byte value = (byte)WasmFrame.popInt(frame, --stackPointer);
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i8x16_replace_lane(vec.getBytes(), laneIndex, value));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 24: 
            case 25: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                int result = Vector128Ops.i16x8_extract_lane(vec.getBytes(), laneIndex, vectorOpcode);
                WasmFrame.pushInt(frame, stackPointer++, result);
                break;
            }
            case 26: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                short value = (short)WasmFrame.popInt(frame, --stackPointer);
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i16x8_replace_lane(vec.getBytes(), laneIndex, value));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 27: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                int result = Vector128Ops.i32x4_extract_lane(vec.getBytes(), laneIndex);
                WasmFrame.pushInt(frame, stackPointer++, result);
                break;
            }
            case 28: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                int value = WasmFrame.popInt(frame, --stackPointer);
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i32x4_replace_lane(vec.getBytes(), laneIndex, value));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 29: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                long result = Vector128Ops.i64x2_extract_lane(vec.getBytes(), laneIndex);
                WasmFrame.pushLong(frame, stackPointer++, result);
                break;
            }
            case 30: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                long value = WasmFrame.popLong(frame, --stackPointer);
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i64x2_replace_lane(vec.getBytes(), laneIndex, value));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 31: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                float result = Vector128Ops.f32x4_extract_lane(vec.getBytes(), laneIndex);
                WasmFrame.pushFloat(frame, stackPointer++, result);
                break;
            }
            case 32: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                float value = WasmFrame.popFloat(frame, --stackPointer);
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.f32x4_replace_lane(vec.getBytes(), laneIndex, value));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 33: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                double result = Vector128Ops.f64x2_extract_lane(vec.getBytes(), laneIndex);
                WasmFrame.pushDouble(frame, stackPointer++, result);
                break;
            }
            case 34: {
                int laneIndex = BinaryStreamParser.rawPeekU8(bytecode, offset);
                ++offset;
                double value = WasmFrame.popDouble(frame, --stackPointer);
                Vector128 vec = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.f64x2_replace_lane(vec.getBytes(), laneIndex, value));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 77: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 116: 
            case 117: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 148: 
            case 160: 
            case 161: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 192: 
            case 193: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 224: 
            case 225: 
            case 227: 
            case 236: 
            case 237: 
            case 239: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                Vector128 x = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.unary(x.getBytes(), vectorOpcode));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 14: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 101: 
            case 102: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 130: 
            case 133: 
            case 134: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 206: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 226: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 238: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: {
                Vector128 y = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 x = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.binary(x.getBytes(), y.getBytes(), vectorOpcode));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 82: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 194: 
            case 207: 
            case 208: 
            case 210: 
            case 211: {
                Vector128 z = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 y = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 x = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.ternary(x.getBytes(), y.getBytes(), z.getBytes(), vectorOpcode));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 83: 
            case 99: 
            case 100: 
            case 131: 
            case 132: 
            case 163: 
            case 164: 
            case 195: 
            case 196: {
                Vector128 x = WasmFrame.popVector128(frame, --stackPointer);
                int result = Vector128Ops.vectorToInt(x.getBytes(), vectorOpcode);
                WasmFrame.pushInt(frame, stackPointer++, result);
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 139: 
            case 140: 
            case 141: 
            case 171: 
            case 172: 
            case 173: 
            case 203: 
            case 204: 
            case 205: {
                int shift = WasmFrame.popInt(frame, --stackPointer);
                Vector128 x = WasmFrame.popVector128(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.shift(x.getBytes(), shift, vectorOpcode));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 15: {
                int x = WasmFrame.popInt(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i8x16_splat((byte)x));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 16: {
                int x = WasmFrame.popInt(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i16x8_splat((short)x));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 17: {
                int x = WasmFrame.popInt(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i32x4_splat(x));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 18: {
                long x = WasmFrame.popLong(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.i64x2_splat(x));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 19: {
                float x = WasmFrame.popFloat(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.f32x4_splat(x));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            case 20: {
                double x = WasmFrame.popDouble(frame, --stackPointer);
                Vector128 result = new Vector128(Vector128Ops.f64x2_splat(x));
                WasmFrame.pushVector128(frame, stackPointer++, result);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        if (!$assertionsDisabled && stackPointer - startingStackPointer != Vector128OpStackEffects.getVector128OpStackEffect(vectorOpcode)) {
            throw new AssertionError();
        }
        return offset;
    }

    private void loadVector(WasmMemory memory, WasmMemoryLibrary memoryLib, VirtualFrame frame, int stackPointer, int vectorOpcode, long address) {
        switch (vectorOpcode) {
            case 0: {
                Vector128 value = memoryLib.load_i128(memory, this, address);
                WasmFrame.pushVector128(frame, stackPointer, value);
                break;
            }
            case 1: 
            case 2: {
                long value = memoryLib.load_i64(memory, this, address);
                byte[] bytes = new byte[8];
                CompilerDirectives.ensureVirtualized((Object)bytes);
                ByteArraySupport.littleEndian().putLong(bytes, 0, value);
                byte[] resultBytes = new byte[16];
                for (int i = 0; i < 8; ++i) {
                    byte x = bytes[i];
                    short result = switch (vectorOpcode) {
                        case 1 -> x;
                        case 2 -> (short)Byte.toUnsignedInt(x);
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    };
                    ByteArraySupport.littleEndian().putShort(resultBytes, i * 2, result);
                }
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            case 3: 
            case 4: {
                long value = memoryLib.load_i64(memory, this, address);
                byte[] bytes = new byte[8];
                CompilerDirectives.ensureVirtualized((Object)bytes);
                ByteArraySupport.littleEndian().putLong(bytes, 0, value);
                byte[] resultBytes = new byte[16];
                for (int i = 0; i < 4; ++i) {
                    int x = ByteArraySupport.littleEndian().getShort(bytes, i * 2);
                    int result = switch (vectorOpcode) {
                        case 3 -> x;
                        case 4 -> Short.toUnsignedInt((short)x);
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    };
                    ByteArraySupport.littleEndian().putInt(resultBytes, i * 4, result);
                }
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            case 5: 
            case 6: {
                long value = memoryLib.load_i64(memory, this, address);
                byte[] bytes = new byte[8];
                CompilerDirectives.ensureVirtualized((Object)bytes);
                ByteArraySupport.littleEndian().putLong(bytes, 0, value);
                byte[] resultBytes = new byte[16];
                for (int i = 0; i < 2; ++i) {
                    int x = ByteArraySupport.littleEndian().getInt(bytes, i * 4);
                    long result = switch (vectorOpcode) {
                        case 5 -> x;
                        case 6 -> Integer.toUnsignedLong(x);
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    };
                    ByteArraySupport.littleEndian().putLong(resultBytes, i * 8, result);
                }
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            case 7: {
                byte value = (byte)memoryLib.load_i32_8s(memory, this, address);
                byte[] resultBytes = new byte[16];
                Arrays.fill(resultBytes, value);
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            case 8: {
                short value = (short)memoryLib.load_i32_16s(memory, this, address);
                byte[] resultBytes = new byte[16];
                for (int i = 0; i < 8; ++i) {
                    ByteArraySupport.littleEndian().putShort(resultBytes, i * 2, value);
                }
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            case 9: {
                int value = memoryLib.load_i32(memory, this, address);
                byte[] resultBytes = new byte[16];
                for (int i = 0; i < 4; ++i) {
                    ByteArraySupport.littleEndian().putInt(resultBytes, i * 4, value);
                }
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            case 10: {
                long value = memoryLib.load_i64(memory, this, address);
                byte[] resultBytes = new byte[16];
                for (int i = 0; i < 2; ++i) {
                    ByteArraySupport.littleEndian().putLong(resultBytes, i * 8, value);
                }
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            case 92: {
                int value = memoryLib.load_i32(memory, this, address);
                byte[] resultBytes = new byte[16];
                ByteArraySupport.littleEndian().putInt(resultBytes, 0, value);
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            case 93: {
                long value = memoryLib.load_i64(memory, this, address);
                byte[] resultBytes = new byte[16];
                ByteArraySupport.littleEndian().putLong(resultBytes, 0, value);
                Vector128 vec = new Vector128(resultBytes);
                WasmFrame.pushVector128(frame, stackPointer, vec);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    private void storeVector(WasmMemory memory, WasmMemoryLibrary memoryLib, long address, Vector128 value) {
        memoryLib.store_i128(memory, this, address, value);
    }

    private void loadVectorLane(WasmMemory memory, WasmMemoryLibrary memoryLib, VirtualFrame frame, int stackPointer, int vectorOpcode, long address, int laneIndex, Vector128 vec) {
        switch (vectorOpcode) {
            case 84: {
                byte value = (byte)memoryLib.load_i32_8s(memory, this, address);
                byte[] resultBytes = Arrays.copyOf(vec.getBytes(), 16);
                resultBytes[laneIndex] = value;
                WasmFrame.pushVector128(frame, stackPointer, new Vector128(resultBytes));
                break;
            }
            case 85: {
                short value = (short)memoryLib.load_i32_16s(memory, this, address);
                byte[] resultBytes = Arrays.copyOf(vec.getBytes(), 16);
                ByteArraySupport.littleEndian().putShort(resultBytes, laneIndex * 2, value);
                WasmFrame.pushVector128(frame, stackPointer, new Vector128(resultBytes));
                break;
            }
            case 86: {
                int value = memoryLib.load_i32(memory, this, address);
                byte[] resultBytes = Arrays.copyOf(vec.getBytes(), 16);
                ByteArraySupport.littleEndian().putInt(resultBytes, laneIndex * 4, value);
                WasmFrame.pushVector128(frame, stackPointer, new Vector128(resultBytes));
                break;
            }
            case 87: {
                long value = memoryLib.load_i64(memory, this, address);
                byte[] resultBytes = Arrays.copyOf(vec.getBytes(), 16);
                ByteArraySupport.littleEndian().putLong(resultBytes, laneIndex * 8, value);
                WasmFrame.pushVector128(frame, stackPointer, new Vector128(resultBytes));
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    private void storeVectorLane(WasmMemory memory, WasmMemoryLibrary memoryLib, int vectorOpcode, long address, int laneIndex, Vector128 vec) {
        switch (vectorOpcode) {
            case 88: {
                byte value = vec.getBytes()[laneIndex];
                memoryLib.store_i32_8(memory, this, address, value);
                break;
            }
            case 89: {
                short value = ByteArraySupport.littleEndian().getShort(vec.getBytes(), laneIndex * 2);
                memoryLib.store_i32_16(memory, this, address, value);
                break;
            }
            case 90: {
                int value = ByteArraySupport.littleEndian().getInt(vec.getBytes(), laneIndex * 4);
                memoryLib.store_i32(memory, this, address, value);
                break;
            }
            case 91: {
                long value = ByteArraySupport.littleEndian().getLong(vec.getBytes(), laneIndex * 8);
                memoryLib.store_i64(memory, this, address, value);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    private void global_set(WasmContext context, WasmInstance instance, VirtualFrame frame, int stackPointer, int index) {
        byte type = this.module.symbolTable().globalValueType(index);
        CompilerAsserts.partialEvaluationConstant((int)type);
        switch (type) {
            case 127: {
                context.globals().storeInt(instance.globalAddress(index), WasmFrame.popInt(frame, stackPointer));
                break;
            }
            case 125: {
                context.globals().storeInt(instance.globalAddress(index), Float.floatToRawIntBits(WasmFrame.popFloat(frame, stackPointer)));
                break;
            }
            case 126: {
                context.globals().storeLong(instance.globalAddress(index), WasmFrame.popLong(frame, stackPointer));
                break;
            }
            case 124: {
                context.globals().storeLong(instance.globalAddress(index), Double.doubleToRawLongBits(WasmFrame.popDouble(frame, stackPointer)));
                break;
            }
            case 123: {
                context.globals().storeVector128(instance.globalAddress(index), WasmFrame.popVector128(frame, stackPointer));
                break;
            }
            case 111: 
            case 112: {
                context.globals().storeReference(instance.globalAddress(index), WasmFrame.popReference(frame, stackPointer));
                break;
            }
            default: {
                throw WasmException.create(Failure.UNSPECIFIED_TRAP, this, "Local variable cannot have the void type.");
            }
        }
    }

    private void global_get(WasmContext context, WasmInstance instance, VirtualFrame frame, int stackPointer, int index) {
        byte type = this.module.symbolTable().globalValueType(index);
        CompilerAsserts.partialEvaluationConstant((int)type);
        switch (type) {
            case 127: {
                WasmFrame.pushInt(frame, stackPointer, context.globals().loadAsInt(instance.globalAddress(index)));
                break;
            }
            case 125: {
                WasmFrame.pushFloat(frame, stackPointer, Float.intBitsToFloat(context.globals().loadAsInt(instance.globalAddress(index))));
                break;
            }
            case 126: {
                WasmFrame.pushLong(frame, stackPointer, context.globals().loadAsLong(instance.globalAddress(index)));
                break;
            }
            case 124: {
                WasmFrame.pushDouble(frame, stackPointer, Double.longBitsToDouble(context.globals().loadAsLong(instance.globalAddress(index))));
                break;
            }
            case 123: {
                WasmFrame.pushVector128(frame, stackPointer, context.globals().loadAsVector128(instance.globalAddress(index)));
                break;
            }
            case 111: 
            case 112: {
                WasmFrame.pushReference(frame, stackPointer, context.globals().loadAsReference(instance.globalAddress(index)));
                break;
            }
            default: {
                throw WasmException.create(Failure.UNSPECIFIED_TRAP, this, "Local variable cannot have the void type.");
            }
        }
    }

    private static void local_tee(VirtualFrame frame, int stackPointer, int index) {
        WasmFrame.copyPrimitive(frame, stackPointer, index);
    }

    private static void local_tee_obj(VirtualFrame frame, int stackPointer, int index) {
        WasmFrame.copyObject(frame, stackPointer, index);
    }

    private static void local_set(VirtualFrame frame, int stackPointer, int index) {
        WasmFrame.copyPrimitive(frame, stackPointer, index);
        if (CompilerDirectives.inCompiledCode()) {
            WasmFrame.dropPrimitive(frame, stackPointer);
        }
    }

    private static void local_set_obj(VirtualFrame frame, int stackPointer, int index) {
        WasmFrame.copyObject(frame, stackPointer, index);
        if (CompilerDirectives.inCompiledCode()) {
            WasmFrame.dropObject(frame, stackPointer);
        }
    }

    private static void local_get(VirtualFrame frame, int stackPointer, int index) {
        WasmFrame.copyPrimitive(frame, index, stackPointer);
    }

    private static void local_get_obj(VirtualFrame frame, int stackPointer, int index) {
        WasmFrame.copyObject(frame, index, stackPointer);
    }

    private static void i32_eqz(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        WasmFrame.pushInt(frame, stackPointer - 1, x == 0 ? 1 : 0);
    }

    private static void i64_eqz(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        WasmFrame.pushInt(frame, stackPointer - 1, x == 0L ? 1 : 0);
    }

    private static void i32_eq(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y == x ? 1 : 0);
    }

    private static void i32_ne(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y != x ? 1 : 0);
    }

    private static void i32_lt_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y < x ? 1 : 0);
    }

    private static void i32_lt_u(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, Integer.compareUnsigned(y, x) < 0 ? 1 : 0);
    }

    private static void i32_gt_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y > x ? 1 : 0);
    }

    private static void i32_gt_u(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, Integer.compareUnsigned(y, x) > 0 ? 1 : 0);
    }

    private static void i32_le_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y <= x ? 1 : 0);
    }

    private static void i32_le_u(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, Integer.compareUnsigned(y, x) <= 0 ? 1 : 0);
    }

    private static void i32_ge_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y >= x ? 1 : 0);
    }

    private static void i32_ge_u(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, Integer.compareUnsigned(y, x) >= 0 ? 1 : 0);
    }

    private static void i64_eq(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y == x ? 1 : 0);
    }

    private static void i64_ne(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y != x ? 1 : 0);
    }

    private static void i64_lt_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y < x ? 1 : 0);
    }

    private static void i64_lt_u(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, Long.compareUnsigned(y, x) < 0 ? 1 : 0);
    }

    private static void i64_gt_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y > x ? 1 : 0);
    }

    private static void i64_gt_u(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, Long.compareUnsigned(y, x) > 0 ? 1 : 0);
    }

    private static void i64_le_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y <= x ? 1 : 0);
    }

    private static void i64_le_u(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, Long.compareUnsigned(y, x) <= 0 ? 1 : 0);
    }

    private static void i64_ge_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y >= x ? 1 : 0);
    }

    private static void i64_ge_u(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, Long.compareUnsigned(y, x) >= 0 ? 1 : 0);
    }

    private static void f32_eq(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y == x ? 1 : 0);
    }

    private static void f32_ne(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y != x ? 1 : 0);
    }

    private static void f32_lt(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y < x ? 1 : 0);
    }

    private static void f32_gt(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y > x ? 1 : 0);
    }

    private static void f32_le(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y <= x ? 1 : 0);
    }

    private static void f32_ge(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y >= x ? 1 : 0);
    }

    private static void f64_eq(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y == x ? 1 : 0);
    }

    private static void f64_ne(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y != x ? 1 : 0);
    }

    private static void f64_lt(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y < x ? 1 : 0);
    }

    private static void f64_gt(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y > x ? 1 : 0);
    }

    private static void f64_le(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y <= x ? 1 : 0);
    }

    private static void f64_ge(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        WasmFrame.pushInt(frame, stackPointer - 2, y >= x ? 1 : 0);
    }

    private static void i32_clz(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int result = Integer.numberOfLeadingZeros(x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i32_ctz(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int result = Integer.numberOfTrailingZeros(x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i32_popcnt(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int result = Integer.bitCount(x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i32_add(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y + x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_sub(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y - x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_mul(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y * x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private void i32_div_s(VirtualFrame frame, int stackPointer) {
        int result;
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        if (x == -1 && y == Integer.MIN_VALUE) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW, this);
        }
        try {
            result = y / x;
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_DIVIDE_BY_ZERO, this);
        }
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private void i32_div_u(VirtualFrame frame, int stackPointer) {
        int result;
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        try {
            result = Integer.divideUnsigned(y, x);
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_DIVIDE_BY_ZERO, this);
        }
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private void i32_rem_s(VirtualFrame frame, int stackPointer) {
        int result;
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        try {
            result = y % x;
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_DIVIDE_BY_ZERO, this);
        }
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private void i32_rem_u(VirtualFrame frame, int stackPointer) {
        int result;
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        try {
            result = Integer.remainderUnsigned(y, x);
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_DIVIDE_BY_ZERO, this);
        }
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_and(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y & x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_or(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y | x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_xor(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y ^ x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_shl(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y << x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_shr_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y >> x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_shr_u(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = y >>> x;
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_rotl(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = Integer.rotateLeft(y, x);
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i32_rotr(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int y = WasmFrame.popInt(frame, stackPointer - 2);
        int result = Integer.rotateRight(y, x);
        WasmFrame.pushInt(frame, stackPointer - 2, result);
    }

    private static void i64_clz(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long result = Long.numberOfLeadingZeros(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_ctz(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long result = Long.numberOfTrailingZeros(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_popcnt(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long result = Long.bitCount(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_add(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y + x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_sub(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y - x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_mul(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y * x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private void i64_div_s(VirtualFrame frame, int stackPointer) {
        long result;
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        if (x == -1L && y == Long.MIN_VALUE) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW, this);
        }
        try {
            result = y / x;
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_DIVIDE_BY_ZERO, this);
        }
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private void i64_div_u(VirtualFrame frame, int stackPointer) {
        long result;
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        try {
            result = Long.divideUnsigned(y, x);
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_DIVIDE_BY_ZERO, this);
        }
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private void i64_rem_s(VirtualFrame frame, int stackPointer) {
        long result;
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        try {
            result = y % x;
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_DIVIDE_BY_ZERO, this);
        }
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private void i64_rem_u(VirtualFrame frame, int stackPointer) {
        long result;
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        try {
            result = Long.remainderUnsigned(y, x);
        }
        catch (ArithmeticException e) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_DIVIDE_BY_ZERO, this);
        }
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_and(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y & x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_or(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y | x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_xor(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y ^ x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_shl(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y << (int)x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_shr_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y >> (int)x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_shr_u(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = y >>> (int)x;
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_rotl(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = Long.rotateLeft(y, (int)x);
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void i64_rotr(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long y = WasmFrame.popLong(frame, stackPointer - 2);
        long result = Long.rotateRight(y, (int)x);
        WasmFrame.pushLong(frame, stackPointer - 2, result);
    }

    private static void f32_abs(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float result = Math.abs(x);
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_neg(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float result = -x;
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_ceil(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float result = (float)Math.ceil(x);
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_floor(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float result = (float)Math.floor(x);
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_trunc(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float result = ExactMath.truncate((float)x);
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_nearest(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float result = (float)Math.rint(x);
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_sqrt(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float result = (float)Math.sqrt(x);
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_add(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        float result = y + x;
        WasmFrame.pushFloat(frame, stackPointer - 2, result);
    }

    private static void f32_sub(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        float result = y - x;
        WasmFrame.pushFloat(frame, stackPointer - 2, result);
    }

    private static void f32_mul(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        float result = y * x;
        WasmFrame.pushFloat(frame, stackPointer - 2, result);
    }

    private static void f32_div(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        float result = y / x;
        WasmFrame.pushFloat(frame, stackPointer - 2, result);
    }

    private static void f32_min(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        float result = Math.min(y, x);
        WasmFrame.pushFloat(frame, stackPointer - 2, result);
    }

    private static void f32_max(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        float result = Math.max(y, x);
        WasmFrame.pushFloat(frame, stackPointer - 2, result);
    }

    private static void f32_copysign(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        float y = WasmFrame.popFloat(frame, stackPointer - 2);
        float result = Math.copySign(y, x);
        WasmFrame.pushFloat(frame, stackPointer - 2, result);
    }

    private static void f64_abs(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double result = Math.abs(x);
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_neg(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double result = -x;
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_ceil(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double result = Math.ceil(x);
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_floor(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double result = Math.floor(x);
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_trunc(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double result = ExactMath.truncate((double)x);
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_nearest(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double result = Math.rint(x);
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_sqrt(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double result = Math.sqrt(x);
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_add(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        double result = y + x;
        WasmFrame.pushDouble(frame, stackPointer - 2, result);
    }

    private static void f64_sub(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        double result = y - x;
        WasmFrame.pushDouble(frame, stackPointer - 2, result);
    }

    private static void f64_mul(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        double result = y * x;
        WasmFrame.pushDouble(frame, stackPointer - 2, result);
    }

    private static void f64_div(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        double result = y / x;
        WasmFrame.pushDouble(frame, stackPointer - 2, result);
    }

    private static void f64_min(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        double result = Math.min(y, x);
        WasmFrame.pushDouble(frame, stackPointer - 2, result);
    }

    private static void f64_max(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        double result = Math.max(y, x);
        WasmFrame.pushDouble(frame, stackPointer - 2, result);
    }

    private static void f64_copysign(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        double y = WasmFrame.popDouble(frame, stackPointer - 2);
        double result = Math.copySign(y, x);
        WasmFrame.pushDouble(frame, stackPointer - 2, result);
    }

    private static void i32_wrap_i64(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        int result = (int)(x & 0xFFFFFFFFL);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private void i32_trunc_f32_s(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        if (Float.isNaN(x)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INVALID_CONVERSION_TO_INT);
        }
        if (x < -2.1474836E9f || x > 2.1474835E9f) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW);
        }
        int result = (int)WasmMath.truncFloatToLong(x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private void i32_trunc_f32_u(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        if (Float.isNaN(x)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INVALID_CONVERSION_TO_INT);
        }
        if (x < -0.99999994f || x > 4.294967E9f) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW);
        }
        int result = (int)WasmMath.truncFloatToUnsignedLong(x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private void i32_trunc_f64_s(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        if (Double.isNaN(x)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INVALID_CONVERSION_TO_INT);
        }
        if (x < -2.1474836489999995E9 || x > 2.1474836479999998E9) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW);
        }
        int result = (int)WasmMath.truncDoubleToLong(x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private void i32_trunc_f64_u(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        if (Double.isNaN(x)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INVALID_CONVERSION_TO_INT);
        }
        if (x < -0.9999999999999999 || x > 4.2949672959999995E9) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW);
        }
        int result = (int)WasmMath.truncDoubleToUnsignedLong(x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i32_trunc_sat_f32_s(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        int result = (int)ExactMath.truncate((float)x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i32_trunc_sat_f32_u(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        int result = Float.isNaN(x) || x < -0.99999994f ? 0 : (x > 4.294967E9f ? -1 : (int)WasmMath.truncFloatToUnsignedLong(x));
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i32_trunc_sat_f64_s(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        int result = (int)ExactMath.truncate((double)x);
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i32_trunc_sat_f64_u(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        int result = Double.isNaN(x) || x < -0.9999999999999999 ? 0 : (x > 4.2949672959999995E9 ? -1 : (int)WasmMath.truncDoubleToUnsignedLong(x));
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i64_extend_i32_s(VirtualFrame frame, int stackPointer) {
        long result = WasmFrame.popInt(frame, stackPointer - 1);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_extend_i32_u(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        long result = (long)x & 0xFFFFFFFFL;
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private void i64_trunc_f32_s(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        if (Float.isNaN(x)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INVALID_CONVERSION_TO_INT);
        }
        if (x < -9.223372E18f || x > 9.2233715E18f) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW);
        }
        long result = WasmMath.truncFloatToLong(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private void i64_trunc_f32_u(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        if (Float.isNaN(x)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INVALID_CONVERSION_TO_INT);
        }
        if (x < -0.99999994f || x > 1.8446743E19f) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW);
        }
        long result = WasmMath.truncFloatToUnsignedLong(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private void i64_trunc_f64_s(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        if (Double.isNaN(x)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INVALID_CONVERSION_TO_INT);
        }
        if (x < -9.223372036854776E18 || x > 9.223372036854775E18) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW);
        }
        long result = WasmMath.truncDoubleToLong(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private void i64_trunc_f64_u(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        if (Double.isNaN(x)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INVALID_CONVERSION_TO_INT);
        }
        if (x < -0.9999999999999999 || x > 1.844674407370955E19) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.INT_OVERFLOW);
        }
        long result = WasmMath.truncDoubleToUnsignedLong(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_trunc_sat_f32_s(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        long result = (long)ExactMath.truncate((float)x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_trunc_sat_f32_u(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        long result = Float.isNaN(x) || x < -0.99999994f ? 0L : WasmMath.truncFloatToUnsignedLong(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_trunc_sat_f64_s(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        long result = (long)ExactMath.truncate((double)x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_trunc_sat_f64_u(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        long result = Double.isNaN(x) || x < -0.9999999999999999 ? 0L : WasmMath.truncDoubleToUnsignedLong(x);
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void f32_convert_i32_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        WasmFrame.pushFloat(frame, stackPointer - 1, x);
    }

    private static void f32_convert_i32_u(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        float result = WasmMath.unsignedIntToFloat(x);
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_convert_i64_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        WasmFrame.pushFloat(frame, stackPointer - 1, x);
    }

    private static void f32_convert_i64_u(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        float result = WasmMath.unsignedLongToFloat(x);
        WasmFrame.pushFloat(frame, stackPointer - 1, result);
    }

    private static void f32_demote_f64(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        WasmFrame.pushFloat(frame, stackPointer - 1, (float)x);
    }

    private static void f64_convert_i32_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        WasmFrame.pushDouble(frame, stackPointer - 1, x);
    }

    private static void f64_convert_i32_u(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        double result = WasmMath.unsignedIntToDouble(x);
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_convert_i64_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        WasmFrame.pushDouble(frame, stackPointer - 1, x);
    }

    private static void f64_convert_i64_u(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        double result = WasmMath.unsignedLongToDouble(x);
        WasmFrame.pushDouble(frame, stackPointer - 1, result);
    }

    private static void f64_promote_f32(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        WasmFrame.pushDouble(frame, stackPointer - 1, x);
    }

    private static void i32_reinterpret_f32(VirtualFrame frame, int stackPointer) {
        float x = WasmFrame.popFloat(frame, stackPointer - 1);
        WasmFrame.pushInt(frame, stackPointer - 1, Float.floatToRawIntBits(x));
    }

    private static void i64_reinterpret_f64(VirtualFrame frame, int stackPointer) {
        double x = WasmFrame.popDouble(frame, stackPointer - 1);
        WasmFrame.pushLong(frame, stackPointer - 1, Double.doubleToRawLongBits(x));
    }

    private static void f32_reinterpret_i32(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        WasmFrame.pushFloat(frame, stackPointer - 1, Float.intBitsToFloat(x));
    }

    private static void f64_reinterpret_i64(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        WasmFrame.pushDouble(frame, stackPointer - 1, Double.longBitsToDouble(x));
    }

    private static void i32_extend8_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int result = x << 24 >> 24;
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i32_extend16_s(VirtualFrame frame, int stackPointer) {
        int x = WasmFrame.popInt(frame, stackPointer - 1);
        int result = x << 16 >> 16;
        WasmFrame.pushInt(frame, stackPointer - 1, result);
    }

    private static void i64_extend8_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long result = x << 56 >> 56;
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_extend16_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long result = x << 48 >> 48;
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    private static void i64_extend32_s(VirtualFrame frame, int stackPointer) {
        long x = WasmFrame.popLong(frame, stackPointer - 1);
        long result = x << 32 >> 32;
        WasmFrame.pushLong(frame, stackPointer - 1, result);
    }

    @CompilerDirectives.TruffleBoundary
    private void table_init(WasmContext context, WasmInstance instance, int length, int source, int destination, int tableIndex, int elementIndex) {
        WasmTable table = context.tables().table(instance.tableAddress(tableIndex));
        Object[] elementInstance = instance.elemInstance(elementIndex);
        int elementInstanceLength = elementInstance == null ? 0 : elementInstance.length;
        if (WasmFunctionNode.checkOutOfBounds(source, length, elementInstanceLength) || WasmFunctionNode.checkOutOfBounds(destination, length, table.size())) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.OUT_OF_BOUNDS_TABLE_ACCESS);
        }
        if (length == 0) {
            return;
        }
        table.initialize(elementInstance, source, destination, length);
    }

    private void table_get(WasmContext context, WasmInstance instance, VirtualFrame frame, int stackPointer, int index) {
        WasmTable table = context.tables().table(instance.tableAddress(index));
        int i = WasmFrame.popInt(frame, stackPointer - 1);
        if (i < 0 || i >= table.size()) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.OUT_OF_BOUNDS_TABLE_ACCESS);
        }
        Object value = table.get(i);
        WasmFrame.pushReference(frame, stackPointer - 1, value);
    }

    private void table_set(WasmContext context, WasmInstance instance, VirtualFrame frame, int stackPointer, int index) {
        WasmTable table = context.tables().table(instance.tableAddress(index));
        Object value = WasmFrame.popReference(frame, stackPointer - 1);
        int i = WasmFrame.popInt(frame, stackPointer - 2);
        if (i < 0 || i >= table.size()) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.OUT_OF_BOUNDS_TABLE_ACCESS);
        }
        table.set(i, value);
    }

    private static void table_size(WasmContext context, WasmInstance instance, VirtualFrame frame, int stackPointer, int index) {
        WasmTable table = context.tables().table(instance.tableAddress(index));
        WasmFrame.pushInt(frame, stackPointer, table.size());
    }

    @CompilerDirectives.TruffleBoundary
    private static int table_grow(WasmContext context, WasmInstance instance, int length, Object value, int index) {
        WasmTable table = context.tables().table(instance.tableAddress(index));
        return table.grow(length, value);
    }

    @CompilerDirectives.TruffleBoundary
    private void table_copy(WasmContext context, WasmInstance instance, int length, int source, int destination, int sourceTableIndex, int destinationTableIndex) {
        WasmTable sourceTable = context.tables().table(instance.tableAddress(sourceTableIndex));
        WasmTable destinationTable = context.tables().table(instance.tableAddress(destinationTableIndex));
        if (WasmFunctionNode.checkOutOfBounds(source, length, sourceTable.size()) || WasmFunctionNode.checkOutOfBounds(destination, length, destinationTable.size())) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.OUT_OF_BOUNDS_TABLE_ACCESS);
        }
        if (length == 0) {
            return;
        }
        destinationTable.copyFrom(sourceTable, source, destination, length);
    }

    @CompilerDirectives.TruffleBoundary
    private void table_fill(WasmContext context, WasmInstance instance, int length, Object value, int offset, int index) {
        WasmTable table = context.tables().table(instance.tableAddress(index));
        if (WasmFunctionNode.checkOutOfBounds(offset, length, table.size())) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.OUT_OF_BOUNDS_TABLE_ACCESS);
        }
        if (length == 0) {
            return;
        }
        table.fill(offset, length, value);
    }

    @CompilerDirectives.TruffleBoundary
    private void memory_init(WasmInstance instance, int length, int source, long destination, int dataIndex, int memoryIndex) {
        WasmMemory memory = this.memory(instance, memoryIndex);
        WasmMemoryLibrary memoryLib = this.memoryLib(memoryIndex);
        int dataOffset = instance.dataInstanceOffset(dataIndex);
        int dataLength = instance.dataInstanceLength(dataIndex);
        if (WasmFunctionNode.checkOutOfBounds(source, length, dataLength)) {
            this.enterErrorBranch();
            throw WasmException.create(Failure.OUT_OF_BOUNDS_MEMORY_ACCESS);
        }
        memoryLib.initialize(memory, null, this.codeEntry.bytecode(), dataOffset + source, destination, length);
    }

    @CompilerDirectives.TruffleBoundary
    private static void data_drop(WasmInstance instance, int dataIndex) {
        instance.dropDataInstance(dataIndex);
    }

    @CompilerDirectives.TruffleBoundary
    private void memory_fill(WasmInstance instance, long length, int value, long offset, int memoryIndex) {
        WasmMemory memory = this.memory(instance, memoryIndex);
        this.memoryLib(memoryIndex).fill(memory, this, offset, length, (byte)value);
    }

    @CompilerDirectives.TruffleBoundary
    private void memory_copy(WasmInstance instance, long length, long source, long destination, int destMemoryIndex, int srcMemoryIndex) {
        WasmMemory destMemory = this.memory(instance, destMemoryIndex);
        WasmMemory srcMemory = this.memory(instance, srcMemoryIndex);
        this.memoryLib(destMemoryIndex).copyFrom(destMemory, this, srcMemory, source, destination, length);
    }

    private static boolean checkOutOfBounds(int offset, int length, int size) {
        return offset < 0 || length < 0 || offset + length < 0 || offset + length > size;
    }

    @ExplodeLoop
    private Object[] createArgumentsForCall(VirtualFrame frame, int functionTypeIndex, int numArgs, int stackPointerOffset) {
        CompilerAsserts.partialEvaluationConstant((int)numArgs);
        Object[] args = WasmArguments.createEmpty(numArgs);
        int stackPointer = stackPointerOffset;
        for (int i = numArgs - 1; i >= 0; --i) {
            --stackPointer;
            byte type = this.module.symbolTable().functionTypeParamTypeAt(functionTypeIndex, i);
            CompilerAsserts.partialEvaluationConstant((int)type);
            Object arg = switch (type) {
                case 127 -> WasmFrame.popInt(frame, stackPointer);
                case 126 -> WasmFrame.popLong(frame, stackPointer);
                case 125 -> Float.valueOf(WasmFrame.popFloat(frame, stackPointer));
                case 124 -> WasmFrame.popDouble(frame, stackPointer);
                case 123 -> WasmFrame.popVector128(frame, stackPointer);
                case 111, 112 -> WasmFrame.popReference(frame, stackPointer);
                default -> throw WasmException.format(Failure.UNSPECIFIED_TRAP, (Node)this, "Unknown type: %d", type);
            };
            WasmArguments.setArgument(args, i, arg);
        }
        return args;
    }

    @ExplodeLoop
    private static void unwindPrimitiveStack(VirtualFrame frame, int stackPointer, int targetStackPointer, int targetResultCount) {
        CompilerAsserts.partialEvaluationConstant((int)stackPointer);
        CompilerAsserts.partialEvaluationConstant((int)targetResultCount);
        for (int i = 0; i < targetResultCount; ++i) {
            WasmFrame.copyPrimitive(frame, stackPointer + i - targetResultCount, targetStackPointer + i);
        }
    }

    @ExplodeLoop
    private static void unwindObjectStack(VirtualFrame frame, int stackPointer, int targetStackPointer, int targetResultCount) {
        CompilerAsserts.partialEvaluationConstant((int)stackPointer);
        CompilerAsserts.partialEvaluationConstant((int)targetResultCount);
        for (int i = 0; i < targetResultCount; ++i) {
            WasmFrame.copyObject(frame, stackPointer + i - targetResultCount, targetStackPointer + i);
        }
    }

    @ExplodeLoop
    private static void unwindStack(VirtualFrame frame, int stackPointer, int targetStackPointer, int targetResultCount) {
        CompilerAsserts.partialEvaluationConstant((int)stackPointer);
        CompilerAsserts.partialEvaluationConstant((int)targetResultCount);
        for (int i = 0; i < targetResultCount; ++i) {
            WasmFrame.copy(frame, stackPointer + i - targetResultCount, targetStackPointer + i);
        }
    }

    @ExplodeLoop
    private static void dropStack(VirtualFrame frame, int stackPointer, int targetStackPointer) {
        CompilerAsserts.partialEvaluationConstant((int)stackPointer);
        CompilerAsserts.partialEvaluationConstant((int)targetStackPointer);
        for (int i = targetStackPointer; i < stackPointer; ++i) {
            WasmFrame.drop(frame, i);
        }
    }

    private static boolean profileCondition(byte[] data, int profileOffset, boolean condition) {
        int t = BinaryStreamParser.rawPeekU8(data, profileOffset);
        int f = BinaryStreamParser.rawPeekU8(data, profileOffset + 1);
        boolean val = condition;
        if (val) {
            if (t == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (!CompilerDirectives.inInterpreter()) {
                if (f == 0) {
                    val = true;
                }
            } else if (t < 255) {
                data[profileOffset] = (byte)(t + 1);
            }
        } else {
            if (f == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (!CompilerDirectives.inInterpreter()) {
                if (t == 0) {
                    val = false;
                }
            } else if (f < 255) {
                data[profileOffset + 1] = (byte)(f + 1);
            }
        }
        if (CompilerDirectives.inInterpreter()) {
            return val;
        }
        int sum = t + f;
        return CompilerDirectives.injectBranchProbability((double)((double)t / (double)sum), (boolean)val);
    }

    private static void updateBranchTableProfile(byte[] data, int counterOffset, int profileOffset) {
        CompilerAsserts.neverPartOfCompilation();
        int counter = BinaryStreamParser.rawPeekU16(data, counterOffset);
        int profile = BinaryStreamParser.rawPeekU16(data, profileOffset);
        if (!$assertionsDisabled && profile == 65535) {
            throw new AssertionError();
        }
        if (counter < 65535) {
            BinaryStreamParser.writeU16(data, counterOffset, counter + 1);
        }
        if ((counter < 65535 || profile == 0) && profile < 65534) {
            BinaryStreamParser.writeU16(data, profileOffset, profile + 1);
        }
    }

    private static boolean profileBranchTable(byte[] data, int counterOffset, int profileOffset, boolean condition) {
        int t = BinaryStreamParser.rawPeekU16(data, profileOffset);
        int sum = BinaryStreamParser.rawPeekU16(data, counterOffset);
        boolean val = condition;
        if (val) {
            if (t == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (t == sum) {
                val = true;
            }
        } else {
            if (t == sum) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (t == 0) {
                val = false;
            }
        }
        double probability = Math.min((double)t / (double)sum, 1.0);
        return CompilerDirectives.injectBranchProbability((double)probability, (boolean)val);
    }

    private int pushDirectCallResult(VirtualFrame frame, int stackPointer, WasmFunction function, Object result, WasmLanguage language) {
        int resultCount = function.resultCount();
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        if (resultCount == 0) {
            return stackPointer;
        }
        if (resultCount == 1) {
            byte resultType = function.resultTypeAt(0);
            this.pushResult(frame, stackPointer, resultType, result);
            return stackPointer + 1;
        }
        int functionTypeIndex = function.typeIndex();
        this.extractMultiValueResult(frame, stackPointer, result, resultCount, functionTypeIndex, language);
        return stackPointer + resultCount;
    }

    private int pushIndirectCallResult(VirtualFrame frame, int stackPointer, int expectedFunctionTypeIndex, Object result, WasmLanguage language) {
        int resultCount = this.module.symbolTable().functionTypeResultCount(expectedFunctionTypeIndex);
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        if (resultCount == 0) {
            return stackPointer;
        }
        if (resultCount == 1) {
            byte resultType = this.module.symbolTable().functionTypeResultTypeAt(expectedFunctionTypeIndex, 0);
            this.pushResult(frame, stackPointer, resultType, result);
            return stackPointer + 1;
        }
        this.extractMultiValueResult(frame, stackPointer, result, resultCount, expectedFunctionTypeIndex, language);
        return stackPointer + resultCount;
    }

    private void pushResult(VirtualFrame frame, int stackPointer, byte resultType, Object result) {
        CompilerAsserts.partialEvaluationConstant((int)resultType);
        switch (resultType) {
            case 127: {
                WasmFrame.pushInt(frame, stackPointer, (Integer)result);
                break;
            }
            case 126: {
                WasmFrame.pushLong(frame, stackPointer, (Long)result);
                break;
            }
            case 125: {
                WasmFrame.pushFloat(frame, stackPointer, ((Float)result).floatValue());
                break;
            }
            case 124: {
                WasmFrame.pushDouble(frame, stackPointer, (Double)result);
                break;
            }
            case 123: {
                WasmFrame.pushVector128(frame, stackPointer, (Vector128)result);
                break;
            }
            case 111: 
            case 112: {
                WasmFrame.pushReference(frame, stackPointer, result);
                break;
            }
            default: {
                throw WasmException.format(Failure.UNSPECIFIED_TRAP, (Node)this, "Unknown result type: %d", resultType);
            }
        }
    }

    @ExplodeLoop
    private void extractMultiValueResult(VirtualFrame frame, int stackPointer, Object result, int resultCount, int functionTypeIndex, WasmLanguage language) {
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        if (!$assertionsDisabled && result != WasmConstant.MULTI_VALUE) {
            throw new AssertionError(result);
        }
        WasmLanguage.MultiValueStack multiValueStack = language.multiValueStack();
        long[] primitiveMultiValueStack = multiValueStack.primitiveStack();
        Object[] objectMultiValueStack = multiValueStack.objectStack();
        block8: for (int i = 0; i < resultCount; ++i) {
            byte resultType = this.module.symbolTable().functionTypeResultTypeAt(functionTypeIndex, i);
            CompilerAsserts.partialEvaluationConstant((int)resultType);
            switch (resultType) {
                case 127: {
                    WasmFrame.pushInt(frame, stackPointer + i, (int)primitiveMultiValueStack[i]);
                    continue block8;
                }
                case 126: {
                    WasmFrame.pushLong(frame, stackPointer + i, primitiveMultiValueStack[i]);
                    continue block8;
                }
                case 125: {
                    WasmFrame.pushFloat(frame, stackPointer + i, Float.intBitsToFloat((int)primitiveMultiValueStack[i]));
                    continue block8;
                }
                case 124: {
                    WasmFrame.pushDouble(frame, stackPointer + i, Double.longBitsToDouble(primitiveMultiValueStack[i]));
                    continue block8;
                }
                case 123: {
                    WasmFrame.pushVector128(frame, stackPointer + i, (Vector128)objectMultiValueStack[i]);
                    objectMultiValueStack[i] = null;
                    continue block8;
                }
                case 111: 
                case 112: {
                    WasmFrame.pushReference(frame, stackPointer + i, objectMultiValueStack[i]);
                    objectMultiValueStack[i] = null;
                    continue block8;
                }
                default: {
                    this.enterErrorBranch();
                    throw WasmException.format(Failure.UNSPECIFIED_TRAP, (Node)this, "Unknown result type: %d", resultType);
                }
            }
        }
    }

    static {
        boolean bl = $assertionsDisabled = !WasmFunctionNode.class.desiredAssertionStatus();
        if (!$assertionsDisabled && Integer.bitCount(256) != 1) {
            throw new AssertionError((Object)"must be a power of 2");
        }
    }

    private static final class WasmOSRInterpreterState {
        final int stackPointer;
        final int line;

        WasmOSRInterpreterState(int stackPointer, int line) {
            this.stackPointer = stackPointer;
            this.line = line;
        }
    }

    private static final class BackEdgeCounter {
        int count;

        private BackEdgeCounter() {
        }
    }
}

