/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.globals;

import org.graalvm.wasm.api.ValueType;
import org.graalvm.wasm.globals.WasmGlobal;

public class DefaultWasmGlobal
extends WasmGlobal {
    private long globalValue;
    private Object globalObjectValue;

    public DefaultWasmGlobal(ValueType valueType, boolean mutable, int value) {
        super(valueType, mutable);
        this.storeInt(value);
    }

    public DefaultWasmGlobal(ValueType valueType, boolean mutable, long value) {
        super(valueType, mutable);
        this.storeLong(value);
    }

    public DefaultWasmGlobal(ValueType valueType, boolean mutable, Object value) {
        super(valueType, mutable);
        this.storeObject(value);
    }

    @Override
    public int loadAsInt() {
        assert (ValueType.isNumberType(this.getValueType()));
        return (int)this.globalValue;
    }

    @Override
    public long loadAsLong() {
        assert (ValueType.isNumberType(this.getValueType()));
        return this.globalValue;
    }

    @Override
    public Object loadAsObject() {
        assert (this.globalObjectValue != null);
        assert (ValueType.isReferenceType(this.getValueType()) || ValueType.isVectorType(this.getValueType()));
        return this.globalObjectValue;
    }

    @Override
    public void storeInt(int value) {
        assert (ValueType.isNumberType(this.getValueType()));
        this.globalValue = value;
    }

    @Override
    public void storeLong(long value) {
        assert (ValueType.isNumberType(this.getValueType()));
        this.globalValue = value;
    }

    @Override
    public void storeObject(Object value) {
        assert (ValueType.isReferenceType(this.getValueType()) || ValueType.isVectorType(this.getValueType()));
        this.globalObjectValue = value;
    }
}

