/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.representation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;
import org.graalvm.wasm.debugging.representation.DebugDisplayValue;
import org.graalvm.wasm.nodes.WasmDataAccess;

@ExportLibrary(value=InteropLibrary.class)
public final class DebugObjectDisplayValue
extends DebugDisplayValue
implements TruffleObject {
    private final DebugContext context;
    private final DebugLocation location;
    private final String name;
    private final EconomicMap<String, DebugObject> members;

    private DebugObjectDisplayValue(DebugContext context, DebugLocation location, String name, EconomicMap<String, DebugObject> members) {
        assert (context != null) : "the context provided to a debug object display value must not be null";
        assert (location != null) : "the location provided to a debug object display value must not be null";
        assert (members != null) : "the list of members provided to a debug object display value must not be null";
        this.context = context;
        this.location = location;
        this.name = name;
        this.members = members;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object fromDebugObject(DebugObject object, DebugContext context, DebugLocation location) {
        EconomicMap members = EconomicMap.create();
        int count = object.memberCount();
        for (int i = 0; i < count; ++i) {
            DebugObject member = object.readMember(context, location, i);
            if (!member.isVisible(context.sourceCodeLocation())) continue;
            members.put((Object)member.toDisplayString(), (Object)member);
        }
        return new DebugObjectDisplayValue(context, location, object.toString(), (EconomicMap<String, DebugObject>)members);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object fromDebugFunction(DebugFunction function, DebugContext context, MaterializedFrame frame, WasmDataAccess dataAccess, boolean testMode) {
        DebugLocation frameBase = function.frameBaseOrNull(frame, dataAccess);
        if (frameBase == null) {
            return DebugConstantDisplayValue.UNDEFINED;
        }
        if (function.hasGlobals() || testMode) {
            EconomicMap members = EconomicMap.of((Object)"globals", (Object)function.globals(), (Object)"locals", (Object)function.locals());
            return new DebugObjectDisplayValue(context, frameBase, "", (EconomicMap<String, DebugObject>)members);
        }
        return DebugObjectDisplayValue.fromDebugObject(function.locals(), context, frameBase);
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return WasmLanguage.class;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.name != null ? this.name : "";
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException {
        if (this.members == null) {
            return (byte)64;
        }
        if (!this.members.containsKey((Object)member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        DebugObject memberObject = (DebugObject)this.members.get((Object)member);
        return this.resolveDebugObject(memberObject, this.context, this.location);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new WasmVariableNamesObject(this.members.getKeys());
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        return this.members.containsKey((Object)member);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class WasmVariableNamesObject
    implements TruffleObject {
        final List<String> names = new ArrayList<String>(0);

        WasmVariableNamesObject(Iterable<String> names) {
            for (String name : names) {
                this.names.add(name);
            }
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long getArraySize() {
            return this.names.size();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return this.names.get((int)index);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.names.size();
        }
    }
}

