/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugRelocatedMember;

public class DebugStructType
extends DebugType {
    private final String name;
    private final DebugObject[] members;
    private final DebugType[] superTypes;

    public DebugStructType(String name, DebugObject[] members, DebugType[] superTypes) {
        assert (members != null) : "the members of a debug struct type must not be null";
        assert (superTypes != null) : "the super types of a debug struct type must not be null";
        this.name = name;
        this.members = members;
        this.superTypes = superTypes;
    }

    @Override
    public String asTypeName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Override
    public int valueLength() {
        int length = 0;
        for (DebugType debugType : this.superTypes) {
            length += debugType.valueLength();
        }
        for (DebugType debugType : this.members) {
            length += debugType.valueLength();
        }
        return length;
    }

    @Override
    public boolean hasMembers() {
        return true;
    }

    @Override
    public int memberCount() {
        int count = 0;
        for (DebugType superType : this.superTypes) {
            count += superType.memberCount();
        }
        return count + this.members.length;
    }

    @Override
    public DebugObject readMember(DebugContext context, DebugLocation location, int index) {
        int i = index;
        for (DebugType superType : this.superTypes) {
            int count = superType.memberCount();
            if (i >= count) {
                i -= count;
                continue;
            }
            return superType.readMember(context, location, i);
        }
        return new DebugRelocatedMember(location, this.members[i]);
    }
}

