/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugValue;

public class DebugArrayType
extends DebugType {
    protected final String typeName;
    protected final DebugType elementType;
    protected final int[] dimensionSizes;

    public DebugArrayType(String typeName, DebugType elementType, int[] dimensionSizes) {
        assert (elementType != null) : "the element type of a debug array type must not be null";
        assert (dimensionSizes != null) : "the sizes of the array dimensions of a debug array type must not be null";
        this.typeName = typeName;
        this.elementType = elementType;
        this.dimensionSizes = dimensionSizes;
    }

    @Override
    public String asTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        return this.elementType.asTypeName() + "[]".repeat(this.dimensionSizes.length);
    }

    @Override
    public int valueLength() {
        int length = this.elementType.valueLength();
        for (int dimensionLength : this.dimensionSizes) {
            length *= dimensionLength;
        }
        return length;
    }

    @Override
    public boolean hasArrayElements() {
        return true;
    }

    @Override
    public int arrayDimensionCount() {
        return this.dimensionSizes.length;
    }

    @Override
    public int arrayDimensionSize(int dimension) {
        assert (dimension >= 0 && dimension < this.dimensionSizes.length) : "tried to get size of invalid array dimension of debug array type";
        return this.dimensionSizes[dimension];
    }

    @Override
    public DebugObject readArrayElement(DebugContext context, DebugLocation location, int index) {
        DebugLocation elementLocation = location.addOffset((long)index * (long)this.elementType.valueLength());
        return new DebugValue("", elementLocation, this.elementType);
    }
}

