/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.List;
import org.graalvm.wasm.debugging.DebugLineMap;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugScopeValue;
import org.graalvm.wasm.nodes.WasmDataAccess;

public class DebugFunction
extends DebugType {
    private final String name;
    private final DebugLineMap lineMap;
    private final SourceSection sourceSection;
    private final byte[] frameBaseExpression;
    private final List<DebugObject> variables;
    private final List<DebugObject> globals;

    public DebugFunction(String name, DebugLineMap lineMap, SourceSection sourceSection, byte[] frameBaseExpression, List<DebugObject> variables, List<DebugObject> globals) {
        assert (lineMap != null) : "the source code to bytecode line map of a debug function must not be null";
        assert (frameBaseExpression != null) : "the expression for calculating the frame base of a debug function must not be null";
        assert (variables != null) : "the list of variables of a debug function must not be null";
        assert (globals != null) : "the list of globals of a debug function must not be null";
        this.name = name;
        this.lineMap = lineMap;
        this.sourceSection = sourceSection;
        this.frameBaseExpression = frameBaseExpression;
        this.variables = variables;
        this.globals = globals;
    }

    @Override
    public String asTypeName() {
        return "function";
    }

    @Override
    public int valueLength() {
        return 0;
    }

    public boolean hasGlobals() {
        return this.globals.size() != 0;
    }

    public DebugObject globals() {
        return new DebugScopeValue("globals", this.globals);
    }

    public DebugObject locals() {
        return new DebugScopeValue("locals", this.variables);
    }

    public DebugLocation frameBaseOrNull(MaterializedFrame frame, WasmDataAccess dataAccess) {
        return DebugLocation.createFrameBaseOrNull(frame, dataAccess, this.frameBaseExpression);
    }

    public SourceSection sourceSection() {
        return this.sourceSection;
    }

    public DebugLineMap lineMap() {
        return this.lineMap;
    }

    public String name() {
        return this.name;
    }
}

