/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.wasm.ModuleLimits;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmContextOptions;
import org.graalvm.wasm.WasmFileDetector;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmOptionsOptionDescriptors;
import org.graalvm.wasm.api.JsConstants;
import org.graalvm.wasm.api.WebAssembly;
import org.graalvm.wasm.exception.WasmJsApiException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.predefined.BuiltinModule;

@TruffleLanguage.Registration(id="wasm", name="WebAssembly", defaultMimeType="application/wasm", byteMimeTypes={"application/wasm"}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED, fileTypeDetectors={WasmFileDetector.class}, interactive=false, website="https://www.graalvm.org/webassembly/", sandbox=SandboxPolicy.CONSTRAINED)
@ProvidedTags(value={StandardTags.RootTag.class, StandardTags.RootBodyTag.class, StandardTags.StatementTag.class})
public final class WasmLanguage
extends TruffleLanguage<WasmContext> {
    public static final String ID = "wasm";
    public static final String NAME = "WebAssembly";
    public static final String WASM_MIME_TYPE = "application/wasm";
    public static final String WASM_SOURCE_NAME_SUFFIX = ".wasm";
    public static final String MODULE_DECODE = "module_decode";
    private static final TruffleLanguage.LanguageReference<WasmLanguage> REFERENCE = TruffleLanguage.LanguageReference.create(WasmLanguage.class);
    @CompilerDirectives.CompilationFinal
    private volatile boolean isMultiContext;
    private final ContextThreadLocal<MultiValueStack> multiValueStackThreadLocal;
    private final Map<BuiltinModule, WasmModule> builtinModules;
    private final Map<SymbolTable.FunctionType, Integer> equivalenceClasses;
    private int nextEquivalenceClass;

    public WasmLanguage() {
        this.multiValueStackThreadLocal = this.locals.createContextThreadLocal((context, thread) -> new MultiValueStack());
        this.builtinModules = new ConcurrentHashMap<BuiltinModule, WasmModule>();
        this.equivalenceClasses = new ConcurrentHashMap<SymbolTable.FunctionType, Integer>();
        this.nextEquivalenceClass = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int equivalenceClassFor(SymbolTable.FunctionType type) {
        Integer equivalenceClass = this.equivalenceClasses.get(type);
        if (equivalenceClass == null) {
            WasmLanguage wasmLanguage = this;
            synchronized (wasmLanguage) {
                equivalenceClass = this.equivalenceClasses.get(type);
                if (equivalenceClass == null) {
                    equivalenceClass = this.nextEquivalenceClass++;
                    Integer prev = this.equivalenceClasses.put(type, equivalenceClass);
                    assert (prev == null);
                }
            }
        }
        return equivalenceClass;
    }

    protected WasmContext createContext(TruffleLanguage.Env env) {
        WasmContext context = new WasmContext(env, this);
        if (env.isPolyglotBindingsAccessAllowed()) {
            env.exportSymbol(NAME, (Object)new WebAssembly(context));
        }
        return context;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        WasmContext context = WasmContext.get(null);
        Source source = request.getSource();
        String moduleName = source.getName();
        byte[] data = source.getBytes().toByteArray();
        ModuleLimits moduleLimits = JsConstants.JS_LIMITS;
        WasmModule module = context.readModule(moduleName, data, moduleLimits);
        return new ParsedWasmModuleRootNode(this, module, source).getCallTarget();
    }

    public static WasmModule getParsedModule(CallTarget parseResult) {
        RootCallTarget rct;
        RootNode rootNode;
        if (parseResult instanceof RootCallTarget && (rootNode = (rct = (RootCallTarget)parseResult).getRootNode()) instanceof ParsedWasmModuleRootNode) {
            ParsedWasmModuleRootNode moduleRoot = (ParsedWasmModuleRootNode)rootNode;
            return moduleRoot.getModule();
        }
        return null;
    }

    protected Object getScope(WasmContext context) {
        return context.getScope();
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new WasmOptionsOptionDescriptors();
    }

    protected void finalizeContext(WasmContext context) {
        super.finalizeContext((Object)context);
        for (int i = 0; i < context.memories().count(); ++i) {
            WasmMemory memory = context.memories().memory(i);
            WasmMemoryLibrary.getUncached().close(memory);
        }
        try {
            context.fdManager().close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while closing WasmFilesManager.");
        }
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected void initializeMultipleContexts() {
        this.isMultiContext = true;
    }

    public boolean isMultiContext() {
        return this.isMultiContext;
    }

    public static WasmLanguage get(Node node) {
        return (WasmLanguage)REFERENCE.get(node);
    }

    public WasmModule getOrCreateBuiltinModule(BuiltinModule builtinModule, Function<? super BuiltinModule, ? extends WasmModule> factory) {
        return this.builtinModules.computeIfAbsent(builtinModule, factory);
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        if (!firstOptions.hasSetOptions() && !newOptions.hasSetOptions()) {
            return true;
        }
        if (firstOptions.equals((Object)newOptions)) {
            return true;
        }
        return WasmContextOptions.fromOptionValues(firstOptions).equals(WasmContextOptions.fromOptionValues(newOptions));
    }

    public MultiValueStack multiValueStack() {
        return (MultiValueStack)this.multiValueStackThreadLocal.get();
    }

    private static final class ParsedWasmModuleRootNode
    extends RootNode {
        private final WasmModule module;
        private final Source source;

        private ParsedWasmModuleRootNode(WasmLanguage language, WasmModule module, Source source) {
            super((TruffleLanguage)language);
            this.module = module;
            this.source = source;
        }

        public Object execute(VirtualFrame frame) {
            if (frame.getArguments().length == 0) {
                WasmContext context = WasmContext.get((Node)this);
                WasmInstance instance = context.lookupModuleInstance(this.module);
                if (instance == null) {
                    instance = context.readInstance(this.module);
                }
                return instance;
            }
            Object object = frame.getArguments()[0];
            if (object instanceof String) {
                String mode = (String)object;
                if (mode.equals(WasmLanguage.MODULE_DECODE)) {
                    return this.module;
                }
                throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Unsupported first argument: '%s'", (Object)mode);
            }
            throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "First argument must be a string");
        }

        public SourceSection getSourceSection() {
            return this.source.createUnavailableSection();
        }

        WasmModule getModule() {
            return this.module;
        }
    }

    public static final class MultiValueStack {
        private long[] primitiveStack;
        private Object[] objectStack;
        private int size = 1;

        public long[] primitiveStack() {
            return this.primitiveStack;
        }

        public Object[] objectStack() {
            return this.objectStack;
        }

        public void resize(int expectedSize) {
            if (expectedSize > this.size) {
                this.primitiveStack = new long[expectedSize];
                this.objectStack = new Object[expectedSize];
                this.size = expectedSize;
            }
        }
    }
}

