/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;
import org.graalvm.wasm.WasmOptions;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;

public class WasmContextOptions {
    @CompilerDirectives.CompilationFinal
    private boolean saturatingFloatToInt;
    @CompilerDirectives.CompilationFinal
    private boolean signExtensionOps;
    @CompilerDirectives.CompilationFinal
    private boolean multiValue;
    @CompilerDirectives.CompilationFinal
    private boolean bulkMemoryAndRefTypes;
    @CompilerDirectives.CompilationFinal
    private boolean memory64;
    @CompilerDirectives.CompilationFinal
    private boolean extendedConstExpressions;
    @CompilerDirectives.CompilationFinal
    private boolean multiMemory;
    @CompilerDirectives.CompilationFinal
    private boolean unsafeMemory;
    @CompilerDirectives.CompilationFinal
    private boolean threads;
    @CompilerDirectives.CompilationFinal
    private boolean simd;
    @CompilerDirectives.CompilationFinal
    private boolean relaxedSimd;
    @CompilerDirectives.CompilationFinal
    private boolean memoryOverheadMode;
    @CompilerDirectives.CompilationFinal
    private boolean constantRandomGet;
    @CompilerDirectives.CompilationFinal
    private boolean directByteBufferMemoryAccess;
    @CompilerDirectives.CompilationFinal
    private String debugCompDirectory;
    private final OptionValues optionValues;

    WasmContextOptions(OptionValues optionValues) {
        this.optionValues = optionValues;
        this.setOptionValues();
        this.checkOptionDependencies();
    }

    public static WasmContextOptions fromOptionValues(OptionValues optionValues) {
        return new WasmContextOptions(optionValues);
    }

    private void setOptionValues() {
        this.saturatingFloatToInt = this.readBooleanOption(WasmOptions.SaturatingFloatToInt);
        this.signExtensionOps = this.readBooleanOption(WasmOptions.SignExtensionOps);
        this.multiValue = this.readBooleanOption(WasmOptions.MultiValue);
        this.bulkMemoryAndRefTypes = this.readBooleanOption(WasmOptions.BulkMemoryAndRefTypes);
        this.memory64 = this.readBooleanOption(WasmOptions.Memory64);
        this.extendedConstExpressions = this.readBooleanOption(WasmOptions.ExtendedConstExpressions);
        this.multiMemory = this.readBooleanOption(WasmOptions.MultiMemory);
        this.threads = this.readBooleanOption(WasmOptions.Threads);
        this.unsafeMemory = this.readBooleanOption(WasmOptions.UseUnsafeMemory);
        this.simd = this.readBooleanOption(WasmOptions.SIMD);
        this.relaxedSimd = this.readBooleanOption(WasmOptions.RelaxedSIMD);
        this.memoryOverheadMode = this.readBooleanOption(WasmOptions.MemoryOverheadMode);
        this.constantRandomGet = this.readBooleanOption(WasmOptions.WasiConstantRandomGet);
        this.directByteBufferMemoryAccess = this.readBooleanOption(WasmOptions.DirectByteBufferMemoryAccess);
        this.debugCompDirectory = this.readStringOption(WasmOptions.DebugCompDirectory);
    }

    private void checkOptionDependencies() {
        if (this.memory64 && !this.unsafeMemory) {
            WasmContextOptions.failDependencyCheck("Memory64", "UseUnsafeMemory");
        }
        if (this.directByteBufferMemoryAccess && !this.unsafeMemory) {
            WasmContextOptions.failDependencyCheck("DirectByteBufferMemoryAccess", "UseUnsafeMemory");
        }
    }

    private boolean readBooleanOption(OptionKey<Boolean> key) {
        return (Boolean)key.getValue(this.optionValues);
    }

    private String readStringOption(OptionKey<String> key) {
        return (String)key.getValue(this.optionValues);
    }

    private static void failDependencyCheck(String option, String dependency) {
        throw WasmException.format(Failure.INCOMPATIBLE_OPTIONS, "Incompatible WebAssembly options: %s requires %s to be enabled.", option, dependency);
    }

    public boolean supportSaturatingFloatToInt() {
        return this.saturatingFloatToInt;
    }

    public boolean supportSignExtensionOps() {
        return this.signExtensionOps;
    }

    public boolean supportMultiValue() {
        return this.multiValue;
    }

    public boolean supportBulkMemoryAndRefTypes() {
        return this.bulkMemoryAndRefTypes;
    }

    public boolean supportMemory64() {
        return this.memory64;
    }

    public boolean supportExtendedConstExpressions() {
        return this.extendedConstExpressions;
    }

    public boolean supportMultiMemory() {
        return this.multiMemory;
    }

    public boolean supportThreads() {
        return this.threads;
    }

    public boolean useUnsafeMemory() {
        return this.unsafeMemory;
    }

    public boolean supportSIMD() {
        return this.simd;
    }

    public boolean supportRelaxedSIMD() {
        return this.relaxedSimd;
    }

    public boolean memoryOverheadMode() {
        return this.memoryOverheadMode;
    }

    public boolean constantRandomGet() {
        return this.constantRandomGet;
    }

    public boolean directByteBufferMemoryAccess() {
        return this.directByteBufferMemoryAccess;
    }

    public String debugCompDirectory() {
        return this.debugCompDirectory;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.saturatingFloatToInt ? 1 : 0);
        hash = 53 * hash + (this.signExtensionOps ? 1 : 0);
        hash = 53 * hash + (this.multiValue ? 1 : 0);
        hash = 53 * hash + (this.bulkMemoryAndRefTypes ? 1 : 0);
        hash = 53 * hash + (this.memory64 ? 1 : 0);
        hash = 54 * hash + (this.extendedConstExpressions ? 1 : 0);
        hash = 53 * hash + (this.multiMemory ? 1 : 0);
        hash = 53 * hash + (this.unsafeMemory ? 1 : 0);
        hash = 53 * hash + (this.simd ? 1 : 0);
        hash = 53 * hash + (this.relaxedSimd ? 1 : 0);
        hash = 53 * hash + (this.memoryOverheadMode ? 1 : 0);
        hash = 53 * hash + (this.constantRandomGet ? 1 : 0);
        hash = 53 * hash + (this.directByteBufferMemoryAccess ? 1 : 0);
        hash = 53 * hash + this.debugCompDirectory.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WasmContextOptions other = (WasmContextOptions)obj;
        if (this.saturatingFloatToInt != other.saturatingFloatToInt) {
            return false;
        }
        if (this.signExtensionOps != other.signExtensionOps) {
            return false;
        }
        if (this.multiValue != other.multiValue) {
            return false;
        }
        if (this.bulkMemoryAndRefTypes != other.bulkMemoryAndRefTypes) {
            return false;
        }
        if (this.memory64 != other.memory64) {
            return false;
        }
        if (this.extendedConstExpressions != other.extendedConstExpressions) {
            return false;
        }
        if (this.multiMemory != other.multiMemory) {
            return false;
        }
        if (this.threads != other.threads) {
            return false;
        }
        if (this.unsafeMemory != other.unsafeMemory) {
            return false;
        }
        if (this.simd != other.simd) {
            return false;
        }
        if (this.relaxedSimd != other.relaxedSimd) {
            return false;
        }
        if (this.memoryOverheadMode != other.memoryOverheadMode) {
            return false;
        }
        if (this.constantRandomGet != other.constantRandomGet) {
            return false;
        }
        if (this.directByteBufferMemoryAccess != other.directByteBufferMemoryAccess) {
            return false;
        }
        return this.debugCompDirectory.equals(other.debugCompDirectory);
    }
}

