/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.wasm.BinaryParser;
import org.graalvm.wasm.GlobalRegistry;
import org.graalvm.wasm.Linker;
import org.graalvm.wasm.MemoryRegistry;
import org.graalvm.wasm.ModuleLimits;
import org.graalvm.wasm.TableRegistry;
import org.graalvm.wasm.WasmContextOptions;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmInstantiator;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmOptions;
import org.graalvm.wasm.WasmScope;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.parser.bytecode.BytecodeParser;
import org.graalvm.wasm.predefined.BuiltinModule;
import org.graalvm.wasm.predefined.wasi.fd.FdManager;

public final class WasmContext {
    private final TruffleLanguage.Env env;
    private final WasmLanguage language;
    private final MemoryRegistry memoryRegistry;
    private final GlobalRegistry globals;
    private final TableRegistry tableRegistry;
    private final Linker linker;
    private final Map<String, WasmInstance> moduleInstances;
    private WasmInstance mainModuleInstance;
    private final FdManager filesManager;
    private final WasmContextOptions contextOptions;
    private Object memGrowCallback;
    private Object memNotifyCallback;
    private Object memWaitCallback;
    private static final TruffleLanguage.ContextReference<WasmContext> REFERENCE = TruffleLanguage.ContextReference.create(WasmLanguage.class);

    public WasmContext(TruffleLanguage.Env env, WasmLanguage language) {
        this.env = env;
        this.language = language;
        this.contextOptions = WasmContextOptions.fromOptionValues(env.getOptions());
        this.globals = new GlobalRegistry();
        this.tableRegistry = new TableRegistry();
        this.memoryRegistry = new MemoryRegistry();
        this.moduleInstances = new LinkedHashMap<String, WasmInstance>();
        this.linker = new Linker();
        this.filesManager = new FdManager(env);
        this.instantiateBuiltinInstances();
    }

    public TruffleLanguage.Env environment() {
        return this.env;
    }

    public WasmLanguage language() {
        return this.language;
    }

    public MemoryRegistry memories() {
        return this.memoryRegistry;
    }

    public GlobalRegistry globals() {
        return this.globals;
    }

    public TableRegistry tables() {
        return this.tableRegistry;
    }

    public Linker linker() {
        return this.linker;
    }

    public Object getScope() {
        return new WasmScope(this);
    }

    public FdManager fdManager() {
        return this.filesManager;
    }

    public Map<String, WasmInstance> moduleInstances() {
        return this.moduleInstances;
    }

    @CompilerDirectives.TruffleBoundary
    public WasmInstance lookupModuleInstance(WasmModule module) {
        WasmInstance instance = this.moduleInstances.get(module.name());
        assert (instance == null || instance.module() == module);
        return instance;
    }

    @CompilerDirectives.TruffleBoundary
    public WasmInstance lookupModuleInstance(String name) {
        return this.moduleInstances.get(name);
    }

    public WasmInstance lookupMainModule() {
        return this.mainModuleInstance;
    }

    public void register(WasmInstance instance) {
        if (this.moduleInstances.containsKey(instance.name())) {
            throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Context already contains an instance named '" + instance.name() + "'.");
        }
        this.moduleInstances.put(instance.name(), instance);
        if (this.mainModuleInstance == null && !instance.isBuiltin()) {
            this.mainModuleInstance = instance;
        }
    }

    private void instantiateBuiltinInstances() {
        String[] moduleSpecs;
        String extraModuleValue = (String)WasmOptions.Builtins.getValue(this.env.getOptions());
        if (extraModuleValue.equals("")) {
            return;
        }
        for (String moduleSpec : moduleSpecs = extraModuleValue.split(",")) {
            String[] parts = moduleSpec.split(":");
            if (parts.length > 2) {
                throw WasmException.create(Failure.UNSPECIFIED_INVALID, "Module specification '" + moduleSpec + "' is not valid.");
            }
            String name = parts[0];
            String key = parts.length == 2 ? parts[1] : parts[0];
            WasmInstance module = BuiltinModule.createBuiltinInstance(this.language, this, name, key);
            this.moduleInstances.put(name, module);
        }
    }

    public WasmModule readModule(byte[] data, ModuleLimits moduleLimits) {
        return this.readModule("Unnamed", data, moduleLimits);
    }

    public WasmModule readModule(String moduleName, byte[] data, ModuleLimits moduleLimits) {
        WasmModule module = WasmModule.create(moduleName, moduleLimits);
        BinaryParser reader = new BinaryParser(module, this, data);
        reader.readModule();
        return module;
    }

    @CompilerDirectives.TruffleBoundary
    public WasmInstance readInstance(WasmModule module) {
        if (this.moduleInstances.containsKey(module.name())) {
            throw WasmException.create(Failure.UNSPECIFIED_INVALID, null, "Module " + module.name() + " is already instantiated in this context.");
        }
        if (!module.hasCodeEntries()) {
            BytecodeParser.readCodeEntries(module);
        }
        WasmInstantiator translator = new WasmInstantiator(this.language);
        WasmInstance instance = translator.createInstance(this, module, this.environment().getContext());
        module.setCodeEntries(null);
        this.register(instance);
        return instance;
    }

    public void reinitInstance(WasmInstance instance, boolean reinitMemory) {
        BytecodeParser.resetGlobalState(this, instance.module(), instance);
        if (reinitMemory) {
            BytecodeParser.resetMemoryState(this, instance.module(), instance);
            BytecodeParser.resetTableState(this, instance.module(), instance);
            Linker.runStartFunction(instance);
        }
    }

    public WasmContextOptions getContextOptions() {
        return this.contextOptions;
    }

    public static WasmContext get(Node node) {
        return (WasmContext)REFERENCE.get(node);
    }

    public void setMemGrowCallback(Object callback) {
        this.memGrowCallback = callback;
    }

    public Object getMemGrowCallback() {
        return this.memGrowCallback;
    }

    public void setMemNotifyCallback(Object callback) {
        this.memNotifyCallback = callback;
    }

    public Object getMemNotifyCallback() {
        return this.memNotifyCallback;
    }

    public void setMemWaitCallback(Object callback) {
        this.memWaitCallback = callback;
    }

    public Object getMemWaitCallback() {
        return this.memWaitCallback;
    }

    public void inheritCallbacksFromParentContext(WasmContext parent) {
        this.setMemGrowCallback(parent.getMemGrowCallback());
        this.setMemNotifyCallback(parent.getMemNotifyCallback());
        this.setMemWaitCallback(parent.getMemWaitCallback());
    }
}

