/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.util.Arrays;
import org.graalvm.wasm.Assert;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;

public abstract class BinaryStreamParser {
    protected static final int SINGLE_RESULT_VALUE = 0;
    protected static final int MULTI_RESULT_VALUE = 1;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    protected byte[] data;
    protected int offset;

    public BinaryStreamParser(byte[] data) {
        this.data = data;
        this.offset = 0;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public static long peekUnsignedInt32AndLength(byte[] data, int initialOffset) {
        int result = 0;
        int shift = 0;
        int currentOffset = initialOffset;
        int b = -128;
        while ((b & 0x80) != 0 && shift != 42) {
            b = BinaryStreamParser.peek1(data, currentOffset);
            result |= (b & 0x7F) << shift;
            shift += 7;
            ++currentOffset;
        }
        if (shift == 42) {
            throw WasmException.create(Failure.INTEGER_REPRESENTATION_TOO_LONG);
        }
        if (shift == 35 && (0x70 & b) != 0) {
            throw WasmException.create(Failure.INTEGER_TOO_LARGE);
        }
        return BinaryStreamParser.packValueAndLength(result, currentOffset - initialOffset);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public static long peekSignedInt32AndLength(byte[] data, int initialOffset) {
        int result = 0;
        int shift = 0;
        int currentOffset = initialOffset;
        int b = -128;
        while ((b & 0x80) != 0 && shift != 42) {
            b = BinaryStreamParser.peek1(data, currentOffset);
            result |= (b & 0x7F) << shift;
            shift += 7;
            ++currentOffset;
        }
        if (shift == 42) {
            throw WasmException.create(Failure.INTEGER_REPRESENTATION_TOO_LONG);
        }
        if (shift == 35 && (b & 0x70) != ((b & 8) == 0 ? 0 : 112)) {
            throw WasmException.create(Failure.INTEGER_TOO_LARGE);
        }
        if (shift != 35 && (b & 0x40) != 0) {
            result |= -1 << shift;
        }
        return BinaryStreamParser.packValueAndLength(result, currentOffset - initialOffset);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public static long peekUnsignedInt64(byte[] data, int initialOffset, boolean checkValid) {
        long result = 0L;
        int shift = 0;
        int currentOffset = initialOffset;
        int b = -128;
        while ((b & 0x80) != 0 && shift != 77) {
            b = BinaryStreamParser.peek1(data, currentOffset);
            result |= ((long)b & 0x7FL) << shift;
            shift += 7;
            ++currentOffset;
        }
        if (checkValid) {
            if (shift == 77) {
                throw WasmException.create(Failure.INTEGER_REPRESENTATION_TOO_LONG);
            }
            if (shift == 70 && (b & 0x7E) != 0) {
                throw WasmException.create(Failure.INTEGER_TOO_LARGE);
            }
        }
        return result;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public static long peekSignedInt64(byte[] data, int initialOffset, boolean checkValid) {
        long result = 0L;
        int shift = 0;
        int currentOffset = initialOffset;
        int b = -128;
        while ((b & 0x80) != 0 && shift != 77) {
            b = BinaryStreamParser.peek1(data, currentOffset);
            result |= ((long)b & 0x7FL) << shift;
            shift += 7;
            ++currentOffset;
        }
        if (checkValid) {
            if (shift == 77) {
                throw WasmException.create(Failure.INTEGER_REPRESENTATION_TOO_LONG);
            }
            if (shift == 70 && (b & 0x7E) != ((b & 1) == 0 ? 0 : 126)) {
                throw WasmException.create(Failure.INTEGER_TOO_LARGE);
            }
        }
        if (shift != 70 && (b & 0x40) != 0) {
            return result | -1L << shift;
        }
        return result;
    }

    private static long packValueAndLength(int value, int length) {
        return (long)length << 32 | (long)value & 0xFFFFFFFFL;
    }

    public static int value(long bits) {
        return (int)(bits & 0xFFFFFFFFL);
    }

    public static int length(long bits) {
        return (int)(bits >>> 32 & 0xFFFFFFFFL);
    }

    protected int readFloatAsInt32() {
        return this.read4();
    }

    protected long readFloatAsInt64() {
        return this.read8();
    }

    protected byte readMutability() {
        byte mut = this.peekMutability();
        ++this.offset;
        return mut;
    }

    protected byte peekMutability() {
        byte mut = this.peek1();
        if (mut == 0) {
            return mut;
        }
        if (mut == 1) {
            return mut;
        }
        throw Assert.fail(Failure.MALFORMED_MUTABILITY, "Invalid mutability flag: " + mut, new Object[0]);
    }

    protected byte read1() {
        byte value = BinaryStreamParser.peek1(this.data, this.offset);
        ++this.offset;
        return value;
    }

    protected byte peek1() {
        return BinaryStreamParser.peek1(this.data, this.offset);
    }

    public static byte peek1(byte[] data, int initialOffset) {
        if (initialOffset < 0 || initialOffset >= data.length) {
            throw WasmException.format(Failure.UNEXPECTED_END, "The binary is truncated at: %d", initialOffset);
        }
        return data[initialOffset];
    }

    public static short peek2(byte[] data, int initialOffset) {
        int result = 0;
        for (int i = 0; i != 2; ++i) {
            int x = Byte.toUnsignedInt(BinaryStreamParser.peek1(data, initialOffset + i));
            result |= x << 8 * i;
        }
        return (short)result;
    }

    protected int read4() {
        int result = 0;
        for (int i = 0; i != 4; ++i) {
            int x = Byte.toUnsignedInt(this.read1());
            result |= x << 8 * i;
        }
        return result;
    }

    public static int peek4(byte[] data, int initialOffset) {
        int result = 0;
        for (int i = 0; i != 4; ++i) {
            int x = Byte.toUnsignedInt(BinaryStreamParser.peek1(data, initialOffset + i));
            result |= x << 8 * i;
        }
        return result;
    }

    protected long read8() {
        long result = 0L;
        for (int i = 0; i != 8; ++i) {
            long x = Byte.toUnsignedLong(this.read1());
            result |= x << 8 * i;
        }
        return result;
    }

    public static long peek8(byte[] data, int initialOffset) {
        long result = 0L;
        for (int i = 0; i != 8; ++i) {
            long x = Byte.toUnsignedLong(BinaryStreamParser.peek1(data, initialOffset + i));
            result |= x << 8 * i;
        }
        return result;
    }

    protected int offset() {
        return this.offset;
    }

    protected void readBlockType(int[] result, boolean allowRefTypes, boolean allowVecType) {
        byte type = BinaryStreamParser.peek1(this.data, this.offset);
        switch (type) {
            case 64: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                ++this.offset;
                result[0] = type;
                result[1] = 0;
                break;
            }
            case 123: {
                Assert.assertTrue(allowVecType, Failure.MALFORMED_VALUE_TYPE);
                ++this.offset;
                result[0] = type;
                result[1] = 0;
                break;
            }
            case 111: 
            case 112: {
                Assert.assertTrue(allowRefTypes, Failure.MALFORMED_VALUE_TYPE);
                ++this.offset;
                result[0] = type;
                result[1] = 0;
                break;
            }
            default: {
                long valueAndLength = BinaryStreamParser.peekSignedInt32AndLength(this.data, this.offset);
                result[0] = BinaryStreamParser.value(valueAndLength);
                Assert.assertIntGreaterOrEqual(result[0], 0, Failure.UNSPECIFIED_MALFORMED);
                result[1] = 1;
                this.offset += BinaryStreamParser.length(valueAndLength);
            }
        }
    }

    protected static byte peekValueType(byte[] data, int offset, boolean allowRefTypes, boolean allowVecType) {
        byte b = BinaryStreamParser.peek1(data, offset);
        switch (b) {
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                break;
            }
            case 123: {
                Assert.assertTrue(allowVecType, Failure.MALFORMED_VALUE_TYPE);
                break;
            }
            case 111: 
            case 112: {
                Assert.assertTrue(allowRefTypes, Failure.MALFORMED_VALUE_TYPE);
                break;
            }
            default: {
                Assert.fail(Failure.MALFORMED_VALUE_TYPE, String.format("Invalid value type: 0x%02X", b), new Object[0]);
            }
        }
        return b;
    }

    protected byte readValueType(boolean allowRefTypes, boolean allowVecType) {
        byte b = BinaryStreamParser.peekValueType(this.data, this.offset, allowRefTypes, allowVecType);
        ++this.offset;
        return b;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public static byte peekLeb128Length(byte[] data, int initialOffset) {
        byte length;
        int currentOffset = initialOffset;
        int b = -128;
        for (length = 0; (b & 0x80) != 0 && length < 12; length = (byte)(length + 1)) {
            b = data[currentOffset];
            ++currentOffset;
        }
        return length;
    }

    public static int rawPeekU8(byte[] bytecode, int offset) {
        return bytecode[offset] & 0xFF;
    }

    public static byte rawPeekI8(byte[] bytecode, int offset) {
        return bytecode[offset];
    }

    public static int rawPeekU16(byte[] bytecode, int offset) {
        return bytecode[offset] & 0xFF | (bytecode[offset + 1] & 0xFF) << 8;
    }

    public static void writeU16(byte[] bytecode, int offset, int value) {
        byte low = (byte)(value & 0xFF);
        byte high = (byte)(value >> 8 & 0xFF);
        bytecode[offset] = low;
        bytecode[offset + 1] = high;
    }

    public static long rawPeekU32(byte[] bytecode, int offset) {
        return (long)bytecode[offset] & 0xFFL | ((long)bytecode[offset + 1] & 0xFFL) << 8 | ((long)bytecode[offset + 2] & 0xFFL) << 16 | ((long)bytecode[offset + 3] & 0xFFL) << 24;
    }

    public static int rawPeekI32(byte[] bytecode, int offset) {
        return bytecode[offset] & 0xFF | (bytecode[offset + 1] & 0xFF) << 8 | (bytecode[offset + 2] & 0xFF) << 16 | (bytecode[offset + 3] & 0xFF) << 24;
    }

    public static long rawPeekI64(byte[] bytecode, int offset) {
        return (long)bytecode[offset] & 0xFFL | ((long)bytecode[offset + 1] & 0xFFL) << 8 | ((long)bytecode[offset + 2] & 0xFFL) << 16 | ((long)bytecode[offset + 3] & 0xFFL) << 24 | ((long)bytecode[offset + 4] & 0xFFL) << 32 | ((long)bytecode[offset + 5] & 0xFFL) << 40 | ((long)bytecode[offset + 6] & 0xFFL) << 48 | ((long)bytecode[offset + 7] & 0xFFL) << 56;
    }

    public static void writeI64(byte[] bytecode, int offset, long value) {
        bytecode[offset] = (byte)(value & 0xFFL);
        bytecode[offset + 1] = (byte)(value >> 8 & 0xFFL);
        bytecode[offset + 2] = (byte)(value >> 16 & 0xFFL);
        bytecode[offset + 3] = (byte)(value >> 24 & 0xFFL);
        bytecode[offset + 4] = (byte)(value >> 32 & 0xFFL);
        bytecode[offset + 5] = (byte)(value >> 40 & 0xFFL);
        bytecode[offset + 6] = (byte)(value >> 48 & 0xFFL);
        bytecode[offset + 7] = (byte)(value >> 56 & 0xFFL);
    }

    public static byte[] rawPeekI128(byte[] bytecode, int offset) {
        return Arrays.copyOfRange(bytecode, offset, offset + 16);
    }
}

