/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.types.Filetype;

public final class Fdstat {
    public static final int BYTES = 24;

    private Fdstat() {
    }

    public static Filetype readFsFiletype(Node node, WasmMemory memory, int address) {
        return Filetype.fromValue((byte)memory.load_i32_8u(node, address + 0));
    }

    public static void writeFsFiletype(Node node, WasmMemory memory, int address, Filetype value) {
        memory.store_i32_8(node, address + 0, value.toValue());
    }

    public static short readFsFlags(Node node, WasmMemory memory, int address) {
        return (short)memory.load_i32_16u(node, address + 2);
    }

    public static void writeFsFlags(Node node, WasmMemory memory, int address, short value) {
        memory.store_i32_16(node, address + 2, value);
    }

    public static long readFsRightsBase(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 8);
    }

    public static void writeFsRightsBase(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 8, value);
    }

    public static long readFsRightsInheriting(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 16);
    }

    public static void writeFsRightsInheriting(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 16, value);
    }
}

