/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiPathOpenNode
extends WasmBuiltinRootNode {
    public WasiPathOpenNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.pathOpen(context, this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1), (Integer)WasmArguments.getArgument(args, 2), (Integer)WasmArguments.getArgument(args, 3), (short)((Integer)WasmArguments.getArgument(args, 4)).intValue(), (Long)WasmArguments.getArgument(args, 5), (Long)WasmArguments.getArgument(args, 6), (short)((Integer)WasmArguments.getArgument(args, 7)).intValue(), (Integer)WasmArguments.getArgument(args, 8));
    }

    @CompilerDirectives.TruffleBoundary
    private int pathOpen(WasmContext context, WasmMemory memory, int fd, int dirflags, int pathStart, int pathLength, short oflags, long fsRightsBase, long fsRightsInheriting, short fdflags, int fdAddress) {
        Fd handle = context.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        return handle.pathOpen((Node)this, memory, dirflags, pathStart, pathLength, oflags, fsRightsBase, fsRightsInheriting, fdflags, fdAddress).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_path_open";
    }
}

