/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.nodes.WasmCallNode;
import org.graalvm.wasm.nodes.WasmFrame;
import org.graalvm.wasm.nodes.WasmInstrumentableFunctionNode;

@NodeInfo(language="wasm", description="The root node of all WebAssembly functions")
public class WasmRootNode
extends RootNode {
    private SourceSection sourceSection;
    @Node.Child
    private WasmInstrumentableFunctionNode functionNode;
    private final BranchProfile nonLinkedProfile = BranchProfile.create();
    @CompilerDirectives.CompilationFinal
    private WasmInstance boundInstance;

    public WasmRootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor, WasmInstrumentableFunctionNode functionNode) {
        super(language, frameDescriptor);
        this.functionNode = functionNode;
    }

    protected final WasmContext getContext() {
        return WasmContext.get((Node)this);
    }

    protected WasmModule module() {
        return this.functionNode.module();
    }

    public final void tryInitialize(WasmContext context, WasmInstance instance) {
        if (!instance.isLinkCompleted()) {
            this.nonLinkedProfile.enter();
            context.linker().tryLink(instance);
        }
    }

    protected int findBytecodeIndex(Node node, Frame frame) {
        if (node == null) {
            return -1;
        }
        if (node instanceof WasmCallNode) {
            WasmCallNode n = (WasmCallNode)node;
            return n.getBytecodeOffset();
        }
        return -1;
    }

    protected final WasmInstance instance(VirtualFrame frame) {
        WasmInstance instance = this.boundInstance;
        if (instance == null) {
            instance = WasmArguments.getModuleInstance(frame.getArguments());
        } else {
            CompilerAsserts.partialEvaluationConstant((Object)instance);
            assert (instance == WasmArguments.getModuleInstance(frame.getArguments()));
        }
        assert (instance == WasmContext.get((Node)this).lookupModuleInstance(this.module()));
        return instance;
    }

    public final void setBoundModuleInstance(WasmInstance boundInstance) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.boundInstance == null);
        this.boundInstance = boundInstance;
    }

    protected final WasmMemory memory(VirtualFrame frame) {
        return this.memory(frame, 0);
    }

    protected final WasmMemory memory(VirtualFrame frame, int index) {
        return this.module().memory(this.instance(frame), index);
    }

    public Object execute(VirtualFrame frame) {
        assert (WasmArguments.isValid(frame.getArguments()));
        WasmContext context = this.getContext();
        WasmInstance instance = this.instance(frame);
        this.tryInitialize(context, instance);
        return this.executeWithContext(frame, context, instance);
    }

    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        int localCount = this.functionNode.localCount();
        this.moveArgumentsToLocals(frame);
        this.initializeLocals(frame);
        int resultCount = this.functionNode.resultCount();
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        if (resultCount > 1) {
            WasmLanguage.get((Node)this).multiValueStack().resize(resultCount);
        }
        try {
            this.functionNode.execute(frame, context, instance);
        }
        catch (StackOverflowError e) {
            this.functionNode.enterErrorBranch();
            throw WasmException.create(Failure.CALL_STACK_EXHAUSTED);
        }
        if (resultCount == 0) {
            return WasmConstant.VOID;
        }
        if (resultCount == 1) {
            byte resultType = this.functionNode.resultType(0);
            CompilerAsserts.partialEvaluationConstant((int)resultType);
            switch (resultType) {
                case 64: {
                    return WasmConstant.VOID;
                }
                case 127: {
                    return WasmFrame.popInt(frame, localCount);
                }
                case 126: {
                    return WasmFrame.popLong(frame, localCount);
                }
                case 125: {
                    return Float.valueOf(WasmFrame.popFloat(frame, localCount));
                }
                case 124: {
                    return WasmFrame.popDouble(frame, localCount);
                }
                case 123: {
                    return WasmFrame.popVector128(frame, localCount);
                }
                case 111: 
                case 112: {
                    return WasmFrame.popReference(frame, localCount);
                }
            }
            throw WasmException.format(Failure.UNSPECIFIED_INTERNAL, (Node)this, "Unknown result type: %d", resultType);
        }
        this.moveResultValuesToMultiValueStack(frame, resultCount, localCount);
        return WasmConstant.MULTI_VALUE;
    }

    @ExplodeLoop
    private void moveResultValuesToMultiValueStack(VirtualFrame frame, int resultCount, int localCount) {
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        WasmLanguage.MultiValueStack multiValueStack = WasmLanguage.get((Node)this).multiValueStack();
        long[] primitiveMultiValueStack = multiValueStack.primitiveStack();
        Object[] objectMultiValueStack = multiValueStack.objectStack();
        block8: for (int i = 0; i < resultCount; ++i) {
            byte resultType = this.functionNode.resultType(i);
            CompilerAsserts.partialEvaluationConstant((int)resultType);
            switch (resultType) {
                case 127: {
                    primitiveMultiValueStack[i] = WasmFrame.popInt(frame, localCount + i);
                    continue block8;
                }
                case 126: {
                    primitiveMultiValueStack[i] = WasmFrame.popLong(frame, localCount + i);
                    continue block8;
                }
                case 125: {
                    primitiveMultiValueStack[i] = Float.floatToRawIntBits(WasmFrame.popFloat(frame, localCount + i));
                    continue block8;
                }
                case 124: {
                    primitiveMultiValueStack[i] = Double.doubleToRawLongBits(WasmFrame.popDouble(frame, localCount + i));
                    continue block8;
                }
                case 123: {
                    objectMultiValueStack[i] = WasmFrame.popVector128(frame, localCount + i);
                    continue block8;
                }
                case 111: 
                case 112: {
                    objectMultiValueStack[i] = WasmFrame.popReference(frame, localCount + i);
                    continue block8;
                }
                default: {
                    throw WasmException.format(Failure.UNSPECIFIED_INTERNAL, (Node)this, "Unknown result type: %d", resultType);
                }
            }
        }
    }

    @ExplodeLoop
    private void moveArgumentsToLocals(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        int paramCount = this.functionNode.paramCount();
        assert (WasmArguments.getArgumentCount(args) == paramCount) : "Expected number of params " + paramCount + ", actual " + WasmArguments.getArgumentCount(args);
        block8: for (int i = 0; i != paramCount; ++i) {
            Object arg = WasmArguments.getArgument(args, i);
            byte type = this.functionNode.localType(i);
            switch (type) {
                case 127: {
                    WasmFrame.pushInt(frame, i, (Integer)arg);
                    continue block8;
                }
                case 126: {
                    WasmFrame.pushLong(frame, i, (Long)arg);
                    continue block8;
                }
                case 125: {
                    WasmFrame.pushFloat(frame, i, ((Float)arg).floatValue());
                    continue block8;
                }
                case 124: {
                    WasmFrame.pushDouble(frame, i, (Double)arg);
                    continue block8;
                }
                case 123: {
                    WasmFrame.pushVector128(frame, i, (Vector128)arg);
                    continue block8;
                }
                case 111: 
                case 112: {
                    WasmFrame.pushReference(frame, i, arg);
                }
            }
        }
    }

    @ExplodeLoop
    private void initializeLocals(VirtualFrame frame) {
        int paramCount;
        block8: for (int i = paramCount = this.functionNode.paramCount(); i != this.functionNode.localCount(); ++i) {
            byte type = this.functionNode.localType(i);
            switch (type) {
                case 127: {
                    WasmFrame.pushInt(frame, i, 0);
                    continue block8;
                }
                case 126: {
                    WasmFrame.pushLong(frame, i, 0L);
                    continue block8;
                }
                case 125: {
                    WasmFrame.pushFloat(frame, i, 0.0f);
                    continue block8;
                }
                case 124: {
                    WasmFrame.pushDouble(frame, i, 0.0);
                    continue block8;
                }
                case 123: {
                    WasmFrame.pushVector128(frame, i, Vector128.ZERO);
                    continue block8;
                }
                case 111: 
                case 112: {
                    WasmFrame.pushReference(frame, i, WasmConstant.NULL);
                }
            }
        }
    }

    public final String toString() {
        return this.getName();
    }

    public String getName() {
        if (this.functionNode == null) {
            return "function";
        }
        return this.functionNode.name();
    }

    public final String getQualifiedName() {
        if (this.functionNode == null) {
            return this.getName();
        }
        return this.functionNode.qualifiedName();
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean isInstrumentable() {
        return this.functionNode != null && this.functionNode.isInstrumentable();
    }

    @CompilerDirectives.TruffleBoundary
    public final SourceSection getSourceSection() {
        if (this.functionNode == null) {
            return null;
        }
        if (this.sourceSection == null) {
            this.sourceSection = this.functionNode.getSourceSection();
            if (this.sourceSection == null) {
                this.sourceSection = this.module().source().createUnavailableSection();
            }
        }
        return this.sourceSection;
    }
}

