/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import org.graalvm.wasm.Assert;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.memory.ByteArrayWasmMemory;
import org.graalvm.wasm.memory.NativeWasmMemory;
import org.graalvm.wasm.memory.UnsafeWasmMemory;
import org.graalvm.wasm.memory.WasmMemory;

public class WasmMemoryFactory {
    public static WasmMemory createMemory(long declaredMinSize, long declaredMaxSize, long maxAllowedSize, boolean indexType64, boolean shared, boolean unsafeMemory) {
        if (shared) {
            Assert.assertTrue(unsafeMemory, "Shared memories are only supported when UseUnsafeMemory flag is set.", Failure.SHARED_MEMORY_WITHOUT_UNSAFE);
        }
        if (unsafeMemory) {
            if (maxAllowedSize > 32767L) {
                return new NativeWasmMemory(declaredMinSize, declaredMaxSize, maxAllowedSize, indexType64, shared);
            }
            return new UnsafeWasmMemory(declaredMinSize, declaredMaxSize, maxAllowedSize, indexType64, shared);
        }
        assert (maxAllowedSize <= 32767L);
        return new ByteArrayWasmMemory(declaredMinSize, declaredMaxSize, maxAllowedSize, indexType64, shared);
    }

    public static Class<? extends WasmMemory> getMemoryImplementation(long maxAllowedSize, boolean unsafeMemory) {
        if (unsafeMemory) {
            if (maxAllowedSize > 32767L) {
                return NativeWasmMemory.class;
            }
            return UnsafeWasmMemory.class;
        }
        assert (maxAllowedSize <= 32767L);
        return ByteArrayWasmMemory.class;
    }
}

