/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.UnsafeUtilities;
import org.graalvm.wasm.memory.WasmMemory;
import sun.misc.Unsafe;

public final class UnsafeWasmMemory
extends WasmMemory {
    private long startAddress;
    private long size;
    private ByteBuffer buffer;
    private static final Unsafe unsafe;
    private static final long addressOffset;
    private static final VarHandle SIZE_FIELD;

    private UnsafeWasmMemory(long declaredMinSize, long declaredMaxSize, long initialSize, long maxAllowedSize, boolean indexType64, boolean shared) {
        super(declaredMinSize, declaredMaxSize, initialSize, maxAllowedSize, indexType64, shared);
        this.size = declaredMinSize;
        long byteSize = this.byteSize();
        this.buffer = UnsafeWasmMemory.allocateBuffer(byteSize);
        this.startAddress = UnsafeWasmMemory.getBufferAddress(this.buffer);
    }

    UnsafeWasmMemory(long declaredMinSize, long declaredMaxSize, long maxAllowedSize, boolean indexType64, boolean shared) {
        this(declaredMinSize, declaredMaxSize, declaredMinSize, maxAllowedSize, indexType64, shared);
    }

    @CompilerDirectives.TruffleBoundary
    private static ByteBuffer allocateBuffer(long byteSize) {
        assert ((long)((int)byteSize) == byteSize) : byteSize;
        try {
            return ByteBuffer.allocateDirect((int)byteSize);
        }
        catch (OutOfMemoryError error) {
            throw WasmException.create(Failure.MEMORY_ALLOCATION_FAILED);
        }
    }

    private static long getBufferAddress(ByteBuffer buffer) {
        return unsafe.getLong(buffer, addressOffset);
    }

    private void validateAddress(Node node, long address, int length) {
        assert (length >= 1);
        long byteSize = this.byteSize();
        assert (byteSize >= 0L);
        if (address < 0L || address > byteSize - (long)length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw this.trapOutOfBounds(node, address, length);
        }
    }

    private static void validateAtomicAddress(Node node, long address, int length) {
        if ((address & (long)(length - 1)) != 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsafeWasmMemory.trapUnalignedAtomic(node, address, length);
        }
    }

    @Override
    public void reset() {
        this.size = this.declaredMinSize;
        this.buffer = UnsafeWasmMemory.allocateBuffer(this.byteSize());
        this.startAddress = UnsafeWasmMemory.getBufferAddress(this.buffer);
        this.currentMinSize = this.declaredMinSize;
    }

    @Override
    public long size() {
        return SIZE_FIELD.getVolatile(this);
    }

    @Override
    public long byteSize() {
        return this.size * 65536L;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public synchronized long grow(long extraPageSize) {
        long previousSize = this.size();
        if (extraPageSize == 0L) {
            this.invokeGrowCallback();
            return previousSize;
        }
        if (Long.compareUnsigned(extraPageSize, this.maxAllowedSize) <= 0 && Long.compareUnsigned(previousSize + extraPageSize, this.maxAllowedSize) <= 0) {
            long targetByteSize = StrictMath.multiplyExact(StrictMath.addExact(previousSize, extraPageSize), 65536);
            long sourceByteSize = this.byteSize();
            ByteBuffer updatedBuffer = UnsafeWasmMemory.allocateBuffer(targetByteSize);
            long updatedStartAddress = UnsafeWasmMemory.getBufferAddress(updatedBuffer);
            long updatedSize = previousSize + extraPageSize;
            unsafe.copyMemory(this.startAddress, updatedStartAddress, sourceByteSize);
            this.buffer = updatedBuffer;
            this.startAddress = updatedStartAddress;
            this.currentMinSize = updatedSize;
            SIZE_FIELD.setVolatile(this, updatedSize);
            this.invokeGrowCallback();
            return previousSize;
        }
        return -1L;
    }

    @Override
    public int load_i32(Node node, long address) {
        this.validateAddress(node, address, 4);
        return unsafe.getInt(this.startAddress + address);
    }

    @Override
    public long load_i64(Node node, long address) {
        this.validateAddress(node, address, 8);
        return unsafe.getLong(this.startAddress + address);
    }

    @Override
    public float load_f32(Node node, long address) {
        this.validateAddress(node, address, 4);
        return unsafe.getFloat(this.startAddress + address);
    }

    @Override
    public double load_f64(Node node, long address) {
        this.validateAddress(node, address, 8);
        return unsafe.getDouble(this.startAddress + address);
    }

    @Override
    public int load_i32_8s(Node node, long address) {
        this.validateAddress(node, address, 1);
        return unsafe.getByte(this.startAddress + address);
    }

    @Override
    public int load_i32_8u(Node node, long address) {
        this.validateAddress(node, address, 1);
        return 0xFF & unsafe.getByte(this.startAddress + address);
    }

    @Override
    public int load_i32_16s(Node node, long address) {
        this.validateAddress(node, address, 2);
        return unsafe.getShort(this.startAddress + address);
    }

    @Override
    public int load_i32_16u(Node node, long address) {
        this.validateAddress(node, address, 2);
        return 0xFFFF & unsafe.getShort(this.startAddress + address);
    }

    @Override
    public long load_i64_8s(Node node, long address) {
        this.validateAddress(node, address, 1);
        return unsafe.getByte(this.startAddress + address);
    }

    @Override
    public long load_i64_8u(Node node, long address) {
        this.validateAddress(node, address, 1);
        return 0xFFL & (long)unsafe.getByte(this.startAddress + address);
    }

    @Override
    public long load_i64_16s(Node node, long address) {
        this.validateAddress(node, address, 2);
        return unsafe.getShort(this.startAddress + address);
    }

    @Override
    public long load_i64_16u(Node node, long address) {
        this.validateAddress(node, address, 2);
        return 0xFFFFL & (long)unsafe.getShort(this.startAddress + address);
    }

    @Override
    public long load_i64_32s(Node node, long address) {
        this.validateAddress(node, address, 4);
        return unsafe.getInt(this.startAddress + address);
    }

    @Override
    public long load_i64_32u(Node node, long address) {
        this.validateAddress(node, address, 4);
        return 0xFFFFFFFFL & (long)unsafe.getInt(this.startAddress + address);
    }

    @Override
    public Vector128 load_i128(Node node, long address) {
        this.validateAddress(node, address, 16);
        byte[] bytes = new byte[16];
        unsafe.copyMemory(null, this.startAddress + address, bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET, 16L);
        return new Vector128(bytes);
    }

    @Override
    public void store_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        unsafe.putInt(this.startAddress + address, value);
    }

    @Override
    public void store_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8);
        unsafe.putLong(this.startAddress + address, value);
    }

    @Override
    public void store_f32(Node node, long address, float value) {
        this.validateAddress(node, address, 4);
        unsafe.putFloat(this.startAddress + address, value);
    }

    @Override
    public void store_f64(Node node, long address, double value) {
        this.validateAddress(node, address, 8);
        unsafe.putDouble(this.startAddress + address, value);
    }

    @Override
    public void store_i32_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1);
        unsafe.putByte(this.startAddress + address, value);
    }

    @Override
    public void store_i32_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2);
        unsafe.putShort(this.startAddress + address, value);
    }

    @Override
    public void store_i64_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1);
        unsafe.putByte(this.startAddress + address, value);
    }

    @Override
    public void store_i64_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2);
        unsafe.putShort(this.startAddress + address, value);
    }

    @Override
    public void store_i64_32(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        unsafe.putInt(this.startAddress + address, value);
    }

    @Override
    public void store_i128(Node node, long address, Vector128 value) {
        this.validateAddress(node, address, 16);
        unsafe.copyMemory(value.getBytes(), Unsafe.ARRAY_BYTE_BASE_OFFSET, null, this.startAddress + address, 16L);
    }

    @Override
    public int atomic_load_i32(Node node, long address) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getIntVolatile(null, this.startAddress + address);
    }

    @Override
    public long atomic_load_i64(Node node, long address) {
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getLongVolatile(null, this.startAddress + address);
    }

    @Override
    public int atomic_load_i32_8u(Node node, long address) {
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        return 0xFF & unsafe.getByteVolatile(null, this.startAddress + address);
    }

    @Override
    public int atomic_load_i32_16u(Node node, long address) {
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        return 0xFFFF & unsafe.getShortVolatile(null, this.startAddress + address);
    }

    @Override
    public long atomic_load_i64_8u(Node node, long address) {
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        return 0xFFL & (long)unsafe.getByteVolatile(null, this.startAddress + address);
    }

    @Override
    public long atomic_load_i64_16u(Node node, long address) {
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        return 0xFFFFL & (long)unsafe.getShortVolatile(null, this.startAddress + address);
    }

    @Override
    public long atomic_load_i64_32u(Node node, long address) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return 0xFFFFFFFFL & (long)unsafe.getIntVolatile(null, this.startAddress + address);
    }

    @Override
    public void atomic_store_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        unsafe.putIntVolatile(null, this.startAddress + address, value);
    }

    @Override
    public void atomic_store_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        unsafe.putLongVolatile(null, this.startAddress + address, value);
    }

    @Override
    public void atomic_store_i32_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        unsafe.putByteVolatile(null, this.startAddress + address, value);
    }

    @Override
    public void atomic_store_i32_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        unsafe.putShortVolatile(null, this.startAddress + address, value);
    }

    @Override
    public void atomic_store_i64_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        unsafe.putByteVolatile(null, this.startAddress + address, value);
    }

    @Override
    public void atomic_store_i64_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        unsafe.putShortVolatile(null, this.startAddress + address, value);
    }

    @Override
    public void atomic_store_i64_32(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        unsafe.putIntVolatile(null, this.startAddress + address, value);
    }

    @Override
    public int atomic_rmw_add_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v + value)) != v) {
        }
        return 0xFF & v;
    }

    @Override
    public int atomic_rmw_add_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v + value)) != v) {
        }
        return 0xFFFF & v;
    }

    @Override
    public int atomic_rmw_add_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndAddInt(null, this.startAddress + address, value);
    }

    @Override
    public long atomic_rmw_add_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v + value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @Override
    public long atomic_rmw_add_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v + value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_add_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndAddInt(null, this.startAddress + address, value);
        return 0xFFFFFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_add_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndAddLong(null, this.startAddress + address, value);
    }

    @Override
    public int atomic_rmw_sub_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v - value)) != v) {
        }
        return 0xFF & v;
    }

    @Override
    public int atomic_rmw_sub_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v - value)) != v) {
        }
        return 0xFFFF & v;
    }

    @Override
    public int atomic_rmw_sub_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndAddInt(null, this.startAddress + address, -value);
    }

    @Override
    public long atomic_rmw_sub_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v - value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @Override
    public long atomic_rmw_sub_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v - value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_sub_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndAddInt(null, this.startAddress + address, -value);
        return 0xFFFFFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_sub_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndAddLong(null, this.startAddress + address, -value);
    }

    @Override
    public int atomic_rmw_and_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v & value)) != v) {
        }
        return 0xFF & v;
    }

    @Override
    public int atomic_rmw_and_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v & value)) != v) {
        }
        return 0xFFFF & v;
    }

    @Override
    public int atomic_rmw_and_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return v;
    }

    @Override
    public long atomic_rmw_and_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v & value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @Override
    public long atomic_rmw_and_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v & value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_and_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_and_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return v;
    }

    @Override
    public int atomic_rmw_or_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v | value)) != v) {
        }
        return 0xFF & v;
    }

    @Override
    public int atomic_rmw_or_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v | value)) != v) {
        }
        return 0xFFFF & v;
    }

    @Override
    public int atomic_rmw_or_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return v;
    }

    @Override
    public long atomic_rmw_or_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v | value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @Override
    public long atomic_rmw_or_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v | value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_or_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_or_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return v;
    }

    @Override
    public int atomic_rmw_xor_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v ^ value)) != v) {
        }
        return 0xFF & v;
    }

    @Override
    public int atomic_rmw_xor_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v ^ value)) != v) {
        }
        return 0xFFFF & v;
    }

    @Override
    public int atomic_rmw_xor_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return v;
    }

    @Override
    public long atomic_rmw_xor_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v ^ value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @Override
    public long atomic_rmw_xor_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v ^ value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_xor_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_xor_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return v;
    }

    @Override
    public int atomic_rmw_xchg_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFF & v;
    }

    @Override
    public int atomic_rmw_xchg_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFFF & v;
    }

    @Override
    public int atomic_rmw_xchg_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndSetInt(null, this.startAddress + address, value);
    }

    @Override
    public long atomic_rmw_xchg_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFL & (long)v;
    }

    @Override
    public long atomic_rmw_xchg_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_xchg_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndSetInt(null, this.startAddress + address, value);
        return 0xFFFFFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_xchg_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndSetLong(null, this.startAddress + address, value);
    }

    @Override
    public int atomic_rmw_cmpxchg_i32_8u(Node node, long address, byte expected, byte replacement) {
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        byte v = UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, expected, replacement);
        return 0xFF & v;
    }

    @Override
    public int atomic_rmw_cmpxchg_i32_16u(Node node, long address, short expected, short replacement) {
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        short v = UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, expected, replacement);
        return 0xFFFF & v;
    }

    @Override
    public int atomic_rmw_cmpxchg_i32(Node node, long address, int expected, int replacement) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        return UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, expected, replacement);
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_8u(Node node, long address, byte expected, byte replacement) {
        this.validateAddress(node, address, 1);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 1);
        byte v = UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, expected, replacement);
        return 0xFFL & (long)v;
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_16u(Node node, long address, short expected, short replacement) {
        this.validateAddress(node, address, 2);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 2);
        short v = UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, expected, replacement);
        return 0xFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_32u(Node node, long address, int expected, int replacement) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, expected, replacement);
        return 0xFFFFFFFFL & (long)v;
    }

    @Override
    public long atomic_rmw_cmpxchg_i64(Node node, long address, long expected, long replacement) {
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        return UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, expected, replacement);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_notify(Node node, long address, int count) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        if (!this.isShared()) {
            return 0;
        }
        return this.invokeNotifyCallback(node, address, count);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait32(Node node, long address, int expected, long timeout) {
        this.validateAddress(node, address, 4);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 4);
        if (!this.isShared()) {
            throw this.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait64(Node node, long address, long expected, long timeout) {
        this.validateAddress(node, address, 8);
        UnsafeWasmMemory.validateAtomicAddress(node, address, 8);
        if (!this.isShared()) {
            throw this.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, true);
    }

    @Override
    public void initialize(byte[] source, int sourceOffset, long destinationOffset, int length) {
        for (int i = 0; i < length; ++i) {
            unsafe.putByte(this.startAddress + destinationOffset + (long)i, source[sourceOffset + i]);
        }
    }

    @Override
    public void initializeUnsafe(long sourceAddress, int sourceOffset, long destinationOffset, int length) {
        assert (destinationOffset + (long)length <= this.byteSize());
        unsafe.copyMemory(sourceAddress + (long)sourceOffset, this.startAddress + destinationOffset, length);
    }

    @Override
    public void fill(long offset, long length, byte value) {
        assert (offset + length <= this.byteSize());
        unsafe.setMemory(this.startAddress + offset, length, value);
    }

    @Override
    public void copyFrom(WasmMemory source, long sourceOffset, long destinationOffset, long length) {
        assert (source instanceof UnsafeWasmMemory);
        assert (destinationOffset + length < this.byteSize());
        UnsafeWasmMemory s = (UnsafeWasmMemory)source;
        unsafe.copyMemory(s.startAddress + sourceOffset, this.startAddress + destinationOffset, length);
    }

    @Override
    public WasmMemory duplicate() {
        UnsafeWasmMemory other = new UnsafeWasmMemory(this.declaredMinSize, this.declaredMaxSize, this.size, this.maxAllowedSize, this.indexType64, this.shared);
        unsafe.copyMemory(this.startAddress, other.startAddress, this.byteSize());
        return other;
    }

    public void free() {
        this.buffer = null;
        this.startAddress = 0L;
        this.size = 0L;
    }

    @Override
    public boolean freed() {
        return this.startAddress == 0L;
    }

    @Override
    public void close() {
        if (!this.freed()) {
            this.free();
        }
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.buffer.duplicate();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int copyFromStream(Node node, InputStream stream, int offset, int length) throws IOException {
        if (this.outOfBounds(offset, length)) {
            throw this.trapOutOfBounds(node, offset, length);
        }
        int totalBytesRead = 0;
        for (int i = 0; i < length; ++i) {
            int byteRead = stream.read();
            if (byteRead == -1) {
                if (totalBytesRead != 0) break;
                return -1;
            }
            unsafe.putByte(this.startAddress + (long)offset + (long)i, (byte)byteRead);
            ++totalBytesRead;
        }
        return totalBytesRead;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void copyToStream(Node node, OutputStream stream, int offset, int length) throws IOException {
        if (this.outOfBounds(offset, length)) {
            throw this.trapOutOfBounds(node, offset, length);
        }
        for (int i = 0; i < length; ++i) {
            byte b = unsafe.getByte(this.startAddress + (long)offset + (long)i);
            stream.write(b & 0xFF);
        }
    }

    @Override
    public void copyToBuffer(Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
        if (this.outOfBounds(srcOffset, (long)length)) {
            throw this.trapOutOfBounds(node, srcOffset, length);
        }
        unsafe.copyMemory(null, this.startAddress + srcOffset, dst, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)dstOffset * (long)Unsafe.ARRAY_BYTE_INDEX_SCALE, length);
    }

    @Override
    public boolean isUnsafe() {
        return true;
    }

    private static long getObjectFieldOffset(Field field) {
        return unsafe.objectFieldOffset(field);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            SIZE_FIELD = lookup.findVarHandle(UnsafeWasmMemory.class, "size", Long.TYPE);
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
            Field addressField = Buffer.class.getDeclaredField("address");
            addressOffset = UnsafeWasmMemory.getObjectFieldOffset(addressField);
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

