/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;

@ExportLibrary(value=InteropLibrary.class)
public class WasmExit
extends AbstractTruffleException {
    private static final long serialVersionUID = 1787712823539392187L;
    private final int exitCode;

    @CompilerDirectives.TruffleBoundary
    public WasmExit(Node location, int exitCode) {
        super(location);
        this.exitCode = exitCode;
    }

    @CompilerDirectives.TruffleBoundary
    public String getMessage() {
        return "Program exited with status code " + this.exitCode + ".";
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return ExceptionType.EXIT;
    }

    @ExportMessage
    int getExceptionExitStatus() {
        return this.exitCode;
    }
}

