/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import com.oracle.truffle.api.source.Source;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.collection.IntArrayList;
import org.graalvm.wasm.debugging.DebugLineMap;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.parser.DebugData;
import org.graalvm.wasm.debugging.parser.DebugParser;
import org.graalvm.wasm.debugging.parser.DebugParserScope;
import org.graalvm.wasm.debugging.parser.DebugUtil;

public class DebugParserContext {
    private final byte[] data;
    private final int debugInfoOffset;
    private final EconomicMap<Integer, DebugData> entryData;
    private final EconomicMap<Integer, DebugFunction> functions;
    private final DebugParserScope globalScope;
    private final DebugLineMap[] fileLineMaps;
    private final Source[] fileSources;

    public DebugParserContext(byte[] data, int debugInfoOffset, EconomicMap<Integer, DebugData> entryData, DebugLineMap[] fileLineMaps, Source[] fileSources) {
        assert (data != null) : "the reference to the array containing the debug information (data) must not be null";
        assert (entryData != null) : "the mapping of locations in the bytecode to debug entries (entryData) must not be null";
        this.data = data;
        this.debugInfoOffset = debugInfoOffset;
        this.entryData = entryData;
        this.functions = EconomicMap.create();
        this.globalScope = DebugParserScope.createGlobalScope();
        this.fileLineMaps = fileLineMaps;
        this.fileSources = fileSources;
    }

    public DebugData dataOrNull(int offset) {
        if (offset == -1) {
            return null;
        }
        if (this.entryData.containsKey((Object)offset)) {
            return (DebugData)this.entryData.get((Object)offset);
        }
        return null;
    }

    public int sourceLocationOrDefault(int fileIndex, int lineNumber, int defaultValue) {
        if (this.fileLineMaps == null) {
            return defaultValue;
        }
        if (fileIndex >= this.fileLineMaps.length || fileIndex < 0) {
            return defaultValue;
        }
        DebugLineMap lineMap = this.fileLineMaps[fileIndex];
        int pc = lineMap.getSourceLocation(lineNumber);
        if (pc == -1) {
            return defaultValue;
        }
        return pc;
    }

    public DebugLineMap lineMapOrNull(int fileIndex) {
        if (this.fileLineMaps == null) {
            return null;
        }
        if (fileIndex >= this.fileLineMaps.length || fileIndex < 0) {
            return null;
        }
        return this.fileLineMaps[fileIndex];
    }

    public Source sourceOrNull(int fileIndex) {
        if (this.fileSources == null) {
            return null;
        }
        if (fileIndex >= this.fileSources.length || fileIndex < 0) {
            return null;
        }
        return this.fileSources[fileIndex];
    }

    public void addFunction(int sourceCodeLocation, DebugFunction function) {
        this.functions.put((Object)sourceCodeLocation, (Object)function);
    }

    public IntArrayList readRangeSectionOrNull(int rangeOffset) {
        int debugRangeOffset = DebugUtil.getRangesOffsetOrUndefined(this.data, this.debugInfoOffset);
        int debugRangeLength = DebugUtil.getRangesLengthOrUndefined(this.data, this.debugInfoOffset);
        if (debugRangeOffset == -1 || debugRangeLength == -1 || Integer.compareUnsigned(rangeOffset, debugRangeLength) >= 0) {
            return null;
        }
        return new DebugParser(this.data).readRangeSectionOrNull(debugRangeOffset + rangeOffset, debugRangeLength);
    }

    public byte[] readLocationListOrNull(int locOffset) {
        int debugLocOffset = DebugUtil.getLocOffsetOrUndefined(this.data, this.debugInfoOffset);
        int debugLocLength = DebugUtil.getLocLengthOrUndefined(this.data, this.debugInfoOffset);
        if (debugLocOffset == -1 || debugLocLength == -1 || Integer.compareUnsigned(locOffset, debugLocLength) >= 0) {
            return null;
        }
        return new DebugParser(this.data).readLocationListOrNull(debugLocOffset + locOffset, debugLocLength);
    }

    public EconomicMap<Integer, DebugFunction> functions() {
        return this.functions;
    }

    public List<DebugObject> globals() {
        return this.globalScope.variables();
    }

    public DebugParserScope globalScope() {
        return this.globalScope;
    }
}

