/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.languages.rust;

import java.util.StringJoiner;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.types.DebugSubroutineType;

public class RustFunctionType
extends DebugSubroutineType {
    public RustFunctionType(String name, DebugType returnType, DebugType[] parameterTypes) {
        super(name, returnType, parameterTypes);
    }

    @Override
    public String asTypeName() {
        StringBuilder builder = new StringBuilder();
        builder.append("fn");
        if (this.name != null) {
            builder.append(' ');
            builder.append(this.name);
        }
        builder.append(" (");
        StringJoiner joiner = new StringJoiner(", ");
        for (DebugType parameterType : this.parameterTypes) {
            joiner.add(parameterType.asTypeName());
        }
        builder.append(joiner);
        builder.append(") -> ");
        if (this.returnType != null) {
            builder.append(this.returnType.asTypeName());
        } else {
            builder.append("()");
        }
        return builder.toString();
    }
}

