/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.encoding;

public final class DataEncoding {
    private static final int NUMBER = 1;
    private static final int BOOLEAN = 2;
    private static final int STRING = 4;
    private static final int BYTE_ARRAY = 8;
    private static final int LEN_1 = 256;
    private static final int LEN_2 = 512;
    private static final int LEN_4 = 1024;
    private static final int LEN_8 = 2048;
    private static final int LEB128_SIGNED = 4096;
    private static final int LEB128_UNSIGNED = 8192;
    private static final int FLAG = 16384;
    private static final int FLOAT = 32768;
    private static final int ADDRESS = 0x1000000;
    private static final int BLOCK = 0x2000000;
    private static final int CONSTANT = 0x4000000;
    private static final int EXPRESSION = 0x8000000;
    private static final int REFERENCE = 0x10000000;
    private static final int INDIRECT = 0x20000000;
    private static final int UNSIGNED = 0x40000000;
    private static final int UNSUPPORTED = Integer.MIN_VALUE;

    private DataEncoding() {
    }

    public static boolean isNumber(int encoding) {
        return (1 & encoding) != 0;
    }

    public static boolean isBoolean(int encoding) {
        return (2 & encoding) != 0;
    }

    public static boolean isString(int encoding) {
        return (4 & encoding) != 0;
    }

    public static boolean isByteArray(int encoding) {
        return (8 & encoding) != 0;
    }

    public static boolean isLen1(int encoding) {
        return (0x100 & encoding) != 0;
    }

    public static boolean isLen2(int encoding) {
        return (0x200 & encoding) != 0;
    }

    public static boolean isLen4(int encoding) {
        return (0x400 & encoding) != 0;
    }

    public static boolean isLen8(int encoding) {
        return (0x800 & encoding) != 0;
    }

    public static boolean isLeb128Signed(int encoding) {
        return (0x1000 & encoding) != 0;
    }

    public static boolean isLeb128Unsigned(int encoding) {
        return (0x2000 & encoding) != 0;
    }

    public static boolean isFlag(int encoding) {
        return (0x4000 & encoding) != 0;
    }

    public static boolean isByte(int encoding) {
        return DataEncoding.isNumber(encoding) && DataEncoding.isLen1(encoding);
    }

    public static boolean isShort(int encoding) {
        return DataEncoding.isNumber(encoding) && DataEncoding.isLen2(encoding);
    }

    public static boolean isInt(int encoding) {
        return DataEncoding.isNumber(encoding) && (DataEncoding.isLen4(encoding) || DataEncoding.isLeb128Signed(encoding) || DataEncoding.isLeb128Unsigned(encoding)) && (0x8000 & encoding) == 0;
    }

    public static boolean isLong(int encoding) {
        return DataEncoding.isNumber(encoding) && DataEncoding.isLen8(encoding) && (0x8000 & encoding) == 0;
    }

    public static boolean isFloat(int encoding) {
        return DataEncoding.isNumber(encoding) && DataEncoding.isLen4(encoding) && (0x8000 & encoding) != 0;
    }

    public static boolean isDouble(int encoding) {
        return DataEncoding.isNumber(encoding) && DataEncoding.isLen8(encoding) && (0x8000 & encoding) != 0;
    }

    public static boolean isUnsupported(int encoding) {
        return (Integer.MIN_VALUE & encoding) != 0;
    }

    public static boolean isConstant(int encoding) {
        return (0x4000000 & encoding) != 0;
    }

    public static boolean isExpression(int encoding) {
        return (0x8000000 & encoding) != 0;
    }

    public static boolean isUnsigned(int encoding) {
        return (0x40000000 & encoding) != 0;
    }

    public static int createByte() {
        return 257;
    }

    public static int createUnsignedByte() {
        return 0x40000101;
    }

    public static int createShort() {
        return 513;
    }

    public static int createUnsignedShort() {
        return 1073742337;
    }

    public static int createInt() {
        return 1025;
    }

    public static int createUnsignedInt() {
        return 0x40000401;
    }

    public static int createLong() {
        return 2049;
    }

    public static int createUnsignedLong() {
        return 1073743873;
    }

    public static int createBoolean() {
        return 2;
    }

    public static int createFloat() {
        return 33793;
    }

    public static int createDouble() {
        return 34817;
    }

    public static int createUnsupported() {
        return Integer.MIN_VALUE;
    }

    public static int createString() {
        return 4;
    }

    public static int createByteArray() {
        return 8;
    }

    public static int fromForm(int form) {
        return switch (form) {
            case 1 -> 0x1000401;
            case 3 -> 0x2000208;
            case 4 -> 33555464;
            case 5 -> 67109377;
            case 6 -> 0x4000401;
            case 7 -> 67110913;
            case 8 -> 0x4000004;
            case 9 -> 0x2002008;
            case 10 -> 33554696;
            case 11 -> 0x4000101;
            case 12 -> 258;
            case 13 -> 0x4001001;
            case 14 -> 0x1000404;
            case 15 -> 67117057;
            case 16, 19, 23 -> 0x10000401;
            case 17 -> 0x10000101;
            case 18 -> 0x10000201;
            case 20, 32 -> 0x10000801;
            case 21 -> 0x10002001;
            case 22 -> 0x20002001;
            case 24 -> 0x8002008;
            case 25 -> 16386;
            default -> 0;
        };
    }

    private static class Forms {
        private static final int ADDR = 1;
        private static final int BLOCK2 = 3;
        private static final int BLOCK4 = 4;
        private static final int DATA2 = 5;
        private static final int DATA4 = 6;
        private static final int DATA8 = 7;
        private static final int STRING = 8;
        private static final int BLOCK = 9;
        private static final int BLOCK1 = 10;
        private static final int DATA1 = 11;
        private static final int FLAG = 12;
        private static final int SDATA = 13;
        private static final int STRP = 14;
        private static final int UDATA = 15;
        private static final int REF_ADDR = 16;
        private static final int REF1 = 17;
        private static final int REF2 = 18;
        private static final int REF4 = 19;
        private static final int REF8 = 20;
        private static final int REF_UDATA = 21;
        private static final int INDIRECT = 22;
        private static final int SEC_OFFSET = 23;
        private static final int EXPRLOC = 24;
        private static final int FLAG_PRESENT = 25;
        private static final int REF_SIG8 = 32;

        private Forms() {
        }
    }
}

