/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data;

import com.oracle.truffle.api.CompilerDirectives;

public class DebugContext {
    private final int sourceCodeLocation;
    private String elementName = null;
    private int memberBitSize = -1;
    private int memberBitOffset = -1;

    @CompilerDirectives.TruffleBoundary
    public DebugContext(int sourceCodeLocation) {
        this.sourceCodeLocation = sourceCodeLocation;
    }

    private DebugContext(String elementName, int memberBitSize, int memberBitOffset, int sourceCodeLocation) {
        this.elementName = elementName;
        this.memberBitSize = memberBitSize;
        this.memberBitOffset = memberBitOffset;
        this.sourceCodeLocation = sourceCodeLocation;
    }

    public DebugContext with(String newElementName) {
        return new DebugContext(newElementName, this.memberBitSize, this.memberBitOffset, this.sourceCodeLocation);
    }

    public DebugContext with(String newElementName, int newBitSize, int newBitOffset) {
        return new DebugContext(newElementName, newBitSize, newBitOffset, this.sourceCodeLocation);
    }

    public int sourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public String elementNameOrEmpty() {
        if (this.elementName == null) {
            return "";
        }
        return this.elementName;
    }

    public int memberBitSizeOrDefault(int defaultValue) {
        if (this.memberBitSize == -1) {
            return defaultValue;
        }
        return this.memberBitSize;
    }

    public int memberBitOffsetOrDefault(int defaultValue) {
        if (this.memberBitOffset == -1) {
            return defaultValue;
        }
        return this.memberBitOffset;
    }
}

