/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.collection;

public final class IntArrayList {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] array = null;
    private int offset = 0;

    public void add(int n) {
        this.ensureSize();
        this.array[this.offset] = n;
        ++this.offset;
    }

    public int popBack() {
        --this.offset;
        return this.array[this.offset];
    }

    public int get(int index) {
        return this.array[index];
    }

    public int size() {
        return this.offset;
    }

    private void ensureSize() {
        if (this.array == null) {
            this.array = new int[4];
        } else if (this.offset == this.array.length) {
            int[] narray = new int[this.array.length * 2];
            System.arraycopy(this.array, 0, narray, 0, this.offset);
            this.array = narray;
        }
    }

    public int[] toArray() {
        int[] result = new int[this.offset];
        if (this.array != null) {
            System.arraycopy(this.array, 0, result, 0, this.offset);
            return result;
        }
        return EMPTY_INT_ARRAY;
    }
}

